/* Generated SBE (Simple Binary Encoding) message codec */
package io.aeron.cluster.codecs;

/**
 * Mark within a snapshot.
 */
public enum SnapshotMark
{
    BEGIN(0),

    SECTION(1),

    END(2),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    SnapshotMark(final int value)
    {
        this.value = value;
    }

    public int value()
    {
        return value;
    }

    public static SnapshotMark get(final int value)
    {
        switch (value)
        {
            case 0: return BEGIN;
            case 1: return SECTION;
            case 2: return END;
        }

        if (-2147483648 == value)
        {
            return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
