/* Generated SBE (Simple Binary Encoding) message codec */
package io.aeron.cluster.codecs;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;

/**
 * Response to Snapshot recording query
 */
@SuppressWarnings("all")
public class SnapshotRecordingsEncoder
{
    public static final int BLOCK_LENGTH = 8;
    public static final int TEMPLATE_ID = 73;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 4;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final SnapshotRecordingsEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public SnapshotRecordingsEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public SnapshotRecordingsEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int correlationIdId()
    {
        return 1;
    }

    public static int correlationIdSinceVersion()
    {
        return 0;
    }

    public static int correlationIdEncodingOffset()
    {
        return 0;
    }

    public static int correlationIdEncodingLength()
    {
        return 8;
    }

    public static String correlationIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "";
            case TIME_UNIT: return "";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "required";
        }

        return "";
    }

    public static long correlationIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long correlationIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public SnapshotRecordingsEncoder correlationId(final long value)
    {
        buffer.putLong(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    private final SnapshotsEncoder snapshots = new SnapshotsEncoder(this);

    public static long snapshotsId()
    {
        return 3;
    }

    public SnapshotsEncoder snapshotsCount(final int count)
    {
        snapshots.wrap(buffer, count);
        return snapshots;
    }

    public static class SnapshotsEncoder
    {
        public static final int HEADER_SIZE = 4;
        private final SnapshotRecordingsEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;

        SnapshotsEncoder(final SnapshotRecordingsEncoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final MutableDirectBuffer buffer, final int count)
        {
            if (count < 0 || count > 65534)
            {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }

            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = -1;
            this.count = count;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + HEADER_SIZE);
            buffer.putShort(limit + 0, (short)(int)44, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putShort(limit + 2, (short)(int)count, java.nio.ByteOrder.LITTLE_ENDIAN);
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 44;
        }

        public SnapshotsEncoder next()
        {
            if (index + 1 >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + sbeBlockLength());
            ++index;

            return this;
        }

        public static int recordingIdId()
        {
            return 4;
        }

        public static int recordingIdSinceVersion()
        {
            return 0;
        }

        public static int recordingIdEncodingOffset()
        {
            return 0;
        }

        public static int recordingIdEncodingLength()
        {
            return 8;
        }

        public static String recordingIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            switch (metaAttribute)
            {
                case EPOCH: return "";
                case TIME_UNIT: return "";
                case SEMANTIC_TYPE: return "";
                case PRESENCE: return "required";
            }

            return "";
        }

        public static long recordingIdNullValue()
        {
            return -9223372036854775808L;
        }

        public static long recordingIdMinValue()
        {
            return -9223372036854775807L;
        }

        public static long recordingIdMaxValue()
        {
            return 9223372036854775807L;
        }

        public SnapshotsEncoder recordingId(final long value)
        {
            buffer.putLong(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int leadershipTermIdId()
        {
            return 5;
        }

        public static int leadershipTermIdSinceVersion()
        {
            return 0;
        }

        public static int leadershipTermIdEncodingOffset()
        {
            return 8;
        }

        public static int leadershipTermIdEncodingLength()
        {
            return 8;
        }

        public static String leadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            switch (metaAttribute)
            {
                case EPOCH: return "";
                case TIME_UNIT: return "";
                case SEMANTIC_TYPE: return "";
                case PRESENCE: return "required";
            }

            return "";
        }

        public static long leadershipTermIdNullValue()
        {
            return -9223372036854775808L;
        }

        public static long leadershipTermIdMinValue()
        {
            return -9223372036854775807L;
        }

        public static long leadershipTermIdMaxValue()
        {
            return 9223372036854775807L;
        }

        public SnapshotsEncoder leadershipTermId(final long value)
        {
            buffer.putLong(offset + 8, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int termBaseLogPositionId()
        {
            return 6;
        }

        public static int termBaseLogPositionSinceVersion()
        {
            return 0;
        }

        public static int termBaseLogPositionEncodingOffset()
        {
            return 16;
        }

        public static int termBaseLogPositionEncodingLength()
        {
            return 8;
        }

        public static String termBaseLogPositionMetaAttribute(final MetaAttribute metaAttribute)
        {
            switch (metaAttribute)
            {
                case EPOCH: return "";
                case TIME_UNIT: return "";
                case SEMANTIC_TYPE: return "";
                case PRESENCE: return "required";
            }

            return "";
        }

        public static long termBaseLogPositionNullValue()
        {
            return -9223372036854775808L;
        }

        public static long termBaseLogPositionMinValue()
        {
            return -9223372036854775807L;
        }

        public static long termBaseLogPositionMaxValue()
        {
            return 9223372036854775807L;
        }

        public SnapshotsEncoder termBaseLogPosition(final long value)
        {
            buffer.putLong(offset + 16, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int logPositionId()
        {
            return 7;
        }

        public static int logPositionSinceVersion()
        {
            return 0;
        }

        public static int logPositionEncodingOffset()
        {
            return 24;
        }

        public static int logPositionEncodingLength()
        {
            return 8;
        }

        public static String logPositionMetaAttribute(final MetaAttribute metaAttribute)
        {
            switch (metaAttribute)
            {
                case EPOCH: return "";
                case TIME_UNIT: return "";
                case SEMANTIC_TYPE: return "";
                case PRESENCE: return "required";
            }

            return "";
        }

        public static long logPositionNullValue()
        {
            return -9223372036854775808L;
        }

        public static long logPositionMinValue()
        {
            return -9223372036854775807L;
        }

        public static long logPositionMaxValue()
        {
            return 9223372036854775807L;
        }

        public SnapshotsEncoder logPosition(final long value)
        {
            buffer.putLong(offset + 24, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int timestampId()
        {
            return 8;
        }

        public static int timestampSinceVersion()
        {
            return 0;
        }

        public static int timestampEncodingOffset()
        {
            return 32;
        }

        public static int timestampEncodingLength()
        {
            return 8;
        }

        public static String timestampMetaAttribute(final MetaAttribute metaAttribute)
        {
            switch (metaAttribute)
            {
                case EPOCH: return "";
                case TIME_UNIT: return "";
                case SEMANTIC_TYPE: return "";
                case PRESENCE: return "required";
            }

            return "";
        }

        public static long timestampNullValue()
        {
            return -9223372036854775808L;
        }

        public static long timestampMinValue()
        {
            return -9223372036854775807L;
        }

        public static long timestampMaxValue()
        {
            return 9223372036854775807L;
        }

        public SnapshotsEncoder timestamp(final long value)
        {
            buffer.putLong(offset + 32, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int serviceIdId()
        {
            return 9;
        }

        public static int serviceIdSinceVersion()
        {
            return 0;
        }

        public static int serviceIdEncodingOffset()
        {
            return 40;
        }

        public static int serviceIdEncodingLength()
        {
            return 4;
        }

        public static String serviceIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            switch (metaAttribute)
            {
                case EPOCH: return "";
                case TIME_UNIT: return "";
                case SEMANTIC_TYPE: return "";
                case PRESENCE: return "required";
            }

            return "";
        }

        public static int serviceIdNullValue()
        {
            return -2147483648;
        }

        public static int serviceIdMinValue()
        {
            return -2147483647;
        }

        public static int serviceIdMaxValue()
        {
            return 2147483647;
        }

        public SnapshotsEncoder serviceId(final int value)
        {
            buffer.putInt(offset + 40, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }

    }

    public static int memberEndpointsId()
    {
        return 10;
    }

    public static String memberEndpointsCharacterEncoding()
    {
        return "US-ASCII";
    }

    public static String memberEndpointsMetaAttribute(final MetaAttribute metaAttribute)
    {
        switch (metaAttribute)
        {
            case EPOCH: return "unix";
            case TIME_UNIT: return "nanosecond";
            case SEMANTIC_TYPE: return "";
            case PRESENCE: return "required";
        }

        return "";
    }

    public static int memberEndpointsHeaderLength()
    {
        return 4;
    }

    public SnapshotRecordingsEncoder putMemberEndpoints(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, (int)length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public SnapshotRecordingsEncoder putMemberEndpoints(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, (int)length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public SnapshotRecordingsEncoder memberEndpoints(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, (int)length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public SnapshotRecordingsEncoder memberEndpoints(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, (int)length, java.nio.ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < length; ++i)
        {
            final char charValue = value.charAt(i);
            final byte byteValue = charValue > 127 ? (byte)'?' : (byte)charValue;
            buffer.putByte(limit + headerLength + i, byteValue);
        }

        return this;
    }


    public String toString()
    {
        return appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        SnapshotRecordingsDecoder writer = new SnapshotRecordingsDecoder();
        writer.wrap(buffer, offset, BLOCK_LENGTH, SCHEMA_VERSION);

        return writer.appendTo(builder);
    }
}
