/* Generated SBE (Simple Binary Encoding) message codec */
package io.aeron.cluster.codecs.mark;

/**
 * Type of Cluster Component
 */
public enum ClusterComponentType
{
    NULL(0),

    CONSENSUS_MODULE(1),

    CONTAINER(2),

    BACKUP(3),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    ClusterComponentType(final int value)
    {
        this.value = value;
    }

    public int value()
    {
        return value;
    }

    public static ClusterComponentType get(final int value)
    {
        switch (value)
        {
            case 0: return NULL;
            case 1: return CONSENSUS_MODULE;
            case 2: return CONTAINER;
            case 3: return BACKUP;
        }

        if (-2147483648 == value)
        {
            return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
