/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.exceptions.AeronException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;

public class Counter
extends AtomicCounter {
    private static final AtomicIntegerFieldUpdater<Counter> IS_CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Counter.class, "isClosed");
    private final long registrationId;
    private final ClientConductor clientConductor;
    private volatile int isClosed;

    Counter(long registrationId, ClientConductor clientConductor, AtomicBuffer buffer, int counterId) {
        super(buffer, counterId);
        this.registrationId = registrationId;
        this.clientConductor = clientConductor;
    }

    public Counter(CountersReader countersReader, long registrationId, int counterId) {
        super(countersReader.valuesBuffer(), counterId);
        if (countersReader.getCounterState(counterId) != 1) {
            throw new AeronException("Counter id is not allocated: " + counterId);
        }
        this.registrationId = registrationId;
        this.clientConductor = null;
    }

    public long registrationId() {
        return this.registrationId;
    }

    @Override
    public void close() {
        if (IS_CLOSED_UPDATER.compareAndSet(this, 0, 1)) {
            super.close();
            if (null != this.clientConductor) {
                this.clientConductor.releaseCounter(this);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return 1 == this.isClosed;
    }

    void internalClose() {
        super.close();
        this.isClosed = 1;
    }
}

