/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.command.CounterMessageFlyweight;
import io.aeron.command.DestinationMessageFlyweight;
import io.aeron.command.PublicationMessageFlyweight;
import io.aeron.command.RemoveMessageFlyweight;
import io.aeron.command.SubscriptionMessageFlyweight;
import io.aeron.command.TerminateDriverFlyweight;
import io.aeron.exceptions.AeronException;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;

public final class DriverProxy {
    private final MutableDirectBuffer buffer = new ExpandableArrayBuffer(1024);
    private final PublicationMessageFlyweight publicationMessage = new PublicationMessageFlyweight();
    private final SubscriptionMessageFlyweight subscriptionMessage = new SubscriptionMessageFlyweight();
    private final RemoveMessageFlyweight removeMessage = new RemoveMessageFlyweight();
    private final CorrelatedMessageFlyweight correlatedMessage = new CorrelatedMessageFlyweight();
    private final DestinationMessageFlyweight destinationMessage = new DestinationMessageFlyweight();
    private final CounterMessageFlyweight counterMessage = new CounterMessageFlyweight();
    private final TerminateDriverFlyweight terminateDriver = new TerminateDriverFlyweight();
    private final RingBuffer toDriverCommandBuffer;

    public DriverProxy(RingBuffer toDriverCommandBuffer, long clientId) {
        this.toDriverCommandBuffer = toDriverCommandBuffer;
        this.publicationMessage.wrap(this.buffer, 0);
        this.subscriptionMessage.wrap(this.buffer, 0);
        this.correlatedMessage.wrap(this.buffer, 0);
        this.removeMessage.wrap(this.buffer, 0);
        this.destinationMessage.wrap(this.buffer, 0);
        this.counterMessage.wrap(this.buffer, 0);
        this.terminateDriver.wrap(this.buffer, 0);
        this.correlatedMessage.clientId(clientId);
    }

    public long timeOfLastDriverKeepaliveMs() {
        return this.toDriverCommandBuffer.consumerHeartbeatTime();
    }

    public long addPublication(String channel, int streamId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.publicationMessage.correlationId(correlationId);
        this.publicationMessage.streamId(streamId).channel(channel);
        if (!this.toDriverCommandBuffer.write(1, this.buffer, 0, this.publicationMessage.length())) {
            throw new AeronException("could not write add publication command");
        }
        return correlationId;
    }

    public long addExclusivePublication(String channel, int streamId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.publicationMessage.correlationId(correlationId);
        this.publicationMessage.streamId(streamId).channel(channel);
        if (!this.toDriverCommandBuffer.write(3, this.buffer, 0, this.publicationMessage.length())) {
            throw new AeronException("could not write add exclusive publication command");
        }
        return correlationId;
    }

    public long removePublication(long registrationId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.removeMessage.registrationId(registrationId).correlationId(correlationId);
        if (!this.toDriverCommandBuffer.write(2, this.buffer, 0, RemoveMessageFlyweight.length())) {
            throw new AeronException("could not write remove publication command");
        }
        return correlationId;
    }

    public long addSubscription(String channel, int streamId) {
        long registrationId = -1L;
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.subscriptionMessage.correlationId(correlationId);
        this.subscriptionMessage.registrationCorrelationId(-1L).streamId(streamId).channel(channel);
        if (!this.toDriverCommandBuffer.write(4, this.buffer, 0, this.subscriptionMessage.length())) {
            throw new AeronException("could not write add subscription command");
        }
        return correlationId;
    }

    public long removeSubscription(long registrationId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.removeMessage.registrationId(registrationId).correlationId(correlationId);
        if (!this.toDriverCommandBuffer.write(5, this.buffer, 0, RemoveMessageFlyweight.length())) {
            throw new AeronException("could not write remove subscription message");
        }
        return correlationId;
    }

    public long addDestination(long registrationId, String endpointChannel) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.destinationMessage.registrationCorrelationId(registrationId).channel(endpointChannel).correlationId(correlationId);
        if (!this.toDriverCommandBuffer.write(7, this.buffer, 0, this.destinationMessage.length())) {
            throw new AeronException("could not write add destination command");
        }
        return correlationId;
    }

    public long removeDestination(long registrationId, String endpointChannel) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.destinationMessage.registrationCorrelationId(registrationId).channel(endpointChannel).correlationId(correlationId);
        if (!this.toDriverCommandBuffer.write(8, this.buffer, 0, this.destinationMessage.length())) {
            throw new AeronException("could not write remove destination command");
        }
        return correlationId;
    }

    public long addRcvDestination(long registrationId, String endpointChannel) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.destinationMessage.registrationCorrelationId(registrationId).channel(endpointChannel).correlationId(correlationId);
        if (!this.toDriverCommandBuffer.write(12, this.buffer, 0, this.destinationMessage.length())) {
            throw new AeronException("could not write add rcv destination command");
        }
        return correlationId;
    }

    public long removeRcvDestination(long registrationId, String endpointChannel) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.destinationMessage.registrationCorrelationId(registrationId).channel(endpointChannel).correlationId(correlationId);
        if (!this.toDriverCommandBuffer.write(13, this.buffer, 0, this.destinationMessage.length())) {
            throw new AeronException("could not write remove rcv destination command");
        }
        return correlationId;
    }

    public long addCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.counterMessage.typeId(typeId).keyBuffer(keyBuffer, keyOffset, keyLength).labelBuffer(labelBuffer, labelOffset, labelLength).correlationId(correlationId);
        if (!this.toDriverCommandBuffer.write(9, this.buffer, 0, this.counterMessage.length())) {
            throw new AeronException("could not write add counter command");
        }
        return correlationId;
    }

    public long addCounter(int typeId, String label) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.counterMessage.typeId(typeId).keyBuffer(null, 0, 0).label(label).correlationId(correlationId);
        if (!this.toDriverCommandBuffer.write(9, this.buffer, 0, this.counterMessage.length())) {
            throw new AeronException("could not write add counter command");
        }
        return correlationId;
    }

    public long removeCounter(long registrationId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.removeMessage.registrationId(registrationId).correlationId(correlationId);
        if (!this.toDriverCommandBuffer.write(10, this.buffer, 0, RemoveMessageFlyweight.length())) {
            throw new AeronException("could not write remove counter command");
        }
        return correlationId;
    }

    public void clientClose() {
        this.correlatedMessage.correlationId(-1L);
        this.toDriverCommandBuffer.write(11, this.buffer, 0, 16);
    }

    public boolean terminateDriver(DirectBuffer tokenBuffer, int tokenOffset, int tokenLength) {
        this.correlatedMessage.correlationId(-1L);
        this.terminateDriver.tokenBuffer(tokenBuffer, tokenOffset, tokenLength);
        return this.toDriverCommandBuffer.write(14, this.buffer, 0, this.terminateDriver.length());
    }
}

