/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Image;
import io.aeron.ImageFragmentAssembler;
import io.aeron.archive.ArchiveConductor;
import io.aeron.archive.ControlRequestDecoders;
import io.aeron.archive.ControlSession;
import io.aeron.archive.Session;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.codecs.AttachSegmentsRequestDecoder;
import io.aeron.archive.codecs.AuthConnectRequestDecoder;
import io.aeron.archive.codecs.BooleanType;
import io.aeron.archive.codecs.BoundedReplayRequestDecoder;
import io.aeron.archive.codecs.ChallengeResponseDecoder;
import io.aeron.archive.codecs.CloseSessionRequestDecoder;
import io.aeron.archive.codecs.ConnectRequestDecoder;
import io.aeron.archive.codecs.DeleteDetachedSegmentsRequestDecoder;
import io.aeron.archive.codecs.DetachSegmentsRequestDecoder;
import io.aeron.archive.codecs.ExtendRecordingRequest2Decoder;
import io.aeron.archive.codecs.ExtendRecordingRequestDecoder;
import io.aeron.archive.codecs.FindLastMatchingRecordingRequestDecoder;
import io.aeron.archive.codecs.KeepAliveRequestDecoder;
import io.aeron.archive.codecs.ListRecordingRequestDecoder;
import io.aeron.archive.codecs.ListRecordingSubscriptionsRequestDecoder;
import io.aeron.archive.codecs.ListRecordingsForUriRequestDecoder;
import io.aeron.archive.codecs.ListRecordingsRequestDecoder;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.MigrateSegmentsRequestDecoder;
import io.aeron.archive.codecs.PurgeSegmentsRequestDecoder;
import io.aeron.archive.codecs.RecordingPositionRequestDecoder;
import io.aeron.archive.codecs.ReplayRequestDecoder;
import io.aeron.archive.codecs.ReplicateRequestDecoder;
import io.aeron.archive.codecs.StartPositionRequestDecoder;
import io.aeron.archive.codecs.StartRecordingRequest2Decoder;
import io.aeron.archive.codecs.StartRecordingRequestDecoder;
import io.aeron.archive.codecs.StopAllReplaysRequestDecoder;
import io.aeron.archive.codecs.StopPositionRequestDecoder;
import io.aeron.archive.codecs.StopRecordingByIdentityRequestDecoder;
import io.aeron.archive.codecs.StopRecordingRequestDecoder;
import io.aeron.archive.codecs.StopRecordingSubscriptionRequestDecoder;
import io.aeron.archive.codecs.StopReplayRequestDecoder;
import io.aeron.archive.codecs.StopReplicationRequestDecoder;
import io.aeron.archive.codecs.TaggedReplicateRequestDecoder;
import io.aeron.archive.codecs.TruncateRecordingRequestDecoder;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.collections.Long2ObjectHashMap;

class ControlSessionDemuxer
implements Session,
FragmentHandler {
    private static final int FRAGMENT_LIMIT = 10;
    private final ControlRequestDecoders decoders;
    private final Image image;
    private final ArchiveConductor conductor;
    private final ImageFragmentAssembler assembler = new ImageFragmentAssembler(this);
    private final Long2ObjectHashMap<ControlSession> controlSessionByIdMap = new Long2ObjectHashMap();
    private boolean isActive = true;

    ControlSessionDemuxer(ControlRequestDecoders decoders, Image image, ArchiveConductor conductor) {
        this.decoders = decoders;
        this.image = image;
        this.conductor = conductor;
    }

    @Override
    public long sessionId() {
        return this.image.correlationId();
    }

    @Override
    public void abort() {
        this.isActive = false;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isDone() {
        return !this.isActive;
    }

    @Override
    public int doWork() {
        int workCount = 0;
        if (this.isActive && 0 == (workCount += this.image.poll(this.assembler, 10)) && this.image.isClosed()) {
            this.isActive = false;
            for (ControlSession session : this.controlSessionByIdMap.values()) {
                session.abort();
            }
        }
        return workCount;
    }

    @Override
    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        MessageHeaderDecoder headerDecoder = this.decoders.header;
        headerDecoder.wrap(buffer, offset);
        int schemaId = headerDecoder.schemaId();
        if (schemaId != 101) {
            throw new ArchiveException("expected schemaId=101, actual=" + schemaId);
        }
        switch (headerDecoder.templateId()) {
            case 2: {
                ConnectRequestDecoder decoder = this.decoders.connectRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                ControlSession session = this.conductor.newControlSession(decoder.correlationId(), decoder.responseStreamId(), decoder.version(), decoder.responseChannel(), ArrayUtil.EMPTY_BYTE_ARRAY, this);
                this.controlSessionByIdMap.put(session.sessionId(), session);
                break;
            }
            case 3: {
                CloseSessionRequestDecoder decoder = this.decoders.closeSessionRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long controlSessionId = decoder.controlSessionId();
                ControlSession session = this.controlSessionByIdMap.get(controlSessionId);
                if (null == session) break;
                session.abort();
                break;
            }
            case 4: {
                StartRecordingRequestDecoder decoder = this.decoders.startRecordingRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onStartRecording(correlationId, decoder.streamId(), decoder.sourceLocation(), false, decoder.channel());
                break;
            }
            case 5: {
                StopRecordingRequestDecoder decoder = this.decoders.stopRecordingRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onStopRecording(correlationId, decoder.streamId(), decoder.channel());
                break;
            }
            case 6: {
                ReplayRequestDecoder decoder = this.decoders.replayRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onStartReplay(correlationId, decoder.recordingId(), decoder.position(), decoder.length(), decoder.replayStreamId(), decoder.replayChannel());
                break;
            }
            case 7: {
                StopReplayRequestDecoder decoder = this.decoders.stopReplayRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onStopReplay(correlationId, decoder.replaySessionId());
                break;
            }
            case 8: {
                ListRecordingsRequestDecoder decoder = this.decoders.listRecordingsRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onListRecordings(correlationId, decoder.fromRecordingId(), decoder.recordCount());
                break;
            }
            case 9: {
                ListRecordingsForUriRequestDecoder decoder = this.decoders.listRecordingsForUriRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                int channelLength = decoder.channelLength();
                byte[] bytes = 0 == channelLength ? ArrayUtil.EMPTY_BYTE_ARRAY : new byte[channelLength];
                decoder.getChannel(bytes, 0, channelLength);
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onListRecordingsForUri(correlationId, decoder.fromRecordingId(), decoder.recordCount(), decoder.streamId(), bytes);
                break;
            }
            case 10: {
                ListRecordingRequestDecoder decoder = this.decoders.listRecordingRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onListRecording(correlationId, decoder.recordingId());
                break;
            }
            case 11: {
                ExtendRecordingRequestDecoder decoder = this.decoders.extendRecordingRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onExtendRecording(correlationId, decoder.recordingId(), decoder.streamId(), decoder.sourceLocation(), false, decoder.channel());
                break;
            }
            case 12: {
                RecordingPositionRequestDecoder decoder = this.decoders.recordingPositionRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onGetRecordingPosition(correlationId, decoder.recordingId());
                break;
            }
            case 13: {
                TruncateRecordingRequestDecoder decoder = this.decoders.truncateRecordingRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onTruncateRecording(correlationId, decoder.recordingId(), decoder.position());
                break;
            }
            case 14: {
                StopRecordingSubscriptionRequestDecoder decoder = this.decoders.stopRecordingSubscriptionRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onStopRecordingSubscription(correlationId, decoder.subscriptionId());
                break;
            }
            case 15: {
                StopPositionRequestDecoder decoder = this.decoders.stopPositionRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onGetStopPosition(correlationId, decoder.recordingId());
                break;
            }
            case 16: {
                FindLastMatchingRecordingRequestDecoder decoder = this.decoders.findLastMatchingRecordingRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                int channelLength = decoder.channelLength();
                byte[] bytes = 0 == channelLength ? ArrayUtil.EMPTY_BYTE_ARRAY : new byte[channelLength];
                decoder.getChannel(bytes, 0, channelLength);
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onFindLastMatchingRecording(correlationId, decoder.minRecordingId(), decoder.sessionId(), decoder.streamId(), bytes);
                break;
            }
            case 17: {
                ListRecordingSubscriptionsRequestDecoder decoder = this.decoders.listRecordingSubscriptionsRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onListRecordingSubscriptions(correlationId, decoder.pseudoIndex(), decoder.subscriptionCount(), decoder.applyStreamId() == BooleanType.TRUE, decoder.streamId(), decoder.channel());
                break;
            }
            case 18: {
                BoundedReplayRequestDecoder decoder = this.decoders.boundedReplayRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onStartBoundedReplay(correlationId, decoder.recordingId(), decoder.position(), decoder.length(), decoder.limitCounterId(), decoder.replayStreamId(), decoder.replayChannel());
                break;
            }
            case 19: {
                StopAllReplaysRequestDecoder decoder = this.decoders.stopAllReplaysRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onStopAllReplays(correlationId, decoder.recordingId());
                break;
            }
            case 50: {
                ReplicateRequestDecoder decoder = this.decoders.replicateRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onReplicate(correlationId, decoder.srcRecordingId(), decoder.dstRecordingId(), decoder.srcControlStreamId(), decoder.srcControlChannel(), decoder.liveDestination());
                break;
            }
            case 51: {
                StopReplicationRequestDecoder decoder = this.decoders.stopReplicationRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onStopReplication(correlationId, decoder.replicationId());
                break;
            }
            case 52: {
                StartPositionRequestDecoder decoder = this.decoders.startPositionRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onGetStartPosition(correlationId, decoder.recordingId());
                break;
            }
            case 53: {
                DetachSegmentsRequestDecoder decoder = this.decoders.detachSegmentsRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onDetachSegments(correlationId, decoder.recordingId(), decoder.newStartPosition());
                break;
            }
            case 54: {
                DeleteDetachedSegmentsRequestDecoder decoder = this.decoders.deleteDetachedSegmentsRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onDeleteDetachedSegments(correlationId, decoder.recordingId());
                break;
            }
            case 55: {
                PurgeSegmentsRequestDecoder decoder = this.decoders.purgeSegmentsRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onPurgeSegments(correlationId, decoder.recordingId(), decoder.newStartPosition());
                break;
            }
            case 56: {
                AttachSegmentsRequestDecoder decoder = this.decoders.attachSegmentsRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onAttachSegments(correlationId, decoder.recordingId());
                break;
            }
            case 57: {
                MigrateSegmentsRequestDecoder decoder = this.decoders.migrateSegmentsRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onMigrateSegments(correlationId, decoder.srcRecordingId(), decoder.dstRecordingId());
                break;
            }
            case 58: {
                byte[] credentials;
                AuthConnectRequestDecoder decoder = this.decoders.authConnectRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                String responseChannel = decoder.responseChannel();
                int credentialsLength = decoder.encodedCredentialsLength();
                if (credentialsLength > 0) {
                    credentials = new byte[credentialsLength];
                    decoder.getEncodedCredentials(credentials, 0, credentialsLength);
                } else {
                    credentials = ArrayUtil.EMPTY_BYTE_ARRAY;
                }
                ControlSession session = this.conductor.newControlSession(decoder.correlationId(), decoder.responseStreamId(), decoder.version(), responseChannel, credentials, this);
                this.controlSessionByIdMap.put(session.sessionId(), session);
                break;
            }
            case 60: {
                byte[] credentials;
                ChallengeResponseDecoder decoder = this.decoders.challengeResponse;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long controlSessionId = decoder.controlSessionId();
                ControlSession session = this.controlSessionByIdMap.get(controlSessionId);
                if (null == session) break;
                int credentialsLength = decoder.encodedCredentialsLength();
                if (credentialsLength > 0) {
                    credentials = new byte[credentialsLength];
                    decoder.getEncodedCredentials(credentials, 0, credentialsLength);
                } else {
                    credentials = ArrayUtil.EMPTY_BYTE_ARRAY;
                }
                session.onChallengeResponse(decoder.correlationId(), credentials);
                break;
            }
            case 61: {
                KeepAliveRequestDecoder decoder = this.decoders.keepAliveRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onKeepAlive(correlationId);
                break;
            }
            case 62: {
                TaggedReplicateRequestDecoder decoder = this.decoders.taggedReplicateRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onReplicateTagged(correlationId, decoder.srcRecordingId(), decoder.dstRecordingId(), decoder.channelTagId(), decoder.subscriptionTagId(), decoder.srcControlStreamId(), decoder.srcControlChannel(), decoder.liveDestination());
                break;
            }
            case 63: {
                StartRecordingRequest2Decoder decoder = this.decoders.startRecordingRequest2;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onStartRecording(correlationId, decoder.streamId(), decoder.sourceLocation(), decoder.autoStop() == BooleanType.TRUE, decoder.channel());
                break;
            }
            case 64: {
                ExtendRecordingRequest2Decoder decoder = this.decoders.extendRecordingRequest2;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onExtendRecording(correlationId, decoder.recordingId(), decoder.streamId(), decoder.sourceLocation(), decoder.autoStop() == BooleanType.TRUE, decoder.channel());
                break;
            }
            case 65: {
                StopRecordingByIdentityRequestDecoder decoder = this.decoders.stopRecordingByIdentityRequest;
                decoder.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
                long correlationId = decoder.correlationId();
                long controlSessionId = decoder.controlSessionId();
                ControlSession controlSession = this.getControlSession(controlSessionId, correlationId);
                controlSession.onStopRecordingByIdentity(correlationId, decoder.recordingId());
                break;
            }
        }
    }

    void removeControlSession(ControlSession controlSession) {
        this.controlSessionByIdMap.remove(controlSession.sessionId());
    }

    private ControlSession getControlSession(long controlSessionId, long correlationId) {
        ControlSession controlSession = this.controlSessionByIdMap.get(controlSessionId);
        if (controlSession == null) {
            String message = "unknown controlSessionId=" + controlSessionId + " for correlationId=" + correlationId + " from source=" + this.image.sourceIdentity();
            throw new ArchiveException(message, correlationId, AeronException.Category.WARN);
        }
        return controlSession;
    }
}

