/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.AbstractListRecordingsSession;
import io.aeron.archive.Catalog;
import io.aeron.archive.ControlResponseProxy;
import io.aeron.archive.ControlSession;
import io.aeron.archive.codecs.RecordingDescriptorDecoder;
import org.agrona.concurrent.UnsafeBuffer;

class ListRecordingsForUriSession
extends AbstractListRecordingsSession {
    private long recordingId;
    private int sent = 0;
    private final int count;
    private final int streamId;
    private final byte[] channelFragment;
    private final RecordingDescriptorDecoder decoder;

    ListRecordingsForUriSession(long correlationId, long fromRecordingId, int count, byte[] channelFragment, int streamId, Catalog catalog, ControlResponseProxy proxy, ControlSession controlSession, UnsafeBuffer descriptorBuffer, RecordingDescriptorDecoder recordingDescriptorDecoder) {
        super(correlationId, catalog, proxy, controlSession, descriptorBuffer);
        this.recordingId = fromRecordingId;
        this.count = count;
        this.streamId = streamId;
        this.channelFragment = channelFragment;
        this.decoder = recordingDescriptorDecoder;
    }

    @Override
    protected int sendDescriptors() {
        int totalBytesSent = 0;
        for (int recordsScanned = 0; this.sent < this.count && recordsScanned < 256; ++recordsScanned) {
            if (!this.catalog.wrapDescriptor(this.recordingId, this.descriptorBuffer)) {
                this.controlSession.sendRecordingUnknown(this.correlationId, this.recordingId, this.proxy);
                this.isDone = true;
                break;
            }
            this.decoder.wrap(this.descriptorBuffer, 32, 80, 4);
            if (Catalog.isValidDescriptor(this.descriptorBuffer) && this.decoder.streamId() == this.streamId && Catalog.originalChannelContains(this.decoder, this.channelFragment)) {
                int bytesSent = this.controlSession.sendDescriptor(this.correlationId, this.descriptorBuffer, this.proxy);
                if (bytesSent == 0) {
                    this.isDone = this.controlSession.isDone();
                    break;
                }
                totalBytesSent += bytesSent;
                ++this.sent;
            }
            ++this.recordingId;
        }
        if (this.sent >= this.count) {
            this.isDone = true;
        }
        return totalBytesSent;
    }
}

