/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Image;
import io.aeron.archive.Archive;
import io.aeron.archive.checksum.Checksum;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ArchiveException;
import io.aeron.logbuffer.BlockHandler;
import io.aeron.logbuffer.FrameDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.concurrent.CountedErrorHandler;
import org.agrona.concurrent.UnsafeBuffer;

final class RecordingWriter
implements BlockHandler,
AutoCloseable {
    private final long recordingId;
    private final int segmentLength;
    private final boolean forceWrites;
    private final boolean forceMetadata;
    private final UnsafeBuffer checksumBuffer;
    private final Checksum checksum;
    private final FileChannel archiveDirChannel;
    private final File archiveDir;
    private final CountedErrorHandler countedErrorHandler;
    private long segmentBasePosition;
    private int segmentOffset;
    private FileChannel recordingFileChannel;
    private boolean isClosed = false;

    RecordingWriter(long recordingId, long startPosition, int segmentLength, Image image, Archive.Context ctx, FileChannel archiveDirChannel, UnsafeBuffer checksumBuffer, Checksum checksum) {
        this.recordingId = recordingId;
        this.archiveDirChannel = archiveDirChannel;
        this.segmentLength = segmentLength;
        this.archiveDir = ctx.archiveDir();
        this.forceWrites = ctx.fileSyncLevel() > 0;
        this.forceMetadata = ctx.fileSyncLevel() > 1;
        this.countedErrorHandler = ctx.countedErrorHandler();
        this.checksumBuffer = checksumBuffer;
        this.checksum = checksum;
        int termLength = image.termBufferLength();
        long joinPosition = image.joinPosition();
        this.segmentBasePosition = AeronArchive.segmentFileBasePosition(startPosition, joinPosition, termLength, segmentLength);
        this.segmentOffset = (int)(joinPosition - this.segmentBasePosition);
    }

    @Override
    public void onBlock(DirectBuffer termBuffer, int termOffset, int length, int sessionId, int termId) {
        try {
            ByteBuffer byteBuffer;
            int dataLength;
            boolean isPaddingFrame = termBuffer.getShort(FrameDescriptor.typeOffset(termOffset)) == 0;
            int n = dataLength = isPaddingFrame ? 32 : length;
            if (null == this.checksum || isPaddingFrame) {
                byteBuffer = termBuffer.byteBuffer();
                byteBuffer.limit(termOffset + dataLength).position(termOffset);
            } else {
                this.checksumBuffer.putBytes(0, termBuffer, termOffset, dataLength);
                this.computeChecksum(this.checksum, this.checksumBuffer, dataLength);
                byteBuffer = this.checksumBuffer.byteBuffer();
                byteBuffer.limit(dataLength).position(0);
            }
            int fileOffset = this.segmentOffset;
            do {
                fileOffset += this.recordingFileChannel.write(byteBuffer, fileOffset);
            } while (byteBuffer.remaining() > 0);
            if (this.forceWrites) {
                this.recordingFileChannel.force(this.forceMetadata);
            }
            this.segmentOffset += length;
            if (this.segmentOffset >= this.segmentLength) {
                this.onFileRollOver();
            }
        }
        catch (ClosedByInterruptException ex) {
            this.close();
            throw new ArchiveException("file closed by interrupt, recording aborted", (Throwable)ex, 0);
        }
        catch (Throwable ex) {
            this.close();
            LangUtil.rethrowUnchecked(ex);
        }
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            CloseHelper.close(this.countedErrorHandler, this.recordingFileChannel);
        }
    }

    boolean isClosed() {
        return this.isClosed;
    }

    long position() {
        return this.segmentBasePosition + (long)this.segmentOffset;
    }

    void init() throws IOException {
        this.openRecordingSegmentFile();
        if (this.segmentOffset != 0) {
            this.recordingFileChannel.position(this.segmentOffset);
        }
    }

    private void computeChecksum(Checksum checksum, UnsafeBuffer buffer, int length) {
        int alignedLength;
        long address = buffer.addressOffset();
        for (int frameOffset = 0; frameOffset < length; frameOffset += alignedLength) {
            alignedLength = BitUtil.align(FrameDescriptor.frameLength(buffer, frameOffset), 32);
            int computedChecksum = checksum.compute(address, frameOffset + 32, alignedLength - 32);
            FrameDescriptor.frameSessionId(buffer, frameOffset, computedChecksum);
        }
    }

    private void openRecordingSegmentFile() {
        File file = new File(this.archiveDir, Archive.segmentFileName(this.recordingId, this.segmentBasePosition));
        RandomAccessFile recordingFile = null;
        try {
            recordingFile = new RandomAccessFile(file, "rw");
            recordingFile.setLength(this.segmentLength);
            this.recordingFileChannel = recordingFile.getChannel();
            if (this.forceWrites && null != this.archiveDirChannel) {
                this.archiveDirChannel.force(this.forceMetadata);
            }
        }
        catch (IOException ex) {
            CloseHelper.close(recordingFile);
            this.close();
            LangUtil.rethrowUnchecked(ex);
        }
    }

    private void onFileRollOver() {
        CloseHelper.close(this.recordingFileChannel);
        this.segmentOffset = 0;
        this.segmentBasePosition += (long)this.segmentLength;
        this.openRecordingSegmentFile();
    }
}

