/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.checksum;

import io.aeron.archive.checksum.Checksum;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.zip.CRC32;
import org.agrona.LangUtil;

final class Crc32
implements Checksum {
    private static final MethodHandle UPDATE_BYTE_BUFFER;
    public static final Crc32 INSTANCE;

    private static Method lookupMethod(String name) {
        try {
            return CRC32.class.getDeclaredMethod(name, Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }

    private Crc32() {
    }

    @Override
    public int compute(long address, int offset, int length) {
        try {
            return UPDATE_BYTE_BUFFER.invokeExact(address, offset, length);
        }
        catch (Throwable throwable) {
            LangUtil.rethrowUnchecked(throwable);
            return -1;
        }
    }

    static {
        Method method = Crc32.lookupMethod("updateByteBuffer0");
        if (null == method && null == (method = Crc32.lookupMethod("updateByteBuffer"))) {
            throw new Error("Failed to find method to compute a checksum from a ByteBuffer on " + CRC32.class.getName() + " class.");
        }
        try {
            method.setAccessible(true);
            MethodHandle methodHandle = MethodHandles.lookup().unreflect(method);
            UPDATE_BYTE_BUFFER = methodHandle = MethodHandles.insertArguments(methodHandle, 0, 0);
        }
        catch (Exception ex) {
            throw new Error("Failed to acquire method handle for " + method, ex);
        }
        INSTANCE = new Crc32();
    }
}

