/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.Subscription;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.RecordingProgressDecoder;
import io.aeron.archive.codecs.RecordingStartedDecoder;
import io.aeron.archive.codecs.RecordingStoppedDecoder;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;

public class RecordingEventsPoller
implements FragmentHandler {
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final RecordingStartedDecoder recordingStartedDecoder = new RecordingStartedDecoder();
    private final RecordingProgressDecoder recordingProgressDecoder = new RecordingProgressDecoder();
    private final RecordingStoppedDecoder recordingStoppedDecoder = new RecordingStoppedDecoder();
    private final Subscription subscription;
    private int templateId;
    private boolean pollComplete;
    private long recordingId;
    private long recordingStartPosition;
    private long recordingPosition;
    private long recordingStopPosition;

    public RecordingEventsPoller(Subscription subscription) {
        this.subscription = subscription;
    }

    public int poll() {
        this.templateId = -1;
        this.pollComplete = false;
        return this.subscription.poll(this, 1);
    }

    public boolean isPollComplete() {
        return this.pollComplete;
    }

    public int templateId() {
        return this.templateId;
    }

    public long recordingId() {
        return this.recordingId;
    }

    public long recordingStartPosition() {
        return this.recordingStartPosition;
    }

    public long recordingPosition() {
        return this.recordingPosition;
    }

    public long recordingStopPosition() {
        return this.recordingStopPosition;
    }

    @Override
    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 101) {
            throw new ArchiveException("expected schemaId=101, actual=" + schemaId);
        }
        this.templateId = this.messageHeaderDecoder.templateId();
        switch (this.templateId) {
            case 101: {
                this.recordingStartedDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.recordingId = this.recordingStartedDecoder.recordingId();
                this.recordingPosition = this.recordingStartPosition = this.recordingStartedDecoder.startPosition();
                this.recordingStopPosition = -1L;
                this.pollComplete = true;
                break;
            }
            case 102: {
                this.recordingProgressDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.recordingId = this.recordingProgressDecoder.recordingId();
                this.recordingStartPosition = this.recordingProgressDecoder.startPosition();
                this.recordingPosition = this.recordingProgressDecoder.position();
                this.recordingStopPosition = -1L;
                this.pollComplete = true;
                break;
            }
            case 103: {
                this.recordingStoppedDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.recordingId = this.recordingStoppedDecoder.recordingId();
                this.recordingStartPosition = this.recordingStoppedDecoder.startPosition();
                this.recordingPosition = this.recordingStopPosition = this.recordingStoppedDecoder.stopPosition();
                this.pollComplete = true;
            }
        }
    }
}

