/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.ChannelUri;
import io.aeron.CommonContext;
import io.aeron.Counter;
import io.aeron.archive.client.AeronArchive;
import io.aeron.cluster.ClusterBackupAgent;
import io.aeron.cluster.ClusterBackupEventsListener;
import io.aeron.cluster.ClusterMember;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.client.AeronCluster;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.mark.ClusterComponentType;
import io.aeron.cluster.service.ClusterCounters;
import io.aeron.cluster.service.ClusterMarkFile;
import io.aeron.cluster.service.ClusteredServiceContainer;
import io.aeron.exceptions.ConcurrentConcludeException;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Supplier;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.SystemUtil;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.CountedErrorHandler;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NoOpLock;
import org.agrona.concurrent.ShutdownSignalBarrier;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.errors.DistinctErrorLog;
import org.agrona.concurrent.errors.LoggingErrorHandler;
import org.agrona.concurrent.status.AtomicCounter;

public final class ClusterBackup
implements AutoCloseable {
    public static final int BACKUP_STATE_TYPE_ID = 208;
    public static final int LIVE_LOG_POSITION_TYPE_ID = 209;
    public static final int QUERY_DEADLINE_TYPE_ID = 210;
    public static final int CLUSTER_BACKUP_ERROR_COUNT_TYPE_ID = 211;
    private final Context ctx;
    private final AgentInvoker agentInvoker;
    private final AgentRunner agentRunner;

    private ClusterBackup(Context ctx) {
        try {
            ctx.conclude();
            this.ctx = ctx;
            ClusterBackupAgent clusterBackupAgent = new ClusterBackupAgent(ctx);
            if (ctx.useAgentInvoker()) {
                this.agentRunner = null;
                this.agentInvoker = new AgentInvoker(ctx.errorHandler(), ctx.errorCounter(), clusterBackupAgent);
            } else {
                this.agentRunner = new AgentRunner(ctx.idleStrategy(), ctx.errorHandler(), ctx.errorCounter(), clusterBackupAgent);
                this.agentInvoker = null;
            }
        }
        catch (ConcurrentConcludeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            CloseHelper.quietClose(ctx::close);
            throw ex;
        }
    }

    public static ClusterBackup launch() {
        return ClusterBackup.launch(new Context());
    }

    public static ClusterBackup launch(Context ctx) {
        ClusterBackup clusterBackup = new ClusterBackup(ctx);
        if (null != clusterBackup.agentRunner) {
            AgentRunner.startOnThread(clusterBackup.agentRunner, ctx.threadFactory());
        } else {
            clusterBackup.agentInvoker.start();
        }
        return clusterBackup;
    }

    public Context context() {
        return this.ctx;
    }

    public AgentInvoker conductorAgentInvoker() {
        return this.agentInvoker;
    }

    @Override
    public void close() {
        CountedErrorHandler countedErrorHandler = this.ctx.countedErrorHandler();
        CloseHelper.close(countedErrorHandler, this.agentRunner);
        CloseHelper.close(countedErrorHandler, this.agentInvoker);
    }

    public static class Context {
        private static final AtomicIntegerFieldUpdater<Context> IS_CONCLUDED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Context.class, "isConcluded");
        private volatile int isConcluded;
        private boolean ownsAeronClient = false;
        private String aeronDirectoryName = CommonContext.getAeronDirectoryName();
        private Aeron aeron;
        private int clusterId = ClusteredServiceContainer.Configuration.clusterId();
        private String consensusChannel = Configuration.CONSENSUS_CHANNEL_DEFAULT;
        private int consensusStreamId = ConsensusModule.Configuration.consensusStreamId();
        private int consensusModuleSnapshotStreamId = ConsensusModule.Configuration.snapshotStreamId();
        private int serviceSnapshotStreamId = ClusteredServiceContainer.Configuration.snapshotStreamId();
        private int logStreamId = ConsensusModule.Configuration.logStreamId();
        private String catchupEndpoint = Configuration.CATCHUP_ENDPOINT_DEFAULT;
        private long clusterBackupIntervalNs = Configuration.clusterBackupIntervalNs();
        private long clusterBackupResponseTimeoutNs = Configuration.clusterBackupResponseTimeoutNs();
        private long clusterBackupProgressTimeoutNs = Configuration.clusterBackupProgressTimeoutNs();
        private long clusterBackupCoolDownIntervalNs = Configuration.clusterBackupCoolDownIntervalNs();
        private int errorBufferLength = ConsensusModule.Configuration.errorBufferLength();
        private boolean deleteDirOnStart = false;
        private boolean useAgentInvoker = false;
        private String clusterDirectoryName = ClusteredServiceContainer.Configuration.clusterDirName();
        private File clusterDir;
        private ClusterMarkFile markFile;
        private String clusterConsensusEndpoints = ConsensusModule.Configuration.clusterConsensusEndpoints();
        private ThreadFactory threadFactory;
        private EpochClock epochClock;
        private Supplier<IdleStrategy> idleStrategySupplier;
        private DistinctErrorLog errorLog;
        private ErrorHandler errorHandler;
        private AtomicCounter errorCounter;
        private CountedErrorHandler countedErrorHandler;
        private Counter stateCounter;
        private Counter liveLogPositionCounter;
        private Counter nextQueryDeadlineMsCounter;
        private AeronArchive.Context archiveContext;
        private ShutdownSignalBarrier shutdownSignalBarrier;
        private Runnable terminationHook;
        private ClusterBackupEventsListener eventsListener;

        public Context clone() {
            try {
                return (Context)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void conclude() {
            if (0 != IS_CONCLUDED_UPDATER.getAndSet(this, 1)) {
                throw new ConcurrentConcludeException();
            }
            if (null == this.clusterDir) {
                this.clusterDir = new File(this.clusterDirectoryName);
            }
            if (this.deleteDirOnStart) {
                IoUtil.delete(this.clusterDir, false);
            }
            if (!this.clusterDir.exists() && !this.clusterDir.mkdirs()) {
                throw new ClusterException("failed to create cluster dir: " + this.clusterDir.getAbsolutePath());
            }
            if (null == this.epochClock) {
                this.epochClock = SystemEpochClock.INSTANCE;
            }
            if (null == this.markFile) {
                this.markFile = new ClusterMarkFile(new File(this.clusterDir, "cluster-mark.dat"), ClusterComponentType.BACKUP, this.errorBufferLength, this.epochClock, 0L);
            }
            if (null == this.errorLog) {
                this.errorLog = new DistinctErrorLog(this.markFile.errorBuffer(), this.epochClock, StandardCharsets.US_ASCII);
            }
            if (null == this.errorHandler) {
                this.errorHandler = new LoggingErrorHandler(this.errorLog);
            }
            if (null == this.aeron) {
                this.ownsAeronClient = true;
                this.aeron = Aeron.connect(new Aeron.Context().aeronDirectoryName(this.aeronDirectoryName).errorHandler(this.errorHandler).epochClock(this.epochClock).useConductorAgentInvoker(true).clientLock(NoOpLock.INSTANCE));
                if (null == this.errorCounter) {
                    this.errorCounter = ClusterCounters.allocate(this.aeron, "ClusterBackup errors", 211, this.clusterId);
                }
            }
            if (null == this.aeron.conductorAgentInvoker()) {
                throw new ClusterException("Aeron client must use conductor agent invoker");
            }
            if (null == this.errorCounter) {
                throw new ClusterException("error counter must be supplied if aeron client is");
            }
            if (null == this.countedErrorHandler) {
                this.countedErrorHandler = new CountedErrorHandler(this.errorHandler, this.errorCounter);
                if (this.ownsAeronClient) {
                    this.aeron.context().errorHandler(this.countedErrorHandler);
                }
            }
            if (null == this.stateCounter) {
                this.stateCounter = ClusterCounters.allocate(this.aeron, "ClusterBackup State", 208, this.clusterId);
            }
            if (null == this.liveLogPositionCounter) {
                this.liveLogPositionCounter = ClusterCounters.allocate(this.aeron, "ClusterBackup live log position", 209, this.clusterId);
            }
            if (null == this.nextQueryDeadlineMsCounter) {
                this.nextQueryDeadlineMsCounter = ClusterCounters.allocate(this.aeron, "ClusterBackup next query deadline (ms)", 210, this.clusterId);
            }
            if (null == this.threadFactory) {
                this.threadFactory = Thread::new;
            }
            if (null == this.idleStrategySupplier) {
                this.idleStrategySupplier = ClusteredServiceContainer.Configuration.idleStrategySupplier(null);
            }
            if (null == this.archiveContext) {
                this.archiveContext = new AeronArchive.Context().controlRequestChannel(AeronArchive.Configuration.localControlChannel()).controlResponseChannel(AeronArchive.Configuration.localControlChannel()).controlRequestStreamId(AeronArchive.Configuration.localControlStreamId());
            }
            this.archiveContext.aeron(this.aeron).errorHandler(this.errorHandler).ownsAeronClient(false).lock(NoOpLock.INSTANCE);
            if (null == this.shutdownSignalBarrier) {
                this.shutdownSignalBarrier = new ShutdownSignalBarrier();
            }
            if (null == this.terminationHook) {
                this.terminationHook = () -> this.shutdownSignalBarrier.signalAll();
            }
            this.concludeMarkFile();
        }

        public Context aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public Aeron aeron() {
            return this.aeron;
        }

        public Context aeronDirectoryName(String aeronDirectoryName) {
            this.aeronDirectoryName = aeronDirectoryName;
            return this;
        }

        public String aeronDirectoryName() {
            return this.aeronDirectoryName;
        }

        public Context ownsAeronClient(boolean ownsAeronClient) {
            this.ownsAeronClient = ownsAeronClient;
            return this;
        }

        public boolean ownsAeronClient() {
            return this.ownsAeronClient;
        }

        public Context deleteDirOnStart(boolean deleteDirOnStart) {
            this.deleteDirOnStart = deleteDirOnStart;
            return this;
        }

        public boolean deleteDirOnStart() {
            return this.deleteDirOnStart;
        }

        public Context clusterId(int clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public int clusterId() {
            return this.clusterId;
        }

        public Context clusterDirectoryName(String clusterDirectoryName) {
            this.clusterDirectoryName = clusterDirectoryName;
            return this;
        }

        public String clusterDirectoryName() {
            return this.clusterDirectoryName;
        }

        public Context clusterDir(File clusterDir) {
            this.clusterDir = clusterDir;
            return this;
        }

        public File clusterDir() {
            return this.clusterDir;
        }

        public Context archiveContext(AeronArchive.Context archiveContext) {
            this.archiveContext = archiveContext;
            return this;
        }

        public AeronArchive.Context archiveContext() {
            return this.archiveContext;
        }

        public ThreadFactory threadFactory() {
            return this.threadFactory;
        }

        public Context threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Context idleStrategySupplier(Supplier<IdleStrategy> idleStrategySupplier) {
            this.idleStrategySupplier = idleStrategySupplier;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategySupplier.get();
        }

        public Context epochClock(EpochClock clock) {
            this.epochClock = clock;
            return this;
        }

        public EpochClock epochClock() {
            return this.epochClock;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public AtomicCounter errorCounter() {
            return this.errorCounter;
        }

        public Context errorCounter(AtomicCounter errorCounter) {
            this.errorCounter = errorCounter;
            return this;
        }

        public Context countedErrorHandler(CountedErrorHandler countedErrorHandler) {
            this.countedErrorHandler = countedErrorHandler;
            return this;
        }

        public CountedErrorHandler countedErrorHandler() {
            return this.countedErrorHandler;
        }

        public Context consensusChannel(String channel) {
            this.consensusChannel = channel;
            return this;
        }

        public String consensusChannel() {
            return this.consensusChannel;
        }

        public Context consensusStreamId(int streamId) {
            this.consensusStreamId = streamId;
            return this;
        }

        public int consensusStreamId() {
            return this.consensusStreamId;
        }

        public Context consensusModuleSnapshotStreamId(int streamId) {
            this.consensusModuleSnapshotStreamId = streamId;
            return this;
        }

        public int consensusModuleSnapshotStreamId() {
            return this.consensusModuleSnapshotStreamId;
        }

        public Context serviceSnapshotStreamId(int streamId) {
            this.serviceSnapshotStreamId = streamId;
            return this;
        }

        public int serviceSnapshotStreamId() {
            return this.serviceSnapshotStreamId;
        }

        public Context logStreamId(int streamId) {
            this.logStreamId = streamId;
            return this;
        }

        public int logStreamId() {
            return this.logStreamId;
        }

        public Context catchupEndpoint(String catchupEndpoint) {
            this.catchupEndpoint = catchupEndpoint;
            return this;
        }

        public String catchupEndpoint() {
            return this.catchupEndpoint;
        }

        public Context clusterBackupIntervalNs(long clusterBackupIntervalNs) {
            this.clusterBackupIntervalNs = clusterBackupIntervalNs;
            return this;
        }

        public long clusterBackupIntervalNs() {
            return this.clusterBackupIntervalNs;
        }

        public Context clusterBackupResponseTimeoutNs(long clusterBackupResponseTimeoutNs) {
            this.clusterBackupResponseTimeoutNs = clusterBackupResponseTimeoutNs;
            return this;
        }

        public long clusterBackupResponseTimeoutNs() {
            return this.clusterBackupResponseTimeoutNs;
        }

        public Context clusterBackupProgressTimeoutNs(long clusterBackupProgressTimeoutNs) {
            this.clusterBackupProgressTimeoutNs = clusterBackupProgressTimeoutNs;
            return this;
        }

        public long clusterBackupProgressTimeoutNs() {
            return this.clusterBackupProgressTimeoutNs;
        }

        public Context clusterBackupCoolDownIntervalNs(long clusterBackupCoolDownIntervalNs) {
            this.clusterBackupCoolDownIntervalNs = clusterBackupCoolDownIntervalNs;
            return this;
        }

        public long clusterBackupCoolDownIntervalNs() {
            return this.clusterBackupCoolDownIntervalNs;
        }

        public Context clusterConsensusEndpoints(String endpoints) {
            this.clusterConsensusEndpoints = endpoints;
            return this;
        }

        public String clusterConsensusEndpoints() {
            return this.clusterConsensusEndpoints;
        }

        public Context shutdownSignalBarrier(ShutdownSignalBarrier barrier) {
            this.shutdownSignalBarrier = barrier;
            return this;
        }

        public ShutdownSignalBarrier shutdownSignalBarrier() {
            return this.shutdownSignalBarrier;
        }

        public Context terminationHook(Runnable terminationHook) {
            this.terminationHook = terminationHook;
            return this;
        }

        public Runnable terminationHook() {
            return this.terminationHook;
        }

        public Context clusterMarkFile(ClusterMarkFile markFile) {
            this.markFile = markFile;
            return this;
        }

        public ClusterMarkFile clusterMarkFile() {
            return this.markFile;
        }

        public Context errorBufferLength(int errorBufferLength) {
            this.errorBufferLength = errorBufferLength;
            return this;
        }

        public int errorBufferLength() {
            return this.errorBufferLength;
        }

        public Context errorLog(DistinctErrorLog errorLog) {
            this.errorLog = errorLog;
            return this;
        }

        public DistinctErrorLog errorLog() {
            return this.errorLog;
        }

        public Counter stateCounter() {
            return this.stateCounter;
        }

        public Context stateCounter(Counter stateCounter) {
            this.stateCounter = stateCounter;
            return this;
        }

        public Counter liveLogPositionCounter() {
            return this.liveLogPositionCounter;
        }

        public Context liveLogPositionCounter(Counter liveLogPositionCounter) {
            this.liveLogPositionCounter = liveLogPositionCounter;
            return this;
        }

        public Counter nextQueryDeadlineMsCounter() {
            return this.nextQueryDeadlineMsCounter;
        }

        public Context nextQueryDeadlineMsCounter(Counter nextQueryDeadlineMsCounter) {
            this.nextQueryDeadlineMsCounter = nextQueryDeadlineMsCounter;
            return this;
        }

        public ClusterBackupEventsListener eventsListener() {
            return this.eventsListener;
        }

        public Context eventsListener(ClusterBackupEventsListener eventsListener) {
            this.eventsListener = eventsListener;
            return this;
        }

        public Context useAgentInvoker(boolean useAgentInvoker) {
            this.useAgentInvoker = useAgentInvoker;
            return this;
        }

        public boolean useAgentInvoker() {
            return this.useAgentInvoker;
        }

        public void deleteDirectory() {
            if (null != this.clusterDir) {
                IoUtil.delete(this.clusterDir, false);
            }
        }

        public void close() {
            if (this.ownsAeronClient) {
                CloseHelper.close(this.countedErrorHandler, this.aeron);
            } else {
                CloseHelper.close(this.countedErrorHandler, this.stateCounter);
                CloseHelper.close(this.countedErrorHandler, this.liveLogPositionCounter);
            }
            CloseHelper.close(this.countedErrorHandler, this.markFile);
        }

        private void concludeMarkFile() {
            ClusterMarkFile.checkHeaderLength(this.aeron.context().aeronDirectoryName(), null, null, null, null);
            this.markFile.encoder().archiveStreamId(this.archiveContext.controlRequestStreamId()).serviceStreamId(ClusteredServiceContainer.Configuration.serviceStreamId()).consensusModuleStreamId(ClusteredServiceContainer.Configuration.consensusModuleStreamId()).ingressStreamId(AeronCluster.Configuration.ingressStreamId()).memberId(-1).serviceId(-1).clusterId(ClusteredServiceContainer.Configuration.clusterId()).aeronDirectory(this.aeron.context().aeronDirectoryName()).controlChannel(null).ingressChannel(null).serviceName(null).authenticator(null);
            this.markFile.updateActivityTimestamp(this.epochClock.time());
            this.markFile.signalReady();
        }
    }

    public static class Configuration {
        public static final String CONSENSUS_CHANNEL_DEFAULT;
        public static final String CATCHUP_ENDPOINT_DEFAULT;
        public static final String CLUSTER_BACKUP_INTERVAL_PROP_NAME = "aeron.cluster.backup.interval";
        public static final long CLUSTER_BACKUP_INTERVAL_DEFAULT_NS;
        public static final String CLUSTER_BACKUP_RESPONSE_TIMEOUT_PROP_NAME = "aeron.cluster.backup.response.timeout";
        public static final long CLUSTER_BACKUP_RESPONSE_TIMEOUT_DEFAULT_NS;
        public static final String CLUSTER_BACKUP_PROGRESS_TIMEOUT_PROP_NAME = "aeron.cluster.backup.progress.timeout";
        public static final String CLUSTER_BACKUP_COOL_DOWN_INTERVAL_PROP_NAME = "aeron.cluster.backup.cool.down.interval";
        public static final long CLUSTER_BACKUP_COOL_DOWN_INTERVAL_DEFAULT_NS;
        public static final long CLUSTER_BACKUP_PROGRESS_TIMEOUT_DEFAULT_NS;

        public static long clusterBackupIntervalNs() {
            return SystemUtil.getDurationInNanos(CLUSTER_BACKUP_INTERVAL_PROP_NAME, CLUSTER_BACKUP_INTERVAL_DEFAULT_NS);
        }

        public static long clusterBackupResponseTimeoutNs() {
            return SystemUtil.getDurationInNanos(CLUSTER_BACKUP_RESPONSE_TIMEOUT_PROP_NAME, CLUSTER_BACKUP_RESPONSE_TIMEOUT_DEFAULT_NS);
        }

        public static long clusterBackupProgressTimeoutNs() {
            return SystemUtil.getDurationInNanos(CLUSTER_BACKUP_PROGRESS_TIMEOUT_PROP_NAME, CLUSTER_BACKUP_PROGRESS_TIMEOUT_DEFAULT_NS);
        }

        public static long clusterBackupCoolDownIntervalNs() {
            return SystemUtil.getDurationInNanos(CLUSTER_BACKUP_COOL_DOWN_INTERVAL_PROP_NAME, CLUSTER_BACKUP_COOL_DOWN_INTERVAL_DEFAULT_NS);
        }

        static {
            CLUSTER_BACKUP_INTERVAL_DEFAULT_NS = TimeUnit.HOURS.toNanos(1L);
            CLUSTER_BACKUP_RESPONSE_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(2L);
            CLUSTER_BACKUP_COOL_DOWN_INTERVAL_DEFAULT_NS = TimeUnit.SECONDS.toNanos(30L);
            CLUSTER_BACKUP_PROGRESS_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(10L);
            ClusterMember[] clusterMembers = ClusterMember.parse(ConsensusModule.Configuration.clusterMembers());
            Int2ObjectHashMap<ClusterMember> clusterMemberByIdMap = new Int2ObjectHashMap<ClusterMember>();
            ClusterMember.addClusterMemberIds(clusterMembers, clusterMemberByIdMap);
            ClusterMember member = ClusterMember.determineMember(clusterMembers, ConsensusModule.Configuration.clusterMemberId(), ConsensusModule.Configuration.memberEndpoints());
            ChannelUri consensusUri = ChannelUri.parse(ConsensusModule.Configuration.consensusChannel());
            consensusUri.put("endpoint", member.consensusEndpoint());
            CONSENSUS_CHANNEL_DEFAULT = consensusUri.toString();
            CATCHUP_ENDPOINT_DEFAULT = member.catchupEndpoint();
        }
    }

    public static enum State {
        INIT(0),
        BACKUP_QUERY(1),
        SNAPSHOT_LENGTH_RETRIEVE(2),
        SNAPSHOT_RETRIEVE(3),
        LIVE_LOG_REPLAY(4),
        UPDATE_RECORDING_LOG(5),
        RESET_BACKUP(6),
        BACKING_UP(7);

        static final State[] STATES;
        private final int code;

        private State(int code) {
            if (code != this.ordinal()) {
                throw new IllegalArgumentException(this.name() + " - code must equal ordinal value: code=" + code);
            }
            this.code = code;
        }

        public int code() {
            return this.code;
        }

        public static State get(long code) {
            if (code < 0L || code > (long)(STATES.length - 1)) {
                throw new ClusterException("invalid state counter code: " + code);
            }
            return STATES[(int)code];
        }

        static {
            STATES = State.values();
        }
    }
}

