/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.Publication;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.CloseReason;
import io.aeron.cluster.codecs.EventCode;
import io.aeron.driver.exceptions.InvalidChannelException;
import io.aeron.logbuffer.BufferClaim;
import java.util.Arrays;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.collections.ArrayUtil;

class ClusterSession {
    static final byte[] NULL_PRINCIPAL = ArrayUtil.EMPTY_BYTE_ARRAY;
    static final int MAX_ENCODED_PRINCIPAL_LENGTH = 4096;
    static final int MAX_ENCODED_MEMBERSHIP_QUERY_LENGTH = 4096;
    private boolean hasNewLeaderEventPending = false;
    private final long id;
    private long correlationId;
    private long openedLogPosition = -1L;
    private long closedLogPosition = -1L;
    private long timeOfLastActivityNs;
    private boolean isBackupSession = false;
    private final int responseStreamId;
    private final String responseChannel;
    private Publication responsePublication;
    private State state;
    private String responseDetail = null;
    private EventCode eventCode = null;
    private CloseReason closeReason = CloseReason.NULL_VAL;
    private byte[] encodedPrincipal = NULL_PRINCIPAL;

    ClusterSession(long sessionId, int responseStreamId, String responseChannel) {
        this.id = sessionId;
        this.responseStreamId = responseStreamId;
        this.responseChannel = responseChannel;
        this.state(State.INIT);
    }

    ClusterSession(long id, long correlationId, long openedLogPosition, long timeOfLastActivityNs, int responseStreamId, String responseChannel, CloseReason closeReason) {
        this.id = id;
        this.responseStreamId = responseStreamId;
        this.responseChannel = responseChannel;
        this.openedLogPosition = openedLogPosition;
        this.timeOfLastActivityNs = timeOfLastActivityNs;
        this.correlationId = correlationId;
        this.closeReason = closeReason;
        if (CloseReason.NULL_VAL != closeReason) {
            this.state(State.CLOSED);
        } else {
            this.state(State.OPEN);
        }
    }

    public void close(ErrorHandler errorHandler) {
        CloseHelper.close(errorHandler, this.responsePublication);
        this.responsePublication = null;
        this.state(State.CLOSED);
    }

    long id() {
        return this.id;
    }

    int responseStreamId() {
        return this.responseStreamId;
    }

    String responseChannel() {
        return this.responseChannel;
    }

    void closing(CloseReason closeReason) {
        this.closeReason = closeReason;
        this.state(State.CLOSING);
    }

    CloseReason closeReason() {
        return this.closeReason;
    }

    void connect(Aeron aeron) {
        if (null != this.responsePublication) {
            throw new ClusterException("response publication already added");
        }
        try {
            this.responsePublication = aeron.addPublication(this.responseChannel, this.responseStreamId);
        }
        catch (InvalidChannelException invalidChannelException) {
            // empty catch block
        }
    }

    void disconnect(ErrorHandler errorHandler) {
        CloseHelper.close(errorHandler, this.responsePublication);
        this.responsePublication = null;
    }

    boolean isResponsePublicationConnected() {
        return null != this.responsePublication && this.responsePublication.isConnected();
    }

    public long tryClaim(int length, BufferClaim bufferClaim) {
        if (null == this.responsePublication) {
            return -1L;
        }
        return this.responsePublication.tryClaim(length, bufferClaim);
    }

    public long offer(DirectBuffer buffer, int offset, int length) {
        if (null == this.responsePublication) {
            return -1L;
        }
        return this.responsePublication.offer(buffer, offset, length);
    }

    State state() {
        return this.state;
    }

    void state(State newState) {
        this.state = newState;
    }

    void authenticate(byte[] encodedPrincipal) {
        if (encodedPrincipal != null) {
            this.encodedPrincipal = encodedPrincipal;
        }
        this.state(State.AUTHENTICATED);
    }

    void open(long openedLogPosition) {
        this.openedLogPosition = openedLogPosition;
        this.state(State.OPEN);
        this.encodedPrincipal = null;
    }

    byte[] encodedPrincipal() {
        return this.encodedPrincipal;
    }

    void lastActivityNs(long timeNs, long correlationId) {
        this.timeOfLastActivityNs = timeNs;
        this.correlationId = correlationId;
    }

    void reject(EventCode code, String responseDetail) {
        this.state(State.REJECTED);
        this.eventCode = code;
        this.responseDetail = responseDetail;
    }

    EventCode eventCode() {
        return this.eventCode;
    }

    String responseDetail() {
        return this.responseDetail;
    }

    long timeOfLastActivityNs() {
        return this.timeOfLastActivityNs;
    }

    void timeOfLastActivityNs(long timeNs) {
        this.timeOfLastActivityNs = timeNs;
    }

    long correlationId() {
        return this.correlationId;
    }

    long openedLogPosition() {
        return this.openedLogPosition;
    }

    void closedLogPosition(long closedLogPosition) {
        this.closedLogPosition = closedLogPosition;
    }

    long closedLogPosition() {
        return this.closedLogPosition;
    }

    void hasNewLeaderEventPending(boolean flag) {
        this.hasNewLeaderEventPending = flag;
    }

    boolean hasNewLeaderEventPending() {
        return this.hasNewLeaderEventPending;
    }

    boolean isBackupSession() {
        return this.isBackupSession;
    }

    void markAsBackupSession() {
        this.isBackupSession = true;
    }

    Publication responsePublication() {
        return this.responsePublication;
    }

    static void checkEncodedPrincipalLength(byte[] encodedPrincipal) {
        if (null != encodedPrincipal && encodedPrincipal.length > 4096) {
            throw new ClusterException("encoded principal max length 4096 exceeded: length=" + encodedPrincipal.length);
        }
    }

    public String toString() {
        return "ClusterSession{id=" + this.id + ", correlationId=" + this.correlationId + ", openedLogPosition=" + this.openedLogPosition + ", closedLogPosition=" + this.closedLogPosition + ", timeOfLastActivityNs=" + this.timeOfLastActivityNs + ", responseStreamId=" + this.responseStreamId + ", responseChannel='" + this.responseChannel + '\'' + ", closeReason=" + (Object)((Object)this.closeReason) + ", state=" + (Object)((Object)this.state) + ", hasNewLeaderEventPending=" + this.hasNewLeaderEventPending + ", encodedPrincipal=" + Arrays.toString(this.encodedPrincipal) + '}';
    }

    static enum State {
        INIT,
        CONNECTED,
        CHALLENGED,
        AUTHENTICATED,
        REJECTED,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

