/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.ExclusivePublication;
import io.aeron.Publication;
import io.aeron.cluster.RecordingLog;
import io.aeron.cluster.codecs.AddPassiveMemberEncoder;
import io.aeron.cluster.codecs.AppendPositionEncoder;
import io.aeron.cluster.codecs.BackupQueryEncoder;
import io.aeron.cluster.codecs.BackupResponseEncoder;
import io.aeron.cluster.codecs.BooleanType;
import io.aeron.cluster.codecs.CanvassPositionEncoder;
import io.aeron.cluster.codecs.CatchupPositionEncoder;
import io.aeron.cluster.codecs.ClusterMembersChangeEncoder;
import io.aeron.cluster.codecs.CommitPositionEncoder;
import io.aeron.cluster.codecs.JoinClusterEncoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.NewLeadershipTermEncoder;
import io.aeron.cluster.codecs.RequestVoteEncoder;
import io.aeron.cluster.codecs.SnapshotRecordingQueryEncoder;
import io.aeron.cluster.codecs.SnapshotRecordingsEncoder;
import io.aeron.cluster.codecs.StopCatchupEncoder;
import io.aeron.cluster.codecs.TerminationAckEncoder;
import io.aeron.cluster.codecs.TerminationPositionEncoder;
import io.aeron.cluster.codecs.VoteEncoder;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.BufferClaim;
import org.agrona.ExpandableArrayBuffer;

class ConsensusPublisher {
    private static final int SEND_ATTEMPTS = 3;
    private final ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
    private final BufferClaim bufferClaim = new BufferClaim();
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final CanvassPositionEncoder canvassPositionEncoder = new CanvassPositionEncoder();
    private final RequestVoteEncoder requestVoteEncoder = new RequestVoteEncoder();
    private final VoteEncoder voteEncoder = new VoteEncoder();
    private final NewLeadershipTermEncoder newLeadershipTermEncoder = new NewLeadershipTermEncoder();
    private final AppendPositionEncoder appendPositionEncoder = new AppendPositionEncoder();
    private final CommitPositionEncoder commitPositionEncoder = new CommitPositionEncoder();
    private final CatchupPositionEncoder catchupPositionEncoder = new CatchupPositionEncoder();
    private final StopCatchupEncoder stopCatchupEncoder = new StopCatchupEncoder();
    private final AddPassiveMemberEncoder addPassiveMemberEncoder = new AddPassiveMemberEncoder();
    private final ClusterMembersChangeEncoder clusterMembersChangeEncoder = new ClusterMembersChangeEncoder();
    private final SnapshotRecordingQueryEncoder snapshotRecordingQueryEncoder = new SnapshotRecordingQueryEncoder();
    private final SnapshotRecordingsEncoder snapshotRecordingsEncoder = new SnapshotRecordingsEncoder();
    private final JoinClusterEncoder joinClusterEncoder = new JoinClusterEncoder();
    private final TerminationPositionEncoder terminationPositionEncoder = new TerminationPositionEncoder();
    private final TerminationAckEncoder terminationAckEncoder = new TerminationAckEncoder();
    private final BackupQueryEncoder backupQueryEncoder = new BackupQueryEncoder();
    private final BackupResponseEncoder backupResponseEncoder = new BackupResponseEncoder();

    ConsensusPublisher() {
    }

    void canvassPosition(ExclusivePublication publication, long logLeadershipTermId, long logPosition, int followerMemberId) {
        int length = 28;
        int attempts = 3;
        do {
            long result;
            if ((result = publication.tryClaim(28, this.bufferClaim)) > 0L) {
                this.canvassPositionEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).logLeadershipTermId(logLeadershipTermId).logPosition(logPosition).followerMemberId(followerMemberId);
                this.bufferClaim.commit();
                return;
            }
            ConsensusPublisher.checkResult(result);
        } while (--attempts > 0);
    }

    boolean requestVote(ExclusivePublication publication, long logLeadershipTermId, long logPosition, long candidateTermId, int candidateMemberId) {
        int length = 36;
        int attempts = 3;
        do {
            long result;
            if ((result = publication.tryClaim(36, this.bufferClaim)) > 0L) {
                this.requestVoteEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).logLeadershipTermId(logLeadershipTermId).logPosition(logPosition).candidateTermId(candidateTermId).candidateMemberId(candidateMemberId);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    void placeVote(ExclusivePublication publication, long candidateTermId, long logLeadershipTermId, long logPosition, int candidateMemberId, int followerMemberId, boolean vote) {
        int length = 44;
        int attempts = 3;
        do {
            long result;
            if ((result = publication.tryClaim(44, this.bufferClaim)) > 0L) {
                this.voteEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).candidateTermId(candidateTermId).logLeadershipTermId(logLeadershipTermId).logPosition(logPosition).candidateMemberId(candidateMemberId).followerMemberId(followerMemberId).vote(vote ? BooleanType.TRUE : BooleanType.FALSE);
                this.bufferClaim.commit();
                return;
            }
            ConsensusPublisher.checkResult(result);
        } while (--attempts > 0);
    }

    void newLeadershipTerm(ExclusivePublication publication, long logLeadershipTermId, long logTruncatePosition, long leadershipTermId, long logPosition, long timestamp, int leaderMemberId, int logSessionId, boolean isStartup) {
        int length = 64;
        int attempts = 3;
        do {
            long result;
            if ((result = publication.tryClaim(64, this.bufferClaim)) > 0L) {
                this.newLeadershipTermEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).logLeadershipTermId(logLeadershipTermId).logTruncatePosition(logTruncatePosition).leadershipTermId(leadershipTermId).logPosition(logPosition).timestamp(timestamp).leaderMemberId(leaderMemberId).logSessionId(logSessionId).isStartup(isStartup ? BooleanType.TRUE : BooleanType.FALSE);
                this.bufferClaim.commit();
                return;
            }
            ConsensusPublisher.checkResult(result);
        } while (--attempts > 0);
    }

    boolean appendPosition(ExclusivePublication publication, long leadershipTermId, long logPosition, int followerMemberId) {
        int length = 28;
        int attempts = 3;
        do {
            long result;
            if ((result = publication.tryClaim(28, this.bufferClaim)) > 0L) {
                this.appendPositionEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).logPosition(logPosition).followerMemberId(followerMemberId);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    void commitPosition(ExclusivePublication publication, long leadershipTermId, long logPosition, int leaderMemberId) {
        int length = 28;
        int attempts = 3;
        do {
            long result;
            if ((result = publication.tryClaim(28, this.bufferClaim)) > 0L) {
                this.commitPositionEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).logPosition(logPosition).leaderMemberId(leaderMemberId);
                this.bufferClaim.commit();
                return;
            }
            ConsensusPublisher.checkResult(result);
        } while (--attempts > 0);
    }

    boolean catchupPosition(ExclusivePublication publication, long leadershipTermId, long logPosition, int followerMemberId) {
        int length = 28;
        int attempts = 3;
        do {
            long result;
            if ((result = publication.tryClaim(28, this.bufferClaim)) > 0L) {
                this.catchupPositionEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).logPosition(logPosition).followerMemberId(followerMemberId);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    boolean stopCatchup(ExclusivePublication publication, long leadershipTermId, int followerMemberId) {
        int length = 20;
        int attempts = 3;
        do {
            long result;
            if ((result = publication.tryClaim(20, this.bufferClaim)) > 0L) {
                this.stopCatchupEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).followerMemberId(followerMemberId);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    boolean addPassiveMember(ExclusivePublication publication, long correlationId, String memberEndpoints) {
        int length = 16 + AddPassiveMemberEncoder.memberEndpointsHeaderLength() + memberEndpoints.length();
        int attempts = 3;
        do {
            long result;
            if ((result = publication.tryClaim(length, this.bufferClaim)) > 0L) {
                this.addPassiveMemberEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId).memberEndpoints(memberEndpoints);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    boolean clusterMemberChange(ExclusivePublication publication, long correlationId, int leaderMemberId, String activeMembers, String passiveMembers) {
        int length = 20 + ClusterMembersChangeEncoder.activeMembersHeaderLength() + activeMembers.length() + ClusterMembersChangeEncoder.passiveMembersHeaderLength() + passiveMembers.length();
        int attempts = 3;
        do {
            long result;
            if ((result = publication.tryClaim(length, this.bufferClaim)) > 0L) {
                this.clusterMembersChangeEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId).leaderMemberId(leaderMemberId).activeMembers(activeMembers).passiveMembers(passiveMembers);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    boolean snapshotRecordingQuery(ExclusivePublication publication, long correlationId, int requestMemberId) {
        int length = 20;
        int attempts = 3;
        do {
            long result;
            if ((result = publication.tryClaim(20, this.bufferClaim)) > 0L) {
                this.snapshotRecordingQueryEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId).requestMemberId(requestMemberId);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    void snapshotRecording(ExclusivePublication publication, long correlationId, RecordingLog.RecoveryPlan recoveryPlan, String memberEndpoints) {
        this.snapshotRecordingsEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).correlationId(correlationId);
        SnapshotRecordingsEncoder.SnapshotsEncoder snapshotsEncoder = this.snapshotRecordingsEncoder.snapshotsCount(recoveryPlan.snapshots.size());
        int length = recoveryPlan.snapshots.size();
        for (int i = 0; i < length; ++i) {
            RecordingLog.Snapshot snapshot = recoveryPlan.snapshots.get(i);
            snapshotsEncoder.next().recordingId(snapshot.recordingId).leadershipTermId(snapshot.leadershipTermId).termBaseLogPosition(snapshot.termBaseLogPosition).logPosition(snapshot.logPosition).timestamp(snapshot.timestamp).serviceId(snapshot.serviceId);
        }
        this.snapshotRecordingsEncoder.memberEndpoints(memberEndpoints);
        int length2 = 8 + this.snapshotRecordingsEncoder.encodedLength();
        int attempts = 3;
        do {
            long result;
            if ((result = publication.offer(this.buffer, 0, length2)) > 0L) {
                return;
            }
            ConsensusPublisher.checkResult(result);
        } while (--attempts > 0);
    }

    boolean joinCluster(ExclusivePublication publication, long leadershipTermId, int memberId) {
        int length = 20;
        int attempts = 3;
        do {
            long result;
            if ((result = publication.tryClaim(20, this.bufferClaim)) > 0L) {
                this.joinClusterEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).memberId(memberId);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    boolean terminationPosition(ExclusivePublication publication, long leadershipTermId, long logPosition) {
        int length = 24;
        int attempts = 3;
        do {
            long result;
            if ((result = publication.tryClaim(24, this.bufferClaim)) > 0L) {
                this.terminationPositionEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).logPosition(logPosition);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    boolean terminationAck(ExclusivePublication publication, long leadershipTermId, long logPosition, int memberId) {
        int length = 28;
        int attempts = 3;
        do {
            long result;
            if ((result = publication.tryClaim(28, this.bufferClaim)) > 0L) {
                this.terminationAckEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).logPosition(logPosition).memberId(memberId);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    boolean backupQuery(ExclusivePublication publication, long correlationId, int responseStreamId, int version, String responseChannel, byte[] encodedCredentials) {
        int length = 24 + BackupQueryEncoder.responseChannelHeaderLength() + responseChannel.length() + BackupQueryEncoder.encodedCredentialsHeaderLength() + encodedCredentials.length;
        int attempts = 3;
        do {
            long result;
            if ((result = publication.tryClaim(length, this.bufferClaim)) > 0L) {
                this.backupQueryEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).correlationId(correlationId).responseStreamId(responseStreamId).version(version).responseChannel(responseChannel).putEncodedCredentials(encodedCredentials, 0, encodedCredentials.length);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    boolean backupResponse(Publication publication, long correlationId, long logRecordingId, long logLeadershipTermId, long logTermBaseLogPosition, long lastLeadershipTermId, long lastTermBaseLogPosition, int commitPositionCounterId, int leaderMemberId, RecordingLog.RecoveryPlan recoveryPlan, String clusterMembers) {
        this.backupResponseEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).correlationId(correlationId).logRecordingId(logRecordingId).logLeadershipTermId(logLeadershipTermId).logTermBaseLogPosition(logTermBaseLogPosition).lastLeadershipTermId(lastLeadershipTermId).lastTermBaseLogPosition(lastTermBaseLogPosition).commitPositionCounterId(commitPositionCounterId).leaderMemberId(leaderMemberId);
        BackupResponseEncoder.SnapshotsEncoder snapshotsEncoder = this.backupResponseEncoder.snapshotsCount(recoveryPlan.snapshots.size());
        int length = recoveryPlan.snapshots.size();
        for (int i = 0; i < length; ++i) {
            RecordingLog.Snapshot snapshot = recoveryPlan.snapshots.get(i);
            snapshotsEncoder.next().recordingId(snapshot.recordingId).leadershipTermId(snapshot.leadershipTermId).termBaseLogPosition(snapshot.termBaseLogPosition).logPosition(snapshot.logPosition).timestamp(snapshot.timestamp).serviceId(snapshot.serviceId);
        }
        this.backupResponseEncoder.clusterMembers(clusterMembers);
        int length2 = 8 + this.backupResponseEncoder.encodedLength();
        int attempts = 3;
        do {
            long result;
            if ((result = publication.offer(this.buffer, 0, length2)) > 0L) {
                return true;
            }
            ConsensusPublisher.checkResult(result);
        } while (--attempts > 0);
        return false;
    }

    private static void checkResult(long result) {
        if (result == -4L || result == -5L) {
            throw new AeronException("unexpected publication state: " + result);
        }
    }
}

