/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.client.ClusterException;
import org.agrona.concurrent.status.AtomicCounter;

public enum ElectionState {
    INIT(0),
    CANVASS(1),
    NOMINATE(2),
    CANDIDATE_BALLOT(3),
    FOLLOWER_BALLOT(4),
    LEADER_REPLAY(5),
    LEADER_TRANSITION(6),
    LEADER_READY(7),
    FOLLOWER_REPLAY(8),
    FOLLOWER_CATCHUP_TRANSITION(9),
    FOLLOWER_CATCHUP(10),
    FOLLOWER_TRANSITION(11),
    FOLLOWER_READY(12),
    CLOSED(13);

    static final ElectionState[] STATES;
    private final int code;

    private ElectionState(int code) {
        if (code != this.ordinal()) {
            throw new IllegalArgumentException(this.name() + " - code must equal ordinal value: code=" + code);
        }
        this.code = code;
    }

    public int code() {
        return this.code;
    }

    public static ElectionState get(long code) {
        if (code < 0L || code > (long)(STATES.length - 1)) {
            throw new ClusterException("invalid election state counter code: " + code);
        }
        return STATES[(int)code];
    }

    public static ElectionState get(AtomicCounter counter) {
        return ElectionState.get(counter.get());
    }

    static {
        STATES = ElectionState.values();
    }
}

