/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.BufferBuilder;
import io.aeron.Image;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.ClusterActionRequestDecoder;
import io.aeron.cluster.codecs.MembershipChangeEventDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.NewLeadershipTermEventDecoder;
import io.aeron.cluster.codecs.SessionCloseEventDecoder;
import io.aeron.cluster.codecs.SessionMessageHeaderDecoder;
import io.aeron.cluster.codecs.SessionOpenEventDecoder;
import io.aeron.cluster.codecs.TimerEventDecoder;
import io.aeron.cluster.service.ClusterClock;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;

final class LogAdapter
implements ControlledFragmentHandler {
    private static final int FRAGMENT_LIMIT = 100;
    private long logPosition;
    private Image image;
    private final ConsensusModuleAgent consensusModuleAgent;
    private final BufferBuilder builder = new BufferBuilder();
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final SessionOpenEventDecoder sessionOpenEventDecoder = new SessionOpenEventDecoder();
    private final SessionCloseEventDecoder sessionCloseEventDecoder = new SessionCloseEventDecoder();
    private final SessionMessageHeaderDecoder sessionHeaderDecoder = new SessionMessageHeaderDecoder();
    private final TimerEventDecoder timerEventDecoder = new TimerEventDecoder();
    private final ClusterActionRequestDecoder clusterActionRequestDecoder = new ClusterActionRequestDecoder();
    private final NewLeadershipTermEventDecoder newLeadershipTermEventDecoder = new NewLeadershipTermEventDecoder();
    private final MembershipChangeEventDecoder membershipChangeEventDecoder = new MembershipChangeEventDecoder();

    LogAdapter(ConsensusModuleAgent consensusModuleAgent) {
        this.consensusModuleAgent = consensusModuleAgent;
    }

    void disconnect(ErrorHandler errorHandler) {
        if (null != this.image) {
            this.logPosition = this.image.position();
            CloseHelper.close(errorHandler, this.image.subscription());
            this.image = null;
        }
    }

    ConsensusModuleAgent consensusModuleAgent() {
        return this.consensusModuleAgent;
    }

    long position() {
        if (null == this.image) {
            return this.logPosition;
        }
        return this.image.position();
    }

    int poll(long boundPosition) {
        return this.image.boundedControlledPoll(this, boundPosition, 100);
    }

    boolean isImageClosed() {
        return this.image.isClosed();
    }

    Image image() {
        return this.image;
    }

    void image(Image image) {
        if (null != this.image) {
            this.logPosition = this.image.position();
        }
        this.image = image;
    }

    void asyncRemoveDestination(String destination) {
        if (null != this.image) {
            this.image.subscription().asyncRemoveDestination(destination);
        }
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        ControlledFragmentHandler.Action action = ControlledFragmentHandler.Action.CONTINUE;
        byte flags = header.flags();
        if ((flags & 0xFFFFFFC0) == -64) {
            action = this.onMessage(buffer, offset, header);
        } else if ((flags & 0xFFFFFF80) == -128) {
            this.builder.reset().append(buffer, offset, length);
        } else {
            int limit = this.builder.limit();
            if (limit > 0) {
                this.builder.append(buffer, offset, length);
                if ((flags & 0x40) == 64) {
                    action = this.onMessage(this.builder.buffer(), 0, header);
                    if (ControlledFragmentHandler.Action.ABORT == action) {
                        this.builder.limit(limit);
                    } else {
                        this.builder.reset();
                    }
                }
            }
        }
        return action;
    }

    private ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 111) {
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        int templateId = this.messageHeaderDecoder.templateId();
        if (templateId == 1) {
            this.sessionHeaderDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            this.consensusModuleAgent.onReplaySessionMessage(this.sessionHeaderDecoder.clusterSessionId(), this.sessionHeaderDecoder.timestamp());
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        switch (templateId) {
            case 20: {
                this.timerEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onReplayTimerEvent(this.timerEventDecoder.correlationId());
                break;
            }
            case 21: {
                this.sessionOpenEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onReplaySessionOpen(header.position(), this.sessionOpenEventDecoder.correlationId(), this.sessionOpenEventDecoder.clusterSessionId(), this.sessionOpenEventDecoder.timestamp(), this.sessionOpenEventDecoder.responseStreamId(), this.sessionOpenEventDecoder.responseChannel());
                break;
            }
            case 22: {
                this.sessionCloseEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onReplaySessionClose(this.sessionCloseEventDecoder.clusterSessionId(), this.sessionCloseEventDecoder.closeReason());
                break;
            }
            case 24: {
                this.newLeadershipTermEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onReplayNewLeadershipTermEvent(this.newLeadershipTermEventDecoder.leadershipTermId(), this.newLeadershipTermEventDecoder.logPosition(), this.newLeadershipTermEventDecoder.timestamp(), this.newLeadershipTermEventDecoder.termBaseLogPosition(), ClusterClock.map(this.newLeadershipTermEventDecoder.timeUnit()), this.newLeadershipTermEventDecoder.appVersion());
                break;
            }
            case 25: {
                this.membershipChangeEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onReplayMembershipChange(this.membershipChangeEventDecoder.leadershipTermId(), this.membershipChangeEventDecoder.logPosition(), this.membershipChangeEventDecoder.leaderMemberId(), this.membershipChangeEventDecoder.changeType(), this.membershipChangeEventDecoder.memberId(), this.membershipChangeEventDecoder.clusterMembers());
                break;
            }
            case 23: {
                this.clusterActionRequestDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onReplayClusterAction(this.clusterActionRequestDecoder.leadershipTermId(), this.clusterActionRequestDecoder.action());
                return ControlledFragmentHandler.Action.BREAK;
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }
}

