/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.ChannelUri;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.LogAdapter;
import org.agrona.CloseHelper;

class LogReplay {
    private final long recordingId;
    private final long startPosition;
    private final long stopPosition;
    private final long leadershipTermId;
    private final int logSessionId;
    private final int replayStreamId;
    private final AeronArchive archive;
    private final ConsensusModuleAgent consensusModuleAgent;
    private final ConsensusModule.Context ctx;
    private final LogAdapter logAdapter;
    private final Subscription logSubscription;
    private long replaySessionId = -1L;
    private boolean isDone = false;

    LogReplay(AeronArchive archive, long recordingId, long startPosition, long stopPosition, long leadershipTermId, int logSessionId, LogAdapter logAdapter, ConsensusModule.Context ctx) {
        this.archive = archive;
        this.recordingId = recordingId;
        this.startPosition = startPosition;
        this.stopPosition = stopPosition;
        this.leadershipTermId = leadershipTermId;
        this.logSessionId = logSessionId;
        this.logAdapter = logAdapter;
        this.consensusModuleAgent = logAdapter.consensusModuleAgent();
        this.ctx = ctx;
        this.replayStreamId = ctx.replayStreamId();
        ChannelUri channelUri = ChannelUri.parse(ctx.replayChannel());
        channelUri.put("session-id", Integer.toString(logSessionId));
        this.logSubscription = ctx.aeron().addSubscription(channelUri.toString(), this.replayStreamId);
    }

    public void close() {
        this.logAdapter.image(null);
        CloseHelper.close(this.ctx.countedErrorHandler(), this.logSubscription);
    }

    int doWork(long nowMs) {
        int workCount = 0;
        if (-1L == this.replaySessionId) {
            String channel = this.logSubscription.channel();
            this.consensusModuleAgent.awaitServicesReadyForReplay(channel, this.replayStreamId, this.logSessionId, this.leadershipTermId, this.startPosition, this.stopPosition);
            long length = this.stopPosition - this.startPosition;
            this.replaySessionId = this.archive.startReplay(this.recordingId, this.startPosition, length, channel, this.replayStreamId);
            ++workCount;
        } else if (!this.isDone) {
            if (null == this.logAdapter.image()) {
                Image image = this.logSubscription.imageBySessionId((int)this.replaySessionId);
                if (null != image) {
                    this.logAdapter.image(image);
                    ++workCount;
                }
            } else {
                workCount += this.consensusModuleAgent.replayLogPoll(this.logAdapter, this.stopPosition);
                if (this.logAdapter.position() >= this.stopPosition) {
                    this.isDone = true;
                    ++workCount;
                }
            }
        }
        return workCount;
    }

    boolean isDone() {
        return this.isDone;
    }
}

