/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ControlEventListener;
import io.aeron.archive.client.RecordingSignalAdapter;
import io.aeron.archive.client.RecordingSignalConsumer;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.RecordingSignal;
import io.aeron.cluster.client.ClusterException;

final class SnapshotRetrieveMonitor
implements ControlEventListener,
RecordingSignalConsumer {
    private final long expectedStopPosition;
    private final RecordingSignalAdapter recordingSignalAdapter;
    private long recordingId = -1L;
    private boolean isDone = false;
    private String errorMessage;

    SnapshotRetrieveMonitor(AeronArchive archive, long expectedStopPosition) {
        this.expectedStopPosition = expectedStopPosition;
        Subscription subscription = archive.controlResponsePoller().subscription();
        this.recordingSignalAdapter = new RecordingSignalAdapter(archive.controlSessionId(), this, this, subscription, 10);
    }

    long recordingId() {
        return this.recordingId;
    }

    boolean isDone() {
        return this.isDone;
    }

    int poll() {
        int fragments = this.recordingSignalAdapter.poll();
        if (null != this.errorMessage) {
            throw new ClusterException("error occurred while fetching snapshot: " + this.errorMessage);
        }
        return fragments;
    }

    @Override
    public void onResponse(long controlSessionId, long correlationId, long relevantId, ControlResponseCode code, String errorMessage) {
        if (ControlResponseCode.ERROR == code) {
            this.errorMessage = errorMessage;
        }
    }

    @Override
    public void onSignal(long controlSessionId, long correlationId, long recordingId, long subscriptionId, long position, RecordingSignal signal) {
        if (RecordingSignal.START == signal && -1L == this.recordingId) {
            if (0L != position) {
                this.errorMessage = "unexpected start position expected=0, actual=" + position;
            } else {
                this.recordingId = recordingId;
            }
        } else if (RecordingSignal.STOP == signal && recordingId == this.recordingId) {
            if (this.expectedStopPosition == position) {
                this.isDone = true;
            } else {
                this.errorMessage = "unexpected stop position expected=" + this.expectedStopPosition + ", actual=" + position;
            }
        }
    }
}

