/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.MetaAttribute;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class ClusterMembersExtendedResponseDecoder {
    public static final int BLOCK_LENGTH = 24;
    public static final int TEMPLATE_ID = 43;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 6;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ClusterMembersExtendedResponseDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;
    private final ActiveMembersDecoder activeMembers = new ActiveMembersDecoder(this);
    private final PassiveMembersDecoder passiveMembers = new PassiveMembersDecoder(this);

    public int sbeBlockLength() {
        return 24;
    }

    public int sbeTemplateId() {
        return 43;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 6;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ClusterMembersExtendedResponseDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int correlationIdId() {
        return 1;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 0;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int currentTimeNsId() {
        return 2;
    }

    public static int currentTimeNsSinceVersion() {
        return 0;
    }

    public static int currentTimeNsEncodingOffset() {
        return 8;
    }

    public static int currentTimeNsEncodingLength() {
        return 8;
    }

    public static String currentTimeNsMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long currentTimeNsNullValue() {
        return Long.MIN_VALUE;
    }

    public static long currentTimeNsMinValue() {
        return -9223372036854775807L;
    }

    public static long currentTimeNsMaxValue() {
        return Long.MAX_VALUE;
    }

    public long currentTimeNs() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int leaderMemberIdId() {
        return 3;
    }

    public static int leaderMemberIdSinceVersion() {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset() {
        return 16;
    }

    public static int leaderMemberIdEncodingLength() {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int leaderMemberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int leaderMemberIdMinValue() {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int leaderMemberId() {
        return this.buffer.getInt(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int memberIdId() {
        return 4;
    }

    public static int memberIdSinceVersion() {
        return 0;
    }

    public static int memberIdEncodingOffset() {
        return 20;
    }

    public static int memberIdEncodingLength() {
        return 4;
    }

    public static String memberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int memberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int memberIdMinValue() {
        return -2147483647;
    }

    public static int memberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int memberId() {
        return this.buffer.getInt(this.offset + 20, ByteOrder.LITTLE_ENDIAN);
    }

    public static long activeMembersDecoderId() {
        return 5L;
    }

    public static int activeMembersDecoderSinceVersion() {
        return 0;
    }

    public ActiveMembersDecoder activeMembers() {
        this.activeMembers.wrap(this.buffer);
        return this.activeMembers;
    }

    public static long passiveMembersDecoderId() {
        return 15L;
    }

    public static int passiveMembersDecoderSinceVersion() {
        return 0;
    }

    public PassiveMembersDecoder passiveMembers() {
        this.passiveMembers.wrap(this.buffer);
        return this.passiveMembers;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ClusterMembersExtendedResponseDecoder decoder = new ClusterMembersExtendedResponseDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[ClusterMembersExtendedResponse](sbeTemplateId=");
        builder.append(43);
        builder.append("|sbeSchemaId=");
        builder.append(111);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 6) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(6);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 24) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(24);
        builder.append("):");
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("currentTimeNs=");
        builder.append(this.currentTimeNs());
        builder.append('|');
        builder.append("leaderMemberId=");
        builder.append(this.leaderMemberId());
        builder.append('|');
        builder.append("memberId=");
        builder.append(this.memberId());
        builder.append('|');
        builder.append("activeMembers=[");
        ActiveMembersDecoder activeMembers = this.activeMembers();
        if (activeMembers.count() > 0) {
            while (activeMembers.hasNext()) {
                activeMembers.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("passiveMembers=[");
        PassiveMembersDecoder passiveMembers = this.passiveMembers();
        if (passiveMembers.count() > 0) {
            while (passiveMembers.hasNext()) {
                passiveMembers.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        this.limit(originalLimit);
        return builder;
    }

    public static class PassiveMembersDecoder
    implements Iterable<PassiveMembersDecoder>,
    Iterator<PassiveMembersDecoder> {
        public static final int HEADER_SIZE = 4;
        private final ClusterMembersExtendedResponseDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        PassiveMembersDecoder(ClusterMembersExtendedResponseDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = buffer.getShort(limit + 2, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        @Override
        public PassiveMembersDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 28;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<PassiveMembersDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int leadershipTermIdId() {
            return 16;
        }

        public static int leadershipTermIdSinceVersion() {
            return 0;
        }

        public static int leadershipTermIdEncodingOffset() {
            return 0;
        }

        public static int leadershipTermIdEncodingLength() {
            return 8;
        }

        public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long leadershipTermIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long leadershipTermIdMinValue() {
            return -9223372036854775807L;
        }

        public static long leadershipTermIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public long leadershipTermId() {
            return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
        }

        public static int logPositionId() {
            return 17;
        }

        public static int logPositionSinceVersion() {
            return 0;
        }

        public static int logPositionEncodingOffset() {
            return 8;
        }

        public static int logPositionEncodingLength() {
            return 8;
        }

        public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long logPositionNullValue() {
            return Long.MIN_VALUE;
        }

        public static long logPositionMinValue() {
            return -9223372036854775807L;
        }

        public static long logPositionMaxValue() {
            return Long.MAX_VALUE;
        }

        public long logPosition() {
            return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
        }

        public static int timeOfLastAppendNsId() {
            return 18;
        }

        public static int timeOfLastAppendNsSinceVersion() {
            return 0;
        }

        public static int timeOfLastAppendNsEncodingOffset() {
            return 16;
        }

        public static int timeOfLastAppendNsEncodingLength() {
            return 8;
        }

        public static String timeOfLastAppendNsMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long timeOfLastAppendNsNullValue() {
            return Long.MIN_VALUE;
        }

        public static long timeOfLastAppendNsMinValue() {
            return -9223372036854775807L;
        }

        public static long timeOfLastAppendNsMaxValue() {
            return Long.MAX_VALUE;
        }

        public long timeOfLastAppendNs() {
            return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
        }

        public static int memberIdId() {
            return 19;
        }

        public static int memberIdSinceVersion() {
            return 0;
        }

        public static int memberIdEncodingOffset() {
            return 24;
        }

        public static int memberIdEncodingLength() {
            return 4;
        }

        public static String memberIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int memberIdNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int memberIdMinValue() {
            return -2147483647;
        }

        public static int memberIdMaxValue() {
            return Integer.MAX_VALUE;
        }

        public int memberId() {
            return this.buffer.getInt(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
        }

        public static int ingressEndpointId() {
            return 20;
        }

        public static int ingressEndpointSinceVersion() {
            return 0;
        }

        public static String ingressEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String ingressEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int ingressEndpointHeaderLength() {
            return 4;
        }

        public int ingressEndpointLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int skipIngressEndpoint() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getIngressEndpoint(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getIngressEndpoint(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapIngressEndpoint(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String ingressEndpoint() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "US-ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public int getIngressEndpoint(Appendable appendable) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
            return dataLength;
        }

        public static int consensusEndpointId() {
            return 21;
        }

        public static int consensusEndpointSinceVersion() {
            return 0;
        }

        public static String consensusEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String consensusEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int consensusEndpointHeaderLength() {
            return 4;
        }

        public int consensusEndpointLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int skipConsensusEndpoint() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getConsensusEndpoint(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getConsensusEndpoint(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapConsensusEndpoint(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String consensusEndpoint() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "US-ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public int getConsensusEndpoint(Appendable appendable) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
            return dataLength;
        }

        public static int logEndpointId() {
            return 22;
        }

        public static int logEndpointSinceVersion() {
            return 0;
        }

        public static String logEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String logEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int logEndpointHeaderLength() {
            return 4;
        }

        public int logEndpointLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int skipLogEndpoint() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getLogEndpoint(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getLogEndpoint(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapLogEndpoint(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String logEndpoint() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "US-ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public int getLogEndpoint(Appendable appendable) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
            return dataLength;
        }

        public static int catchupEndpointId() {
            return 23;
        }

        public static int catchupEndpointSinceVersion() {
            return 0;
        }

        public static String catchupEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String catchupEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int catchupEndpointHeaderLength() {
            return 4;
        }

        public int catchupEndpointLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int skipCatchupEndpoint() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getCatchupEndpoint(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getCatchupEndpoint(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapCatchupEndpoint(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String catchupEndpoint() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "US-ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public int getCatchupEndpoint(Appendable appendable) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
            return dataLength;
        }

        public static int archiveEndpointId() {
            return 24;
        }

        public static int archiveEndpointSinceVersion() {
            return 0;
        }

        public static String archiveEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String archiveEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int archiveEndpointHeaderLength() {
            return 4;
        }

        public int archiveEndpointLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int skipArchiveEndpoint() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getArchiveEndpoint(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getArchiveEndpoint(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapArchiveEndpoint(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String archiveEndpoint() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "US-ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public int getArchiveEndpoint(Appendable appendable) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
            return dataLength;
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("leadershipTermId=");
            builder.append(this.leadershipTermId());
            builder.append('|');
            builder.append("logPosition=");
            builder.append(this.logPosition());
            builder.append('|');
            builder.append("timeOfLastAppendNs=");
            builder.append(this.timeOfLastAppendNs());
            builder.append('|');
            builder.append("memberId=");
            builder.append(this.memberId());
            builder.append('|');
            builder.append("ingressEndpoint=");
            builder.append('\'');
            this.getIngressEndpoint(builder);
            builder.append('\'');
            builder.append('|');
            builder.append("consensusEndpoint=");
            builder.append('\'');
            this.getConsensusEndpoint(builder);
            builder.append('\'');
            builder.append('|');
            builder.append("logEndpoint=");
            builder.append('\'');
            this.getLogEndpoint(builder);
            builder.append('\'');
            builder.append('|');
            builder.append("catchupEndpoint=");
            builder.append('\'');
            this.getCatchupEndpoint(builder);
            builder.append('\'');
            builder.append('|');
            builder.append("archiveEndpoint=");
            builder.append('\'');
            this.getArchiveEndpoint(builder);
            builder.append('\'');
            builder.append(')');
            return builder;
        }
    }

    public static class ActiveMembersDecoder
    implements Iterable<ActiveMembersDecoder>,
    Iterator<ActiveMembersDecoder> {
        public static final int HEADER_SIZE = 4;
        private final ClusterMembersExtendedResponseDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        ActiveMembersDecoder(ClusterMembersExtendedResponseDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = buffer.getShort(limit + 2, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        @Override
        public ActiveMembersDecoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 28;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<ActiveMembersDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        public static int leadershipTermIdId() {
            return 6;
        }

        public static int leadershipTermIdSinceVersion() {
            return 0;
        }

        public static int leadershipTermIdEncodingOffset() {
            return 0;
        }

        public static int leadershipTermIdEncodingLength() {
            return 8;
        }

        public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long leadershipTermIdNullValue() {
            return Long.MIN_VALUE;
        }

        public static long leadershipTermIdMinValue() {
            return -9223372036854775807L;
        }

        public static long leadershipTermIdMaxValue() {
            return Long.MAX_VALUE;
        }

        public long leadershipTermId() {
            return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
        }

        public static int logPositionId() {
            return 7;
        }

        public static int logPositionSinceVersion() {
            return 0;
        }

        public static int logPositionEncodingOffset() {
            return 8;
        }

        public static int logPositionEncodingLength() {
            return 8;
        }

        public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long logPositionNullValue() {
            return Long.MIN_VALUE;
        }

        public static long logPositionMinValue() {
            return -9223372036854775807L;
        }

        public static long logPositionMaxValue() {
            return Long.MAX_VALUE;
        }

        public long logPosition() {
            return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
        }

        public static int timeOfLastAppendNsId() {
            return 8;
        }

        public static int timeOfLastAppendNsSinceVersion() {
            return 0;
        }

        public static int timeOfLastAppendNsEncodingOffset() {
            return 16;
        }

        public static int timeOfLastAppendNsEncodingLength() {
            return 8;
        }

        public static String timeOfLastAppendNsMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long timeOfLastAppendNsNullValue() {
            return Long.MIN_VALUE;
        }

        public static long timeOfLastAppendNsMinValue() {
            return -9223372036854775807L;
        }

        public static long timeOfLastAppendNsMaxValue() {
            return Long.MAX_VALUE;
        }

        public long timeOfLastAppendNs() {
            return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
        }

        public static int memberIdId() {
            return 9;
        }

        public static int memberIdSinceVersion() {
            return 0;
        }

        public static int memberIdEncodingOffset() {
            return 24;
        }

        public static int memberIdEncodingLength() {
            return 4;
        }

        public static String memberIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int memberIdNullValue() {
            return Integer.MIN_VALUE;
        }

        public static int memberIdMinValue() {
            return -2147483647;
        }

        public static int memberIdMaxValue() {
            return Integer.MAX_VALUE;
        }

        public int memberId() {
            return this.buffer.getInt(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
        }

        public static int ingressEndpointId() {
            return 10;
        }

        public static int ingressEndpointSinceVersion() {
            return 0;
        }

        public static String ingressEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String ingressEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int ingressEndpointHeaderLength() {
            return 4;
        }

        public int ingressEndpointLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int skipIngressEndpoint() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getIngressEndpoint(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getIngressEndpoint(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapIngressEndpoint(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String ingressEndpoint() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "US-ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public int getIngressEndpoint(Appendable appendable) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
            return dataLength;
        }

        public static int consensusEndpointId() {
            return 11;
        }

        public static int consensusEndpointSinceVersion() {
            return 0;
        }

        public static String consensusEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String consensusEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int consensusEndpointHeaderLength() {
            return 4;
        }

        public int consensusEndpointLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int skipConsensusEndpoint() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getConsensusEndpoint(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getConsensusEndpoint(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapConsensusEndpoint(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String consensusEndpoint() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "US-ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public int getConsensusEndpoint(Appendable appendable) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
            return dataLength;
        }

        public static int logEndpointId() {
            return 12;
        }

        public static int logEndpointSinceVersion() {
            return 0;
        }

        public static String logEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String logEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int logEndpointHeaderLength() {
            return 4;
        }

        public int logEndpointLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int skipLogEndpoint() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getLogEndpoint(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getLogEndpoint(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapLogEndpoint(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String logEndpoint() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "US-ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public int getLogEndpoint(Appendable appendable) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
            return dataLength;
        }

        public static int catchupEndpointId() {
            return 13;
        }

        public static int catchupEndpointSinceVersion() {
            return 0;
        }

        public static String catchupEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String catchupEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int catchupEndpointHeaderLength() {
            return 4;
        }

        public int catchupEndpointLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int skipCatchupEndpoint() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getCatchupEndpoint(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getCatchupEndpoint(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapCatchupEndpoint(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String catchupEndpoint() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "US-ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public int getCatchupEndpoint(Appendable appendable) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
            return dataLength;
        }

        public static int archiveEndpointId() {
            return 14;
        }

        public static int archiveEndpointSinceVersion() {
            return 0;
        }

        public static String archiveEndpointCharacterEncoding() {
            return "US-ASCII";
        }

        public static String archiveEndpointMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int archiveEndpointHeaderLength() {
            return 4;
        }

        public int archiveEndpointLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int skipArchiveEndpoint() {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            return dataLength;
        }

        public int getArchiveEndpoint(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getArchiveEndpoint(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public void wrapArchiveEndpoint(DirectBuffer wrapBuffer) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
        }

        public String archiveEndpoint() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            if (0 == dataLength) {
                return "";
            }
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "US-ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public int getArchiveEndpoint(Appendable appendable) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int dataOffset = limit + 4;
            this.parentMessage.limit(dataOffset + dataLength);
            this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
            return dataLength;
        }

        public StringBuilder appendTo(StringBuilder builder) {
            if (null == this.buffer) {
                return builder;
            }
            builder.append('(');
            builder.append("leadershipTermId=");
            builder.append(this.leadershipTermId());
            builder.append('|');
            builder.append("logPosition=");
            builder.append(this.logPosition());
            builder.append('|');
            builder.append("timeOfLastAppendNs=");
            builder.append(this.timeOfLastAppendNs());
            builder.append('|');
            builder.append("memberId=");
            builder.append(this.memberId());
            builder.append('|');
            builder.append("ingressEndpoint=");
            builder.append('\'');
            this.getIngressEndpoint(builder);
            builder.append('\'');
            builder.append('|');
            builder.append("consensusEndpoint=");
            builder.append('\'');
            this.getConsensusEndpoint(builder);
            builder.append('\'');
            builder.append('|');
            builder.append("logEndpoint=");
            builder.append('\'');
            this.getLogEndpoint(builder);
            builder.append('\'');
            builder.append('|');
            builder.append("catchupEndpoint=");
            builder.append('\'');
            this.getCatchupEndpoint(builder);
            builder.append('\'');
            builder.append('|');
            builder.append("archiveEndpoint=");
            builder.append('\'');
            this.getArchiveEndpoint(builder);
            builder.append('\'');
            builder.append(')');
            return builder;
        }
    }
}

