/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.Aeron;
import io.aeron.DirectBufferVector;
import io.aeron.cluster.service.ClientSession;
import io.aeron.cluster.service.ClusteredServiceContainer;
import io.aeron.logbuffer.BufferClaim;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.AtomicCounter;

public interface Cluster {
    public int memberId();

    public Role role();

    public long logPosition();

    public Aeron aeron();

    public ClusteredServiceContainer.Context context();

    public ClientSession getClientSession(long var1);

    public Collection<ClientSession> clientSessions();

    public void forEachClientSession(Consumer<? super ClientSession> var1);

    public boolean closeClientSession(long var1);

    public long time();

    public TimeUnit timeUnit();

    public boolean scheduleTimer(long var1, long var3);

    public boolean cancelTimer(long var1);

    public long offer(DirectBuffer var1, int var2, int var3);

    public long offer(DirectBufferVector[] var1);

    public long tryClaim(int var1, BufferClaim var2);

    public IdleStrategy idleStrategy();

    public static enum Role {
        FOLLOWER(0),
        CANDIDATE(1),
        LEADER(2);

        static final Role[] ROLES;
        private final int code;

        private Role(int code) {
            if (code != this.ordinal()) {
                throw new IllegalArgumentException(this.name() + " - code must equal ordinal value: code=" + code);
            }
            this.code = code;
        }

        public final int code() {
            return this.code;
        }

        public static Role get(long code) {
            if (code < 0L || code > (long)(ROLES.length - 1)) {
                throw new IllegalStateException("Invalid role counter code: " + code);
            }
            return ROLES[(int)code];
        }

        public static Role get(AtomicCounter counter) {
            return Role.get(counter.get());
        }

        static {
            ROLES = Role.values();
        }
    }
}

