/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.Aeron;
import io.aeron.Counter;
import io.aeron.cluster.client.ClusterException;
import org.agrona.BitUtil;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersReader;

public class RecoveryState {
    public static final int RECOVERY_STATE_TYPE_ID = 204;
    public static final String NAME = "Cluster recovery: leadershipTermId=";
    public static final int LEADERSHIP_TERM_ID_OFFSET = 0;
    public static final int LOG_POSITION_OFFSET = 8;
    public static final int TIMESTAMP_OFFSET = 16;
    public static final int CLUSTER_ID_OFFSET = 24;
    public static final int SERVICE_COUNT_OFFSET = 28;
    public static final int SNAPSHOT_RECORDING_IDS_OFFSET = 32;

    public static Counter allocate(Aeron aeron, long leadershipTermId, long logPosition, long timestamp, int clusterId, long ... snapshotRecordingIds) {
        ExpandableArrayBuffer buffer = new ExpandableArrayBuffer(256);
        buffer.putLong(0, leadershipTermId);
        buffer.putLong(8, logPosition);
        buffer.putLong(16, timestamp);
        buffer.putInt(24, clusterId);
        int serviceCount = snapshotRecordingIds.length;
        buffer.putInt(28, serviceCount);
        int keyLength = 32 + serviceCount * 8;
        if (keyLength > 112) {
            throw new ClusterException(keyLength + " exceeds max key length " + 112);
        }
        for (int i = 0; i < serviceCount; ++i) {
            buffer.putLong(32 + i * 8, snapshotRecordingIds[i]);
        }
        int labelOffset = BitUtil.align(keyLength, 4);
        int labelLength = 0;
        labelLength += buffer.putStringWithoutLengthAscii(labelOffset + labelLength, NAME);
        labelLength += buffer.putLongAscii(keyLength + labelLength, leadershipTermId);
        labelLength += buffer.putStringWithoutLengthAscii(labelOffset + labelLength, " logPosition=");
        labelLength += buffer.putLongAscii(labelOffset + labelLength, logPosition);
        labelLength += buffer.putStringWithoutLengthAscii(labelOffset + labelLength, " clusterId=");
        labelLength += buffer.putIntAscii(labelOffset + labelLength, clusterId);
        return aeron.addCounter(204, buffer, 0, keyLength, buffer, labelOffset, labelLength);
    }

    public static int findCounterId(CountersReader counters, int clusterId) {
        AtomicBuffer buffer = counters.metaDataBuffer();
        int size = counters.maxCounterId();
        for (int i = 0; i < size; ++i) {
            int counterState = counters.getCounterState(i);
            if (counterState == 1 && counters.getCounterTypeId(i) == 204) {
                if (buffer.getInt(CountersReader.metaDataOffset(i) + 16 + 24) != clusterId) continue;
                return i;
            }
            if (0 == counterState) break;
        }
        return -1;
    }

    public static long getLeadershipTermId(CountersReader counters, int counterId) {
        AtomicBuffer buffer = counters.metaDataBuffer();
        if (counters.getCounterState(counterId) == 1 && counters.getCounterTypeId(counterId) == 204) {
            return buffer.getLong(CountersReader.metaDataOffset(counterId) + 16 + 0);
        }
        return -1L;
    }

    public static long getLogPosition(CountersReader counters, int counterId) {
        AtomicBuffer buffer = counters.metaDataBuffer();
        if (counters.getCounterState(counterId) == 1 && counters.getCounterTypeId(counterId) == 204) {
            return buffer.getLong(CountersReader.metaDataOffset(counterId) + 16 + 8);
        }
        return -1L;
    }

    public static long getTimestamp(CountersReader counters, int counterId) {
        AtomicBuffer buffer = counters.metaDataBuffer();
        if (counters.getCounterState(counterId) == 1 && counters.getCounterTypeId(counterId) == 204) {
            return buffer.getLong(CountersReader.metaDataOffset(counterId) + 16 + 16);
        }
        return -1L;
    }

    public static long getSnapshotRecordingId(CountersReader counters, int counterId, int serviceId) {
        AtomicBuffer buffer = counters.metaDataBuffer();
        if (counters.getCounterState(counterId) == 1 && counters.getCounterTypeId(counterId) == 204) {
            int recordOffset = CountersReader.metaDataOffset(counterId);
            int serviceCount = buffer.getInt(recordOffset + 16 + 28);
            if (serviceId < 0 || serviceId >= serviceCount) {
                throw new ClusterException("invalid serviceId " + serviceId + " for count of " + serviceCount);
            }
            return buffer.getLong(recordOffset + 16 + 32 + serviceId * 8);
        }
        throw new ClusterException("active counter not found " + counterId);
    }
}

