/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.FragmentAssembler;
import io.aeron.Subscription;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.BooleanType;
import io.aeron.cluster.codecs.JoinLogDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.ServiceTerminationPositionDecoder;
import io.aeron.cluster.service.ClusteredServiceAgent;
import io.aeron.logbuffer.Header;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;

final class ServiceAdapter
implements AutoCloseable {
    private final Subscription subscription;
    private final ClusteredServiceAgent clusteredServiceAgent;
    private final FragmentAssembler fragmentAssembler = new FragmentAssembler(this::onFragment);
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final JoinLogDecoder joinLogDecoder = new JoinLogDecoder();
    private final ServiceTerminationPositionDecoder serviceTerminationPositionDecoder = new ServiceTerminationPositionDecoder();

    ServiceAdapter(Subscription subscription, ClusteredServiceAgent clusteredServiceAgent) {
        this.subscription = subscription;
        this.clusteredServiceAgent = clusteredServiceAgent;
    }

    @Override
    public void close() {
        CloseHelper.close(this.subscription);
    }

    public int poll() {
        return this.subscription.poll(this.fragmentAssembler, 10);
    }

    private void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 111) {
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        switch (this.messageHeaderDecoder.templateId()) {
            case 40: {
                this.joinLogDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.clusteredServiceAgent.onJoinLog(this.joinLogDecoder.leadershipTermId(), this.joinLogDecoder.logPosition(), this.joinLogDecoder.maxLogPosition(), this.joinLogDecoder.memberId(), this.joinLogDecoder.logSessionId(), this.joinLogDecoder.logStreamId(), this.joinLogDecoder.isStartup() == BooleanType.TRUE, this.joinLogDecoder.logChannel());
                break;
            }
            case 42: {
                this.serviceTerminationPositionDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.clusteredServiceAgent.onServiceTerminationPosition(this.serviceTerminationPositionDecoder.logPosition());
            }
        }
    }
}

