/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.ExclusivePublication;
import io.aeron.cluster.codecs.ClientSessionEncoder;
import io.aeron.cluster.service.ClientSession;
import io.aeron.cluster.service.SnapshotTaker;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.IdleStrategy;

class ServiceSnapshotTaker
extends SnapshotTaker {
    private final ClientSessionEncoder clientSessionEncoder = new ClientSessionEncoder();

    ServiceSnapshotTaker(ExclusivePublication publication, IdleStrategy idleStrategy, AgentInvoker aeronClientInvoker) {
        super(publication, idleStrategy, aeronClientInvoker);
    }

    void snapshotSession(ClientSession session) {
        String responseChannel = session.responseChannel();
        byte[] encodedPrincipal = session.encodedPrincipal();
        int length = 20 + ClientSessionEncoder.responseChannelHeaderLength() + responseChannel.length() + ClientSessionEncoder.encodedPrincipalHeaderLength() + encodedPrincipal.length;
        this.idleStrategy.reset();
        while (true) {
            long result;
            if ((result = this.publication.tryClaim(length, this.bufferClaim)) > 0L) break;
            this.checkResultAndIdle(result);
        }
        this.clientSessionEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).clusterSessionId(session.id()).responseStreamId(session.responseStreamId()).responseChannel(responseChannel).putEncodedPrincipal(encodedPrincipal, 0, encodedPrincipal.length);
        this.bufferClaim.commit();
    }
}

