/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FlowControl;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.media.UdpChannel;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.StatusMessageFlyweight;
import java.util.Arrays;
import org.agrona.AsciiEncoding;
import org.agrona.SystemUtil;
import org.agrona.collections.ArrayUtil;

public abstract class AbstractMinMulticastFlowControl
implements FlowControl {
    static final Receiver[] EMPTY_RECEIVERS = new Receiver[0];
    private long receiverTimeoutNs;
    private long groupTag;
    private int groupMinSize;
    private final boolean isGroupTagAware;
    private volatile Receiver[] receivers = EMPTY_RECEIVERS;

    protected AbstractMinMulticastFlowControl(boolean isGroupTagAware) {
        this.isGroupTagAware = isGroupTagAware;
    }

    @Override
    public void initialize(MediaDriver.Context context, UdpChannel udpChannel, int initialTermId, int termBufferLength) {
        this.receiverTimeoutNs = context.flowControlReceiverTimeoutNs();
        this.groupTag = this.isGroupTagAware ? context.flowControlGroupTag() : 0L;
        this.groupMinSize = context.flowControlGroupMinSize();
        this.parseUriParam(udpChannel.channelUri().get("fc"));
    }

    @Override
    public long onIdle(long timeNs, long senderLimit, long senderPosition, boolean isEos) {
        int lastIndex;
        long minLimitPosition = Long.MAX_VALUE;
        int removed = 0;
        Receiver[] receivers = this.receivers;
        for (int i = lastIndex = receivers.length - 1; i >= 0; --i) {
            Receiver receiver = receivers[i];
            if (receiver.timeOfLastStatusMessageNs + this.receiverTimeoutNs - timeNs < 0L) {
                if (i != lastIndex) {
                    receivers[i] = receivers[lastIndex--];
                }
                ++removed;
                continue;
            }
            minLimitPosition = Math.min(minLimitPosition, receiver.lastPositionPlusWindow);
        }
        if (removed > 0) {
            receivers = AbstractMinMulticastFlowControl.truncateReceivers(receivers, removed);
            this.receivers = receivers;
        }
        return receivers.length < this.groupMinSize || receivers.length == 0 ? senderLimit : minLimitPosition;
    }

    @Override
    public boolean hasRequiredReceivers() {
        return this.receivers.length >= this.groupMinSize;
    }

    protected final long processStatusMessage(StatusMessageFlyweight flyweight, long senderLimit, int initialTermId, int positionBitsToShift, long timeNs, boolean matchesTag) {
        Receiver[] receivers;
        long position = LogBufferDescriptor.computePosition(flyweight.consumptionTermId(), flyweight.consumptionTermOffset(), positionBitsToShift, initialTermId);
        long windowLength = flyweight.receiverWindowLength();
        long receiverId = flyweight.receiverId();
        long lastPositionPlusWindow = position + windowLength;
        boolean isExisting = false;
        long minPosition = Long.MAX_VALUE;
        for (Receiver receiver : receivers = this.receivers) {
            if (matchesTag && receiverId == receiver.receiverId) {
                receiver.lastPosition = Math.max(position, receiver.lastPosition);
                receiver.lastPositionPlusWindow = lastPositionPlusWindow;
                receiver.timeOfLastStatusMessageNs = timeNs;
                isExisting = true;
            }
            minPosition = Math.min(minPosition, receiver.lastPositionPlusWindow);
        }
        if (matchesTag && !isExisting) {
            Receiver receiver = new Receiver(position, lastPositionPlusWindow, timeNs, receiverId);
            this.receivers = receivers = ArrayUtil.add(receivers, receiver);
            minPosition = Math.min(minPosition, lastPositionPlusWindow);
        }
        if (receivers.length < this.groupMinSize) {
            return senderLimit;
        }
        if (receivers.length == 0) {
            return Math.max(senderLimit, lastPositionPlusWindow);
        }
        return Math.max(senderLimit, minPosition);
    }

    protected final long receiverTimeoutNs() {
        return this.receiverTimeoutNs;
    }

    protected final boolean hasGroupTag() {
        return this.isGroupTagAware;
    }

    protected final long groupTag() {
        return this.groupTag;
    }

    protected final int groupMinSize() {
        return this.groupMinSize;
    }

    static Receiver[] truncateReceivers(Receiver[] receivers, int removed) {
        int length = receivers.length;
        int newLength = length - removed;
        if (0 == newLength) {
            return EMPTY_RECEIVERS;
        }
        return Arrays.copyOf(receivers, newLength);
    }

    private void parseUriParam(String fcValue) {
        if (null != fcValue) {
            for (String arg : fcValue.split(",")) {
                if (arg.startsWith("t:")) {
                    this.receiverTimeoutNs = SystemUtil.parseDuration("fc receiver timeout", arg.substring(2));
                    continue;
                }
                if (!arg.startsWith("g:")) continue;
                int groupMinSizeIndex = arg.indexOf(47);
                if (2 != groupMinSizeIndex && this.isGroupTagAware) {
                    int lengthToParse = -1 == groupMinSizeIndex ? arg.length() - 2 : groupMinSizeIndex - 2;
                    this.groupTag = AsciiEncoding.parseLongAscii(arg, 2, lengthToParse);
                }
                if (-1 == groupMinSizeIndex) continue;
                this.groupMinSize = AsciiEncoding.parseIntAscii(arg, groupMinSizeIndex + 1, arg.length() - (groupMinSizeIndex + 1));
            }
        }
    }

    static class Receiver {
        long lastPosition;
        long lastPositionPlusWindow;
        long timeOfLastStatusMessageNs;
        final long receiverId;

        Receiver(long lastPosition, long lastPositionPlusWindow, long timeNs, long receiverId) {
            this.lastPosition = lastPosition;
            this.lastPositionPlusWindow = lastPositionPlusWindow;
            this.timeOfLastStatusMessageNs = timeNs;
            this.receiverId = receiverId;
        }
    }
}

