/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ChannelUri;
import io.aeron.driver.Configuration;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.buffer.RawLog;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;
import org.agrona.SystemUtil;

final class PublicationParams {
    long lingerTimeoutNs;
    long entityTag = -1L;
    int termLength;
    int mtuLength;
    int initialTermId = 0;
    int termId = 0;
    int termOffset = 0;
    int sessionId = 0;
    boolean hasPosition = false;
    boolean hasSessionId = false;
    boolean isSessionIdTagged = false;
    boolean signalEos = true;
    boolean isSparse;
    boolean spiesSimulateConnection;

    PublicationParams() {
    }

    static PublicationParams getPublicationParams(ChannelUri channelUri, MediaDriver.Context ctx, DriverConductor driverConductor, boolean isExclusive, boolean isIpc) {
        PublicationParams params = new PublicationParams(ctx, isIpc);
        params.getEntityTag(channelUri, driverConductor);
        params.getSessionId(channelUri, driverConductor);
        params.getTermBufferLength(channelUri);
        params.getMtuLength(channelUri);
        params.getLingerTimeoutNs(channelUri);
        params.getEos(channelUri);
        params.getSparse(channelUri, ctx);
        params.getSpiesSimulateConnection(channelUri, ctx);
        int count = 0;
        String initialTermIdStr = channelUri.get("init-term-id");
        count = initialTermIdStr != null ? count + 1 : count;
        String termIdStr = channelUri.get("term-id");
        count = termIdStr != null ? count + 1 : count;
        String termOffsetStr = channelUri.get("term-offset");
        int n = count = termOffsetStr != null ? count + 1 : count;
        if (count > 0) {
            if (!isExclusive) {
                throw new IllegalArgumentException("params: init-term-id term-id term-offset are not supported for concurrent publications");
            }
            if (count < 3) {
                throw new IllegalArgumentException("params must be used as a complete set: init-term-id term-id term-offset");
            }
            params.initialTermId = Integer.parseInt(initialTermIdStr);
            params.termId = Integer.parseInt(termIdStr);
            params.termOffset = Integer.parseInt(termOffsetStr);
            if (params.termOffset > params.termLength) {
                throw new IllegalArgumentException("term-offset=" + params.termOffset + " > " + "term-length" + "=" + params.termLength);
            }
            if (params.termOffset < 0 || params.termOffset > 0x40000000) {
                throw new IllegalArgumentException("term-offset=" + params.termOffset + " out of range");
            }
            if ((params.termOffset & 0x1F) != 0) {
                throw new IllegalArgumentException("term-offset=" + params.termOffset + " must be a multiple of FRAME_ALIGNMENT");
            }
            if (params.termId - params.initialTermId < 0) {
                throw new IllegalStateException("difference greater than 2^31 - 1: init-term-id=" + params.initialTermId + " when " + "term-id" + "=" + params.termId);
            }
            params.hasPosition = true;
        }
        return params;
    }

    private PublicationParams(MediaDriver.Context context, boolean isIpc) {
        this.termLength = isIpc ? context.ipcTermBufferLength() : context.publicationTermBufferLength();
        this.mtuLength = isIpc ? context.ipcMtuLength() : context.mtuLength();
        this.lingerTimeoutNs = context.publicationLingerTimeoutNs();
        this.isSparse = context.termBufferSparseFile();
    }

    private void getEntityTag(ChannelUri channelUri, DriverConductor driverConductor) {
        String tagParam = channelUri.entityTag();
        if (null != tagParam) {
            long entityTag = Long.parseLong(tagParam);
            PublicationParams.validateEntityTag(entityTag, driverConductor);
            this.entityTag = entityTag;
        }
    }

    private void getTermBufferLength(ChannelUri channelUri) {
        String termLengthParam = channelUri.get("term-length");
        if (null != termLengthParam) {
            int termLength = (int)SystemUtil.parseSize("term-length", termLengthParam);
            LogBufferDescriptor.checkTermLength(termLength);
            PublicationParams.validateTermLength(this, termLength);
            this.termLength = termLength;
        }
    }

    private void getMtuLength(ChannelUri channelUri) {
        String mtuParam = channelUri.get("mtu");
        if (null != mtuParam) {
            int mtuLength = (int)SystemUtil.parseSize("mtu", mtuParam);
            Configuration.validateMtuLength(mtuLength);
            PublicationParams.validateMtuLength(this, mtuLength);
            this.mtuLength = mtuLength;
        }
    }

    static void validateMtuForMaxMessage(PublicationParams params) {
        int termLength = params.termLength;
        int maxMessageLength = FrameDescriptor.computeMaxMessageLength(termLength);
        if (params.mtuLength > maxMessageLength) {
            throw new IllegalStateException("MTU greater than max message length for term length: mtu=" + params.mtuLength + " maxMessageLength=" + maxMessageLength + " termLength=" + termLength);
        }
    }

    static void validateTermLength(PublicationParams params, int explicitTermLength) {
        if (params.isSessionIdTagged && explicitTermLength != params.termLength) {
            throw new IllegalArgumentException("term-length=" + explicitTermLength + " does not match session-id tag value");
        }
    }

    static void validateMtuLength(PublicationParams params, int explicitMtuLength) {
        if (params.isSessionIdTagged && explicitMtuLength != params.mtuLength) {
            throw new IllegalArgumentException("mtu=" + explicitMtuLength + " does not match session-id tag value");
        }
    }

    static void confirmMatch(ChannelUri channelUri, PublicationParams params, RawLog rawLog, int existingSessionId) {
        int mtuLength = LogBufferDescriptor.mtuLength(rawLog.metaData());
        if (channelUri.containsKey("mtu") && mtuLength != params.mtuLength) {
            throw new IllegalStateException("existing publication has different MTU length: existing=" + mtuLength + " requested=" + params.mtuLength);
        }
        if (channelUri.containsKey("term-length") && rawLog.termLength() != params.termLength) {
            throw new IllegalStateException("existing publication has different term length: existing=" + rawLog.termLength() + " requested=" + params.termLength);
        }
        if (channelUri.containsKey("session-id") && params.sessionId != existingSessionId) {
            throw new IllegalStateException("existing publication has different session id: existing=" + existingSessionId + " requested=" + params.sessionId);
        }
    }

    static void validateSpiesSimulateConnection(PublicationParams params, boolean existingSpiesSimulateConnection) {
        if (params.spiesSimulateConnection != existingSpiesSimulateConnection) {
            throw new IllegalStateException("existing publication has different spiesSimulateConnection: existing=" + existingSpiesSimulateConnection + " requested=" + params.spiesSimulateConnection);
        }
    }

    private void getLingerTimeoutNs(ChannelUri channelUri) {
        String lingerParam = channelUri.get("linger");
        if (null != lingerParam) {
            this.lingerTimeoutNs = SystemUtil.parseDuration("linger", lingerParam);
            Configuration.validatePublicationLingerTimeoutNs(this.lingerTimeoutNs, this.lingerTimeoutNs);
        }
    }

    private void getSessionId(ChannelUri channelUri, DriverConductor driverConductor) {
        String sessionIdStr = channelUri.get("session-id");
        if (null != sessionIdStr) {
            this.isSessionIdTagged = ChannelUri.isTagged(sessionIdStr);
            if (this.isSessionIdTagged) {
                NetworkPublication publication = driverConductor.findNetworkPublicationByTag(ChannelUri.getTag(sessionIdStr));
                if (null == publication) {
                    throw new IllegalArgumentException("session-id=" + sessionIdStr + " must reference a network publication");
                }
                this.sessionId = publication.sessionId();
                this.mtuLength = publication.mtuLength();
                this.termLength = publication.termBufferLength();
            } else {
                this.sessionId = Integer.parseInt(sessionIdStr);
            }
            this.hasSessionId = true;
        }
    }

    private void getEos(ChannelUri channelUri) {
        String eosStr = channelUri.get("eos");
        if (null != eosStr) {
            this.signalEos = "true".equals(eosStr);
        }
    }

    private void getSparse(ChannelUri channelUri, MediaDriver.Context ctx) {
        String sparseStr = channelUri.get("sparse");
        this.isSparse = null != sparseStr ? "true".equals(sparseStr) : ctx.termBufferSparseFile();
    }

    private void getSpiesSimulateConnection(ChannelUri channelUri, MediaDriver.Context ctx) {
        String sscStr = channelUri.get("ssc");
        this.spiesSimulateConnection = null != sscStr ? "true".equals(sscStr) : ctx.spiesSimulateConnection();
    }

    private static void validateEntityTag(long entityTag, DriverConductor driverConductor) {
        if (-1L == entityTag) {
            throw new IllegalArgumentException("-1 tag is reserved");
        }
        if (null != driverConductor.findNetworkPublicationByTag(entityTag) || null != driverConductor.findIpcPublicationByTag(entityTag)) {
            throw new IllegalArgumentException(entityTag + " entityTag already in use");
        }
    }

    public String toString() {
        return "PublicationParams{lingerTimeoutNs=" + this.lingerTimeoutNs + ", entityTag=" + this.entityTag + ", termLength=" + this.termLength + ", mtuLength=" + this.mtuLength + ", initialTermId=" + this.initialTermId + ", termId=" + this.termId + ", termOffset=" + this.termOffset + ", sessionId=" + this.sessionId + ", hasPosition=" + this.hasPosition + ", hasSessionId=" + this.hasSessionId + ", isSessionIdTagged=" + this.isSessionIdTagged + ", isSparse=" + this.isSparse + ", signalEos=" + this.signalEos + ", spiesSimulateConnection=" + this.spiesSimulateConnection + '}';
    }
}

