/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ChannelUri;
import io.aeron.CommonContext;
import io.aeron.driver.MediaDriver;

class SubscriptionParams {
    int initialTermId = 0;
    int termId = 0;
    int termOffset = 0;
    int sessionId = 0;
    boolean hasJoinPosition = false;
    boolean hasSessionId = false;
    boolean isReliable = true;
    boolean isRejoin = true;
    boolean isSparse = true;
    boolean isTether = true;
    CommonContext.InferableBoolean group = CommonContext.InferableBoolean.INFER;

    SubscriptionParams() {
    }

    static SubscriptionParams getSubscriptionParams(ChannelUri channelUri, MediaDriver.Context context) {
        String reliableStr;
        SubscriptionParams params = new SubscriptionParams();
        String sessionIdStr = channelUri.get("session-id");
        if (null != sessionIdStr) {
            params.sessionId = Integer.parseInt(sessionIdStr);
            params.hasSessionId = true;
        }
        int count = 0;
        String initialTermIdStr = channelUri.get("init-term-id");
        count = initialTermIdStr != null ? count + 1 : count;
        String termIdStr = channelUri.get("term-id");
        count = termIdStr != null ? count + 1 : count;
        String termOffsetStr = channelUri.get("term-offset");
        int n = count = termOffsetStr != null ? count + 1 : count;
        if (count > 0) {
            if (count < 3) {
                throw new IllegalArgumentException("params must be used as a complete set: init-term-id term-id term-offset");
            }
            params.initialTermId = Integer.parseInt(initialTermIdStr);
            params.termId = Integer.parseInt(termIdStr);
            params.termOffset = Integer.parseInt(termOffsetStr);
            if (params.termOffset < 0 || params.termOffset > 0x40000000) {
                throw new IllegalArgumentException("term-offset=" + params.termOffset + " out of range");
            }
            if ((params.termOffset & 0x1F) != 0) {
                throw new IllegalArgumentException("term-offset=" + params.termOffset + " must be a multiple of FRAME_ALIGNMENT");
            }
            if (params.termId - params.initialTermId < 0) {
                throw new IllegalStateException("difference greater than 2^31 - 1: init-term-id=" + params.initialTermId + " when " + "term-id" + "=" + params.termId);
            }
            params.hasJoinPosition = true;
        }
        params.isReliable = null != (reliableStr = channelUri.get("reliable")) ? "true".equals(reliableStr) : context.reliableStream();
        String rejoinStr = channelUri.get("rejoin");
        params.isRejoin = null != rejoinStr ? "true".equals(rejoinStr) : context.rejoinStream();
        String tetherStr = channelUri.get("tether");
        params.isTether = null != tetherStr ? "true".equals(tetherStr) : context.tetherSubscriptions();
        String sparseStr = channelUri.get("sparse");
        params.isSparse = null != sparseStr ? "true".equals(sparseStr) : context.termBufferSparseFile();
        String groupStr = channelUri.get("group");
        params.group = null != groupStr ? CommonContext.InferableBoolean.parse(groupStr) : context.receiverGroupConsideration();
        return params;
    }

    public String toString() {
        return "SubscriptionParams{initialTermId=" + this.initialTermId + ", termId=" + this.termId + ", termOffset=" + this.termOffset + ", sessionId=" + this.sessionId + ", hasJoinPosition=" + this.hasJoinPosition + ", hasSessionId=" + this.hasSessionId + ", isReliable=" + this.isReliable + ", isRejoin=" + this.isRejoin + ", isSparse=" + this.isSparse + ", isTether=" + this.isTether + ", group=" + (Object)((Object)this.group) + '}';
    }
}

