/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.ext;

import io.aeron.driver.CongestionControl;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ext.CubicCongestionControlConfiguration;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.status.PerImageIndicator;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;

public class CubicCongestionControl
implements CongestionControl {
    public static final String CC_PARAM_VALUE = "cubic";
    private static final long RTT_MEASUREMENT_TIMEOUT_NS = TimeUnit.MILLISECONDS.toNanos(10L);
    private static final long SECOND_IN_NS;
    private static final long RTT_MAX_TIMEOUT_NS;
    private static final int MAX_OUTSTANDING_RTT_MEASUREMENTS = 1;
    private static final double C = 0.4;
    private static final double B = 0.2;
    private final int minWindow;
    private final int mtu;
    private final int maxCwnd;
    private final ErrorHandler errorHandler;
    private long lastLossTimestampNs;
    private long lastUpdateTimestampNs;
    private long lastRttTimestampNs = 0L;
    private final long windowUpdateTimeoutNs;
    private long rttNs;
    private double k;
    private int cwnd;
    private int w_max;
    private int outstandingRttMeasurements = 0;
    private final AtomicCounter rttIndicator;
    private final AtomicCounter windowIndicator;

    public CubicCongestionControl(long registrationId, UdpChannel udpChannel, int streamId, int sessionId, int termLength, int senderMtuLength, InetSocketAddress controlAddress, InetSocketAddress sourceAddress, NanoClock nanoClock, MediaDriver.Context context, CountersManager countersManager) {
        this.mtu = senderMtuLength;
        this.minWindow = senderMtuLength;
        int maxWindow = Math.min(termLength >> 1, context.initialWindowLength());
        this.maxCwnd = maxWindow / this.mtu;
        this.cwnd = 1;
        this.w_max = this.maxCwnd;
        this.k = StrictMath.cbrt((double)this.w_max * 0.2 / 0.4);
        this.windowUpdateTimeoutNs = this.rttNs = CubicCongestionControlConfiguration.INITIAL_RTT_NS;
        this.rttIndicator = PerImageIndicator.allocate(context.tempBuffer(), "rcv-cc-cubic-rtt", countersManager, registrationId, sessionId, streamId, udpChannel.originalUriString());
        this.windowIndicator = PerImageIndicator.allocate(context.tempBuffer(), "rcv-cc-cubic-wnd", countersManager, registrationId, sessionId, streamId, udpChannel.originalUriString());
        this.rttIndicator.setOrdered(0L);
        this.windowIndicator.setOrdered(this.minWindow);
        this.lastUpdateTimestampNs = this.lastLossTimestampNs = nanoClock.nanoTime();
        this.errorHandler = context.errorHandler();
    }

    @Override
    public boolean shouldMeasureRtt(long nowNs) {
        return CubicCongestionControlConfiguration.MEASURE_RTT && this.outstandingRttMeasurements < 1 && (this.lastRttTimestampNs + RTT_MAX_TIMEOUT_NS - nowNs < 0L || this.lastRttTimestampNs + RTT_MEASUREMENT_TIMEOUT_NS - nowNs < 0L);
    }

    @Override
    public void onRttMeasurementSent(long nowNs) {
        this.lastRttTimestampNs = nowNs;
        ++this.outstandingRttMeasurements;
    }

    @Override
    public void onRttMeasurement(long nowNs, long rttNs, InetSocketAddress srcAddress) {
        --this.outstandingRttMeasurements;
        this.lastRttTimestampNs = nowNs;
        this.rttNs = rttNs;
        this.rttIndicator.setOrdered(rttNs);
    }

    @Override
    public long onTrackRebuild(long nowNs, long newConsumptionPosition, long lastSmPosition, long hwmPosition, long startingRebuildPosition, long endingRebuildPosition, boolean lossOccurred) {
        boolean forceStatusMessage = false;
        if (lossOccurred) {
            this.w_max = this.cwnd;
            this.k = StrictMath.cbrt((double)this.w_max * 0.2 / 0.4);
            this.cwnd = Math.max(1, (int)((double)this.cwnd * 0.8));
            this.lastLossTimestampNs = nowNs;
            forceStatusMessage = true;
        } else if (this.cwnd < this.maxCwnd && this.lastUpdateTimestampNs + this.windowUpdateTimeoutNs - nowNs < 0L) {
            double durationSinceDecr = (double)(nowNs - this.lastLossTimestampNs) / (double)SECOND_IN_NS;
            double diffToK = durationSinceDecr - this.k;
            double incr = 0.4 * diffToK * diffToK * diffToK;
            this.cwnd = Math.min(this.maxCwnd, this.w_max + (int)incr);
            if (CubicCongestionControlConfiguration.TCP_MODE && this.cwnd < this.w_max) {
                double rttInSeconds = (double)this.rttNs / (double)SECOND_IN_NS;
                double wTcp = (double)this.w_max * 0.8 + 0.33333333333333337 * (durationSinceDecr / rttInSeconds);
                this.cwnd = Math.max(this.cwnd, (int)wTcp);
            }
            this.lastUpdateTimestampNs = nowNs;
        }
        int window = this.cwnd * this.mtu;
        this.windowIndicator.setOrdered(window);
        return CongestionControl.packOutcome(window, forceStatusMessage);
    }

    @Override
    public int initialWindowLength() {
        return this.minWindow;
    }

    @Override
    public void close() {
        CloseHelper.close(this.errorHandler, this.rttIndicator);
        CloseHelper.close(this.errorHandler, this.windowIndicator);
    }

    static {
        RTT_MAX_TIMEOUT_NS = SECOND_IN_NS = TimeUnit.SECONDS.toNanos(1L);
    }
}

