/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.ChannelUri;
import io.aeron.ErrorCode;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.media.DynamicSndMultiDestination;
import io.aeron.driver.media.ManualSndMultiDestination;
import io.aeron.driver.media.MultiSndDestination;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.exceptions.ControlProtocolException;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import io.aeron.status.ChannelEndpointStatus;
import io.aeron.status.LocalSocketAddressStatus;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.agrona.collections.Hashing;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

public class SendChannelEndpoint
extends UdpChannelTransport {
    static final long DESTINATION_TIMEOUT = TimeUnit.SECONDS.toNanos(5L);
    private int refCount = 0;
    protected long timeOfLastResolutionNs;
    private final Long2ObjectHashMap<NetworkPublication> publicationBySessionAndStreamId = new Long2ObjectHashMap();
    private final MultiSndDestination multiSndDestination;
    private final AtomicCounter statusMessagesReceived;
    private final AtomicCounter nakMessagesReceived;
    private final AtomicCounter statusIndicator;
    private AtomicCounter localSocketAddressIndicator;

    public SendChannelEndpoint(UdpChannel udpChannel, AtomicCounter statusIndicator, MediaDriver.Context context) {
        super(udpChannel, udpChannel.remoteControl(), udpChannel.localControl(), udpChannel.hasExplicitControl() || udpChannel.isManualControlMode() ? null : udpChannel.remoteData(), context);
        this.nakMessagesReceived = context.systemCounters().get(SystemCounterDescriptor.NAK_MESSAGES_RECEIVED);
        this.statusMessagesReceived = context.systemCounters().get(SystemCounterDescriptor.STATUS_MESSAGES_RECEIVED);
        this.statusIndicator = statusIndicator;
        MultiSndDestination multiSndDestination = null;
        if (udpChannel.isManualControlMode()) {
            multiSndDestination = new ManualSndMultiDestination(context.cachedNanoClock());
        } else if (udpChannel.isDynamicControlMode() || udpChannel.hasExplicitControl()) {
            multiSndDestination = new DynamicSndMultiDestination(context.cachedNanoClock());
        }
        this.multiSndDestination = multiSndDestination;
    }

    public void localSocketAddressIndicator(AtomicCounter counter) {
        this.localSocketAddressIndicator = counter;
    }

    public void decRef() {
        --this.refCount;
    }

    public void incRef() {
        ++this.refCount;
    }

    public void openChannel(DriverConductorProxy conductorProxy) {
        if (conductorProxy.notConcurrent()) {
            this.openDatagramChannel(this.statusIndicator);
        } else {
            try {
                this.openDatagramChannel(this.statusIndicator);
            }
            catch (Exception ex) {
                conductorProxy.channelEndpointError(this.statusIndicator.id(), ex);
                throw ex;
            }
        }
        LocalSocketAddressStatus.updateBindAddress(Objects.requireNonNull(this.localSocketAddressIndicator, "localSocketAddressIndicator not allocated"), this.bindAddressAndPort(), this.context.countersMetaDataBuffer());
        this.localSocketAddressIndicator.setOrdered(1L);
    }

    public String originalUriString() {
        return this.udpChannel().originalUriString();
    }

    public int statusIndicatorCounterId() {
        return this.statusIndicator.id();
    }

    public void indicateActive() {
        long currentStatus = this.statusIndicator.get();
        if (currentStatus != 0L) {
            throw new IllegalStateException("channel cannot be registered unless INITIALIZING: status=" + ChannelEndpointStatus.status(currentStatus));
        }
        this.statusIndicator.appendToLabel(this.bindAddressAndPort());
        this.statusIndicator.setOrdered(1L);
    }

    public void closeStatusIndicator() {
        this.statusIndicator.close();
        if (null != this.localSocketAddressIndicator) {
            this.localSocketAddressIndicator.close();
        }
    }

    public boolean shouldBeClosed() {
        return 0 == this.refCount && !this.statusIndicator.isClosed();
    }

    public void registerForSend(NetworkPublication publication) {
        this.publicationBySessionAndStreamId.put(Hashing.compoundKey(publication.sessionId(), publication.streamId()), publication);
    }

    public void unregisterForSend(NetworkPublication publication) {
        this.publicationBySessionAndStreamId.remove(Hashing.compoundKey(publication.sessionId(), publication.streamId()));
    }

    public int send(ByteBuffer buffer) {
        int bytesSent = 0;
        if (null != this.sendDatagramChannel) {
            int bytesToSend = buffer.remaining();
            if (null == this.multiSndDestination) {
                try {
                    this.sendHook(buffer, this.connectAddress);
                    if (this.sendDatagramChannel.isConnected()) {
                        bytesSent = this.sendDatagramChannel.write(buffer);
                    }
                }
                catch (PortUnreachableException portUnreachableException) {
                }
                catch (IOException ex) {
                    SendChannelEndpoint.sendError(bytesToSend, ex, this.connectAddress);
                }
            } else {
                bytesSent = this.multiSndDestination.send(this.sendDatagramChannel, buffer, this, bytesToSend);
            }
        }
        return bytesSent;
    }

    public void checkForReResolution(long nowNs, DriverConductorProxy conductorProxy) {
        long timeOfLastStatusMessageNs;
        if (this.udpChannel.isManualControlMode()) {
            this.multiSndDestination.checkForReResolution(this, nowNs, conductorProxy);
        } else if (this.udpChannel.hasExplicitEndpoint() && !this.udpChannel.isMulticast() && (timeOfLastStatusMessageNs = this.timeOfLastStatusMessageNs()) + DESTINATION_TIMEOUT - nowNs < 0L && this.timeOfLastResolutionNs + DESTINATION_TIMEOUT - nowNs < 0L) {
            String endpoint = this.udpChannel.channelUri().get("endpoint");
            conductorProxy.reResolveEndpoint(endpoint, this, this.udpChannel.remoteData());
            this.timeOfLastResolutionNs = nowNs;
        }
    }

    public void onStatusMessage(StatusMessageFlyweight msg, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        NetworkPublication publication;
        int sessionId = msg.sessionId();
        int streamId = msg.streamId();
        if (null != this.multiSndDestination) {
            this.multiSndDestination.onStatusMessage(msg, srcAddress);
            if (0 == sessionId && 0 == streamId && 128 == (msg.flags() & 0x80)) {
                for (NetworkPublication publication2 : this.publicationBySessionAndStreamId.values()) {
                    publication2.triggerSendSetupFrame();
                }
                this.statusMessagesReceived.incrementOrdered();
            }
        }
        if (null != (publication = this.publicationBySessionAndStreamId.get(Hashing.compoundKey(sessionId, streamId)))) {
            if (128 == (msg.flags() & 0x80)) {
                publication.triggerSendSetupFrame();
            } else {
                publication.onStatusMessage(msg, srcAddress);
            }
            this.statusMessagesReceived.incrementOrdered();
        }
    }

    public void onNakMessage(NakFlyweight msg, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        long key = Hashing.compoundKey(msg.sessionId(), msg.streamId());
        NetworkPublication publication = this.publicationBySessionAndStreamId.get(key);
        if (null != publication) {
            publication.onNak(msg.termId(), msg.termOffset(), msg.length());
            this.nakMessagesReceived.incrementOrdered();
        }
    }

    public void onRttMeasurement(RttMeasurementFlyweight msg, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        long key = Hashing.compoundKey(msg.sessionId(), msg.streamId());
        NetworkPublication publication = this.publicationBySessionAndStreamId.get(key);
        if (null != publication) {
            publication.onRttMeasurement(msg, srcAddress);
        }
    }

    public void validateAllowsManualControl() {
        if (!(this.multiSndDestination instanceof ManualSndMultiDestination)) {
            throw new ControlProtocolException(ErrorCode.INVALID_CHANNEL, "channel does not allow manual control");
        }
    }

    public void addDestination(ChannelUri channelUri, InetSocketAddress address) {
        this.multiSndDestination.addDestination(channelUri, address);
    }

    public void removeDestination(ChannelUri channelUri, InetSocketAddress address) {
        this.multiSndDestination.removeDestination(channelUri, address);
    }

    public void resolutionChange(String endpoint, InetSocketAddress newAddress) {
        if (null != this.multiSndDestination) {
            this.multiSndDestination.updateDestination(endpoint, newAddress);
        } else {
            this.updateEndpoint(newAddress, this.statusIndicator);
        }
    }

    private long timeOfLastStatusMessageNs() {
        long timeNs = 0L;
        for (NetworkPublication publication : this.publicationBySessionAndStreamId.values()) {
            timeNs = Math.max(timeNs, publication.timeOfLastStatusMessageNs());
        }
        return 0L;
    }
}

