/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.MediaDriver;
import io.aeron.driver.media.NetworkUtil;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpTransportPoller;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.FrameDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

public abstract class UdpChannelTransport
implements AutoCloseable {
    protected final MediaDriver.Context context;
    protected final UdpChannel udpChannel;
    protected final AtomicCounter invalidPackets;
    protected final ErrorHandler errorHandler;
    protected UdpTransportPoller transportPoller;
    protected SelectionKey selectionKey;
    protected final InetSocketAddress bindAddress;
    protected final InetSocketAddress endPointAddress;
    protected InetSocketAddress connectAddress;
    protected DatagramChannel sendDatagramChannel;
    protected DatagramChannel receiveDatagramChannel;
    protected int multicastTtl = 0;
    protected boolean isClosed = false;

    public UdpChannelTransport(UdpChannel udpChannel, InetSocketAddress endPointAddress, InetSocketAddress bindAddress, InetSocketAddress connectAddress, MediaDriver.Context context) {
        this.context = context;
        this.udpChannel = udpChannel;
        this.errorHandler = context.errorHandler();
        this.endPointAddress = endPointAddress;
        this.bindAddress = bindAddress;
        this.connectAddress = connectAddress;
        this.invalidPackets = context.systemCounters().get(SystemCounterDescriptor.INVALID_PACKETS);
    }

    public static void sendError(int bytesToSend, IOException ex, InetSocketAddress destination) {
        throw new AeronException("failed to send " + bytesToSend + " byte packet to " + destination, ex, AeronException.Category.WARN);
    }

    public void openDatagramChannel(AtomicCounter statusIndicator) {
        try {
            this.receiveDatagramChannel = this.sendDatagramChannel = DatagramChannel.open(this.udpChannel.protocolFamily());
            if (this.udpChannel.isMulticast()) {
                if (null != this.connectAddress) {
                    this.receiveDatagramChannel = DatagramChannel.open(this.udpChannel.protocolFamily());
                }
                this.receiveDatagramChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
                this.receiveDatagramChannel.bind(new InetSocketAddress(this.endPointAddress.getPort()));
                this.receiveDatagramChannel.join(this.endPointAddress.getAddress(), this.udpChannel.localInterface());
                this.sendDatagramChannel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, this.udpChannel.localInterface());
                if (this.udpChannel.hasMulticastTtl()) {
                    this.sendDatagramChannel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)this.udpChannel.multicastTtl());
                    this.multicastTtl = this.sendDatagramChannel.getOption(StandardSocketOptions.IP_MULTICAST_TTL);
                } else if (this.context.socketMulticastTtl() != 0) {
                    this.sendDatagramChannel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)this.context.socketMulticastTtl());
                    this.multicastTtl = this.sendDatagramChannel.getOption(StandardSocketOptions.IP_MULTICAST_TTL);
                }
            } else {
                this.sendDatagramChannel.bind(this.bindAddress);
            }
            if (null != this.connectAddress) {
                this.sendDatagramChannel.connect(this.connectAddress);
            }
            if (0 != this.context.socketSndbufLength()) {
                this.sendDatagramChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.context.socketSndbufLength());
            }
            if (0 != this.context.socketRcvbufLength()) {
                this.receiveDatagramChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.context.socketRcvbufLength());
            }
            this.sendDatagramChannel.configureBlocking(false);
            this.receiveDatagramChannel.configureBlocking(false);
        }
        catch (IOException ex) {
            if (null != statusIndicator) {
                statusIndicator.setOrdered(-1L);
            }
            CloseHelper.quietClose(this.sendDatagramChannel);
            if (this.receiveDatagramChannel != this.sendDatagramChannel) {
                CloseHelper.quietClose(this.receiveDatagramChannel);
            }
            this.sendDatagramChannel = null;
            this.receiveDatagramChannel = null;
            String message = "channel error - " + ex.getMessage() + " (at " + ex.getStackTrace()[0].toString() + "): " + this.udpChannel.originalUriString();
            throw new AeronException(message, ex);
        }
    }

    public void registerForRead(UdpTransportPoller transportPoller) {
        this.transportPoller = transportPoller;
        this.selectionKey = transportPoller.registerForRead(this);
    }

    public UdpChannel udpChannel() {
        return this.udpChannel;
    }

    public DatagramChannel receiveDatagramChannel() {
        return this.receiveDatagramChannel;
    }

    public int multicastTtl() {
        return this.multicastTtl;
    }

    public String bindAddressAndPort() {
        try {
            InetSocketAddress localAddress = (InetSocketAddress)this.receiveDatagramChannel.getLocalAddress();
            if (null != localAddress) {
                return NetworkUtil.formatAddressAndPort(localAddress.getAddress(), localAddress.getPort());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            if (null != this.selectionKey) {
                this.selectionKey.cancel();
            }
            if (null != this.transportPoller) {
                this.transportPoller.cancelRead(this);
                this.transportPoller.selectNowWithoutProcessing();
            }
            CloseHelper.close(this.errorHandler, this.sendDatagramChannel);
            if (this.receiveDatagramChannel != this.sendDatagramChannel && null != this.receiveDatagramChannel) {
                CloseHelper.close(this.errorHandler, this.receiveDatagramChannel);
            }
            if (null != this.transportPoller) {
                this.transportPoller.selectNowWithoutProcessing();
            }
        }
    }

    public boolean isMulticast() {
        return this.udpChannel.isMulticast();
    }

    public boolean isValidFrame(UnsafeBuffer buffer, int length) {
        boolean isFrameValid = true;
        if (FrameDescriptor.frameVersion(buffer, 0) != 0) {
            isFrameValid = false;
            this.invalidPackets.increment();
        } else if (length < 8) {
            isFrameValid = false;
            this.invalidPackets.increment();
        }
        return isFrameValid;
    }

    public void sendHook(ByteBuffer buffer, InetSocketAddress address) {
    }

    public void receiveHook(UnsafeBuffer buffer, int length, InetSocketAddress address) {
    }

    public InetSocketAddress receive(ByteBuffer buffer) {
        buffer.clear();
        InetSocketAddress address = null;
        try {
            if (this.receiveDatagramChannel.isOpen()) {
                address = (InetSocketAddress)this.receiveDatagramChannel.receive(buffer);
            }
        }
        catch (PortUnreachableException portUnreachableException) {
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return address;
    }

    public void updateEndpoint(InetSocketAddress newAddress, AtomicCounter statusIndicator) {
        try {
            if (null != this.sendDatagramChannel) {
                this.sendDatagramChannel.disconnect();
                this.sendDatagramChannel.connect(newAddress);
                this.connectAddress = newAddress;
                if (null != statusIndicator) {
                    statusIndicator.setOrdered(1L);
                }
            }
        }
        catch (Exception ex) {
            if (null != statusIndicator) {
                statusIndicator.setOrdered(-1L);
            }
            String message = "re-resolve endpoint channel error - " + ex.getMessage() + " (at " + ex.getStackTrace()[0].toString() + "): " + this.udpChannel.originalUriString();
            throw new AeronException(message, ex);
        }
    }
}

