/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.cluster.tutorial;

import io.aeron.ChannelUriStringBuilder;
import io.aeron.CommonContext;
import io.aeron.archive.Archive;
import io.aeron.archive.ArchiveThreadingMode;
import io.aeron.archive.client.AeronArchive;
import io.aeron.cluster.ClusteredMediaDriver;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.service.ClusteredServiceContainer;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.MinMulticastFlowControlSupplier;
import io.aeron.driver.ThreadingMode;
import io.aeron.samples.cluster.tutorial.BasicAuctionClusteredService;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.NoOpLock;
import org.agrona.concurrent.ShutdownSignalBarrier;

public class BasicAuctionClusteredServiceNode {
    private static final int PORT_BASE = 9000;
    private static final int PORTS_PER_NODE = 100;
    private static final int ARCHIVE_CONTROL_REQUEST_PORT_OFFSET = 1;
    static final int CLIENT_FACING_PORT_OFFSET = 2;
    private static final int MEMBER_FACING_PORT_OFFSET = 3;
    private static final int LOG_PORT_OFFSET = 4;
    private static final int TRANSFER_PORT_OFFSET = 5;
    private static final int LOG_CONTROL_PORT_OFFSET = 6;
    private static final int TERM_LENGTH = 65536;

    private static ErrorHandler errorHandler(String context) {
        return throwable -> {
            System.err.println(context);
            throwable.printStackTrace(System.err);
        };
    }

    static int calculatePort(int nodeId, int offset) {
        return 9000 + nodeId * 100 + offset;
    }

    private static String udpChannel(int nodeId, String hostname, int portOffset) {
        int port = BasicAuctionClusteredServiceNode.calculatePort(nodeId, portOffset);
        return new ChannelUriStringBuilder().media("udp").termLength(65536).endpoint(hostname + ":" + port).build();
    }

    private static String logControlChannel(int nodeId, String hostname, int portOffset) {
        int port = BasicAuctionClusteredServiceNode.calculatePort(nodeId, portOffset);
        return new ChannelUriStringBuilder().media("udp").termLength(65536).controlMode("manual").controlEndpoint(hostname + ":" + port).build();
    }

    public static String clusterMembers(List<String> hostnames) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < hostnames.size(); ++i) {
            sb.append(i);
            sb.append(',').append(hostnames.get(i)).append(':').append(BasicAuctionClusteredServiceNode.calculatePort(i, 2));
            sb.append(',').append(hostnames.get(i)).append(':').append(BasicAuctionClusteredServiceNode.calculatePort(i, 3));
            sb.append(',').append(hostnames.get(i)).append(':').append(BasicAuctionClusteredServiceNode.calculatePort(i, 4));
            sb.append(',').append(hostnames.get(i)).append(':').append(BasicAuctionClusteredServiceNode.calculatePort(i, 5));
            sb.append(',').append(hostnames.get(i)).append(':').append(BasicAuctionClusteredServiceNode.calculatePort(i, 1));
            sb.append('|');
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        int nodeId = Integer.parseInt(System.getProperty("aeron.cluster.tutorial.nodeId"));
        List<String> hostnames = Arrays.asList("localhost", "localhost", "localhost");
        String hostname = hostnames.get(nodeId);
        File baseDir = new File(System.getProperty("user.dir"), "node" + nodeId);
        String aeronDirName = CommonContext.getAeronDirectoryName() + "-" + nodeId + "-driver";
        ShutdownSignalBarrier barrier = new ShutdownSignalBarrier();
        MediaDriver.Context mediaDriverContext = new MediaDriver.Context().aeronDirectoryName(aeronDirName).threadingMode(ThreadingMode.SHARED).termBufferSparseFile(true).multicastFlowControlSupplier(new MinMulticastFlowControlSupplier()).terminationHook(barrier::signal).errorHandler(BasicAuctionClusteredServiceNode.errorHandler("Media Driver"));
        Archive.Context archiveContext = new Archive.Context().aeronDirectoryName(aeronDirName).archiveDir(new File(baseDir, "archive")).controlChannel(BasicAuctionClusteredServiceNode.udpChannel(nodeId, "localhost", 1)).localControlChannel("aeron:ipc?term-length=64k").recordingEventsEnabled(false).threadingMode(ArchiveThreadingMode.SHARED);
        AeronArchive.Context aeronArchiveContext = new AeronArchive.Context().lock(NoOpLock.INSTANCE).controlRequestChannel(archiveContext.controlChannel()).controlRequestStreamId(archiveContext.controlStreamId()).controlResponseChannel("aeron:udp?endpoint=localhost:0|term-length=64k").aeronDirectoryName(aeronDirName);
        ConsensusModule.Context consensusModuleContext = new ConsensusModule.Context().errorHandler(BasicAuctionClusteredServiceNode.errorHandler("Consensus Module")).clusterMemberId(nodeId).clusterMembers(BasicAuctionClusteredServiceNode.clusterMembers(hostnames)).clusterDir(new File(baseDir, "consensus-module")).ingressChannel("aeron:udp?term-length=64k").logChannel(BasicAuctionClusteredServiceNode.logControlChannel(nodeId, hostname, 6)).archiveContext(aeronArchiveContext.clone());
        ClusteredServiceContainer.Context clusteredServiceContext = new ClusteredServiceContainer.Context().aeronDirectoryName(aeronDirName).archiveContext(aeronArchiveContext.clone()).clusterDir(new File(baseDir, "service")).clusteredService(new BasicAuctionClusteredService()).errorHandler(BasicAuctionClusteredServiceNode.errorHandler("Clustered Service"));
        try (ClusteredMediaDriver clusteredMediaDriver = ClusteredMediaDriver.launch(mediaDriverContext, archiveContext, consensusModuleContext);
             ClusteredServiceContainer container = ClusteredServiceContainer.launch(clusteredServiceContext);){
            System.out.println("[" + nodeId + "] Started Cluster Node on " + hostname + "...");
            barrier.await();
            System.out.println("[" + nodeId + "] Exiting");
        }
    }
}

