/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs;


/**
 * Language independent boolean type.
 */
public enum BooleanType
{

    /**
     * Language independent boolean false.
     */
    FALSE(0),


    /**
     * Language independent boolean true.
     */
    TRUE(1),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    BooleanType(final int value)
    {
        this.value = value;
    }

    /**
     * The raw encoded value in the Java type representation.
     *
     * @return the raw value encoded.
     */
    public int value()
    {
        return value;
    }

    /**
     * Lookup the enum value representing the value.
     *
     * @param value encoded to be looked up.
     * @return the enum value representing the value.
     */
    public static BooleanType get(final int value)
    {
        switch (value)
        {
            case 0: return FALSE;
            case 1: return TRUE;
            case -2147483648: return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
