/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs;


/**
 * Signal of operations happening to a recording.
 */
public enum RecordingSignal
{

    /**
     * Recording has started for a stream.
     */
    START(0),


    /**
     * Recording has stopped for a stream.
     */
    STOP(1),


    /**
     * Recording has started extending.
     */
    EXTEND(2),


    /**
     * Recording descriptor replicated from source archive.
     */
    REPLICATE(3),


    /**
     * Recording merged with live stream after replay.
     */
    MERGE(4),


    /**
     * Recording synchronised with source archive.
     */
    SYNC(5),


    /**
     * Recording has deleted segments.
     */
    DELETE(6),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    RecordingSignal(final int value)
    {
        this.value = value;
    }

    /**
     * The raw encoded value in the Java type representation.
     *
     * @return the raw value encoded.
     */
    public int value()
    {
        return value;
    }

    /**
     * Lookup the enum value representing the value.
     *
     * @param value encoded to be looked up.
     * @return the enum value representing the value.
     */
    public static RecordingSignal get(final int value)
    {
        switch (value)
        {
            case 0: return START;
            case 1: return STOP;
            case 2: return EXTEND;
            case 3: return REPLICATE;
            case 4: return MERGE;
            case 5: return SYNC;
            case 6: return DELETE;
            case -2147483648: return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
