/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs;


/**
 * Source location for recorded stream.
 */
public enum SourceLocation
{

    /**
     * Archive is local to driver.
     */
    LOCAL(0),


    /**
     * Archive is remote to driver.
     */
    REMOTE(1),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    SourceLocation(final int value)
    {
        this.value = value;
    }

    /**
     * The raw encoded value in the Java type representation.
     *
     * @return the raw value encoded.
     */
    public int value()
    {
        return value;
    }

    /**
     * Lookup the enum value representing the value.
     *
     * @param value encoded to be looked up.
     * @return the enum value representing the value.
     */
    public static SourceLocation get(final int value)
    {
        switch (value)
        {
            case 0: return LOCAL;
            case 1: return REMOTE;
            case -2147483648: return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
