/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;


/**
 * Response to backup query that includes all relevant information for backup operation.
 */
@SuppressWarnings("all")
public final class BackupResponseEncoder
{
    public static final int BLOCK_LENGTH = 56;
    public static final int TEMPLATE_ID = 78;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 6;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final BackupResponseEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public BackupResponseEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public BackupResponseEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int correlationIdId()
    {
        return 1;
    }

    public static int correlationIdSinceVersion()
    {
        return 0;
    }

    public static int correlationIdEncodingOffset()
    {
        return 0;
    }

    public static int correlationIdEncodingLength()
    {
        return 8;
    }

    public static String correlationIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long correlationIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long correlationIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public BackupResponseEncoder correlationId(final long value)
    {
        buffer.putLong(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int logRecordingIdId()
    {
        return 2;
    }

    public static int logRecordingIdSinceVersion()
    {
        return 0;
    }

    public static int logRecordingIdEncodingOffset()
    {
        return 8;
    }

    public static int logRecordingIdEncodingLength()
    {
        return 8;
    }

    public static String logRecordingIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long logRecordingIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logRecordingIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logRecordingIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public BackupResponseEncoder logRecordingId(final long value)
    {
        buffer.putLong(offset + 8, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int logLeadershipTermIdId()
    {
        return 3;
    }

    public static int logLeadershipTermIdSinceVersion()
    {
        return 0;
    }

    public static int logLeadershipTermIdEncodingOffset()
    {
        return 16;
    }

    public static int logLeadershipTermIdEncodingLength()
    {
        return 8;
    }

    public static String logLeadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long logLeadershipTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logLeadershipTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logLeadershipTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public BackupResponseEncoder logLeadershipTermId(final long value)
    {
        buffer.putLong(offset + 16, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int logTermBaseLogPositionId()
    {
        return 4;
    }

    public static int logTermBaseLogPositionSinceVersion()
    {
        return 0;
    }

    public static int logTermBaseLogPositionEncodingOffset()
    {
        return 24;
    }

    public static int logTermBaseLogPositionEncodingLength()
    {
        return 8;
    }

    public static String logTermBaseLogPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long logTermBaseLogPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logTermBaseLogPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logTermBaseLogPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public BackupResponseEncoder logTermBaseLogPosition(final long value)
    {
        buffer.putLong(offset + 24, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int lastLeadershipTermIdId()
    {
        return 5;
    }

    public static int lastLeadershipTermIdSinceVersion()
    {
        return 0;
    }

    public static int lastLeadershipTermIdEncodingOffset()
    {
        return 32;
    }

    public static int lastLeadershipTermIdEncodingLength()
    {
        return 8;
    }

    public static String lastLeadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long lastLeadershipTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long lastLeadershipTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long lastLeadershipTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public BackupResponseEncoder lastLeadershipTermId(final long value)
    {
        buffer.putLong(offset + 32, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int lastTermBaseLogPositionId()
    {
        return 6;
    }

    public static int lastTermBaseLogPositionSinceVersion()
    {
        return 0;
    }

    public static int lastTermBaseLogPositionEncodingOffset()
    {
        return 40;
    }

    public static int lastTermBaseLogPositionEncodingLength()
    {
        return 8;
    }

    public static String lastTermBaseLogPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long lastTermBaseLogPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long lastTermBaseLogPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long lastTermBaseLogPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public BackupResponseEncoder lastTermBaseLogPosition(final long value)
    {
        buffer.putLong(offset + 40, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int commitPositionCounterIdId()
    {
        return 7;
    }

    public static int commitPositionCounterIdSinceVersion()
    {
        return 0;
    }

    public static int commitPositionCounterIdEncodingOffset()
    {
        return 48;
    }

    public static int commitPositionCounterIdEncodingLength()
    {
        return 4;
    }

    public static String commitPositionCounterIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int commitPositionCounterIdNullValue()
    {
        return -2147483648;
    }

    public static int commitPositionCounterIdMinValue()
    {
        return -2147483647;
    }

    public static int commitPositionCounterIdMaxValue()
    {
        return 2147483647;
    }

    public BackupResponseEncoder commitPositionCounterId(final int value)
    {
        buffer.putInt(offset + 48, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int leaderMemberIdId()
    {
        return 8;
    }

    public static int leaderMemberIdSinceVersion()
    {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset()
    {
        return 52;
    }

    public static int leaderMemberIdEncodingLength()
    {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int leaderMemberIdNullValue()
    {
        return -2147483648;
    }

    public static int leaderMemberIdMinValue()
    {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue()
    {
        return 2147483647;
    }

    public BackupResponseEncoder leaderMemberId(final int value)
    {
        buffer.putInt(offset + 52, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    private final SnapshotsEncoder snapshots = new SnapshotsEncoder(this);

    public static long snapshotsId()
    {
        return 9;
    }

    /**
     * Snapshots of state for the consensus module and services.
     *
     * @param count of times the group will be encoded.
     * @return SnapshotsEncoder : encoder for the group.
     */
    public SnapshotsEncoder snapshotsCount(final int count)
    {
        snapshots.wrap(buffer, count);
        return snapshots;
    }

    /**
     * Snapshots of state for the consensus module and services.
     */

    public static final class SnapshotsEncoder
    {
        public static final int HEADER_SIZE = 4;
        private final BackupResponseEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        SnapshotsEncoder(final BackupResponseEncoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final MutableDirectBuffer buffer, final int count)
        {
            if (count < 0 || count > 65534)
            {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }

            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = 0;
            this.count = count;
            final int limit = parentMessage.limit();
            initialLimit = limit;
            parentMessage.limit(limit + HEADER_SIZE);
            buffer.putShort(limit + 0, (short)44, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putShort(limit + 2, (short)count, java.nio.ByteOrder.LITTLE_ENDIAN);
        }

        public SnapshotsEncoder next()
        {
            if (index >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + sbeBlockLength());
            ++index;

            return this;
        }

        public int resetCountToIndex()
        {
            count = index;
            buffer.putShort(initialLimit + 2, (short)count, java.nio.ByteOrder.LITTLE_ENDIAN);

            return count;
        }

        public static int countMinValue()
        {
            return 0;
        }

        public static int countMaxValue()
        {
            return 65534;
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 44;
        }

        public static int recordingIdId()
        {
            return 10;
        }

        public static int recordingIdSinceVersion()
        {
            return 0;
        }

        public static int recordingIdEncodingOffset()
        {
            return 0;
        }

        public static int recordingIdEncodingLength()
        {
            return 8;
        }

        public static String recordingIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long recordingIdNullValue()
        {
            return -9223372036854775808L;
        }

        public static long recordingIdMinValue()
        {
            return -9223372036854775807L;
        }

        public static long recordingIdMaxValue()
        {
            return 9223372036854775807L;
        }

        public SnapshotsEncoder recordingId(final long value)
        {
            buffer.putLong(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int leadershipTermIdId()
        {
            return 11;
        }

        public static int leadershipTermIdSinceVersion()
        {
            return 0;
        }

        public static int leadershipTermIdEncodingOffset()
        {
            return 8;
        }

        public static int leadershipTermIdEncodingLength()
        {
            return 8;
        }

        public static String leadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long leadershipTermIdNullValue()
        {
            return -9223372036854775808L;
        }

        public static long leadershipTermIdMinValue()
        {
            return -9223372036854775807L;
        }

        public static long leadershipTermIdMaxValue()
        {
            return 9223372036854775807L;
        }

        public SnapshotsEncoder leadershipTermId(final long value)
        {
            buffer.putLong(offset + 8, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int termBaseLogPositionId()
        {
            return 12;
        }

        public static int termBaseLogPositionSinceVersion()
        {
            return 0;
        }

        public static int termBaseLogPositionEncodingOffset()
        {
            return 16;
        }

        public static int termBaseLogPositionEncodingLength()
        {
            return 8;
        }

        public static String termBaseLogPositionMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long termBaseLogPositionNullValue()
        {
            return -9223372036854775808L;
        }

        public static long termBaseLogPositionMinValue()
        {
            return -9223372036854775807L;
        }

        public static long termBaseLogPositionMaxValue()
        {
            return 9223372036854775807L;
        }

        public SnapshotsEncoder termBaseLogPosition(final long value)
        {
            buffer.putLong(offset + 16, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int logPositionId()
        {
            return 13;
        }

        public static int logPositionSinceVersion()
        {
            return 0;
        }

        public static int logPositionEncodingOffset()
        {
            return 24;
        }

        public static int logPositionEncodingLength()
        {
            return 8;
        }

        public static String logPositionMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long logPositionNullValue()
        {
            return -9223372036854775808L;
        }

        public static long logPositionMinValue()
        {
            return -9223372036854775807L;
        }

        public static long logPositionMaxValue()
        {
            return 9223372036854775807L;
        }

        public SnapshotsEncoder logPosition(final long value)
        {
            buffer.putLong(offset + 24, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int timestampId()
        {
            return 14;
        }

        public static int timestampSinceVersion()
        {
            return 0;
        }

        public static int timestampEncodingOffset()
        {
            return 32;
        }

        public static int timestampEncodingLength()
        {
            return 8;
        }

        public static String timestampMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long timestampNullValue()
        {
            return -9223372036854775808L;
        }

        public static long timestampMinValue()
        {
            return -9223372036854775807L;
        }

        public static long timestampMaxValue()
        {
            return 9223372036854775807L;
        }

        public SnapshotsEncoder timestamp(final long value)
        {
            buffer.putLong(offset + 32, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int serviceIdId()
        {
            return 15;
        }

        public static int serviceIdSinceVersion()
        {
            return 0;
        }

        public static int serviceIdEncodingOffset()
        {
            return 40;
        }

        public static int serviceIdEncodingLength()
        {
            return 4;
        }

        public static String serviceIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int serviceIdNullValue()
        {
            return -2147483648;
        }

        public static int serviceIdMinValue()
        {
            return -2147483647;
        }

        public static int serviceIdMaxValue()
        {
            return 2147483647;
        }

        public SnapshotsEncoder serviceId(final int value)
        {
            buffer.putInt(offset + 40, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }

    }

    public static int clusterMembersId()
    {
        return 16;
    }

    public static String clusterMembersCharacterEncoding()
    {
        return "US-ASCII";
    }

    public static String clusterMembersMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int clusterMembersHeaderLength()
    {
        return 4;
    }

    public BackupResponseEncoder putClusterMembers(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public BackupResponseEncoder putClusterMembers(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public BackupResponseEncoder clusterMembers(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public BackupResponseEncoder clusterMembers(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < length; ++i)
        {
            final char charValue = value.charAt(i);
            final byte byteValue = charValue > 127 ? (byte)'?' : (byte)charValue;
            buffer.putByte(limit + headerLength + i, byteValue);
        }

        return this;
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final BackupResponseDecoder decoder = new BackupResponseDecoder();
        decoder.wrap(buffer, initialOffset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
