/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;


/**
 * Action to be taken by cluster nodes.
 */
public enum ClusterAction
{

    /**
     * Suspend ingress to the cluster.
     */
    SUSPEND(0),


    /**
     * Resume ingress to the cluster.
     */
    RESUME(1),


    /**
     * Snapshot state in the cluster.
     */
    SNAPSHOT(2),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    ClusterAction(final int value)
    {
        this.value = value;
    }

    /**
     * The raw encoded value in the Java type representation.
     *
     * @return the raw value encoded.
     */
    public int value()
    {
        return value;
    }

    /**
     * Lookup the enum value representing the value.
     *
     * @param value encoded to be looked up.
     * @return the enum value representing the value.
     */
    public static ClusterAction get(final int value)
    {
        switch (value)
        {
            case 0: return SUSPEND;
            case 1: return RESUME;
            case 2: return SNAPSHOT;
            case -2147483648: return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
