/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;


/**
 * Cluster Members status for active and passive members
 */
@SuppressWarnings("all")
public final class ClusterMembersExtendedResponseEncoder
{
    public static final int BLOCK_LENGTH = 24;
    public static final int TEMPLATE_ID = 43;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 6;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final ClusterMembersExtendedResponseEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public ClusterMembersExtendedResponseEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public ClusterMembersExtendedResponseEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int correlationIdId()
    {
        return 1;
    }

    public static int correlationIdSinceVersion()
    {
        return 0;
    }

    public static int correlationIdEncodingOffset()
    {
        return 0;
    }

    public static int correlationIdEncodingLength()
    {
        return 8;
    }

    public static String correlationIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long correlationIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long correlationIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public ClusterMembersExtendedResponseEncoder correlationId(final long value)
    {
        buffer.putLong(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int currentTimeNsId()
    {
        return 2;
    }

    public static int currentTimeNsSinceVersion()
    {
        return 0;
    }

    public static int currentTimeNsEncodingOffset()
    {
        return 8;
    }

    public static int currentTimeNsEncodingLength()
    {
        return 8;
    }

    public static String currentTimeNsMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long currentTimeNsNullValue()
    {
        return -9223372036854775808L;
    }

    public static long currentTimeNsMinValue()
    {
        return -9223372036854775807L;
    }

    public static long currentTimeNsMaxValue()
    {
        return 9223372036854775807L;
    }

    public ClusterMembersExtendedResponseEncoder currentTimeNs(final long value)
    {
        buffer.putLong(offset + 8, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int leaderMemberIdId()
    {
        return 3;
    }

    public static int leaderMemberIdSinceVersion()
    {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset()
    {
        return 16;
    }

    public static int leaderMemberIdEncodingLength()
    {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int leaderMemberIdNullValue()
    {
        return -2147483648;
    }

    public static int leaderMemberIdMinValue()
    {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue()
    {
        return 2147483647;
    }

    public ClusterMembersExtendedResponseEncoder leaderMemberId(final int value)
    {
        buffer.putInt(offset + 16, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int memberIdId()
    {
        return 4;
    }

    public static int memberIdSinceVersion()
    {
        return 0;
    }

    public static int memberIdEncodingOffset()
    {
        return 20;
    }

    public static int memberIdEncodingLength()
    {
        return 4;
    }

    public static String memberIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int memberIdNullValue()
    {
        return -2147483648;
    }

    public static int memberIdMinValue()
    {
        return -2147483647;
    }

    public static int memberIdMaxValue()
    {
        return 2147483647;
    }

    public ClusterMembersExtendedResponseEncoder memberId(final int value)
    {
        buffer.putInt(offset + 20, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    private final ActiveMembersEncoder activeMembers = new ActiveMembersEncoder(this);

    public static long activeMembersId()
    {
        return 5;
    }

    /**
     * Members of the cluster which have voting rights.
     *
     * @param count of times the group will be encoded.
     * @return ActiveMembersEncoder : encoder for the group.
     */
    public ActiveMembersEncoder activeMembersCount(final int count)
    {
        activeMembers.wrap(buffer, count);
        return activeMembers;
    }

    /**
     * Members of the cluster which have voting rights.
     */

    public static final class ActiveMembersEncoder
    {
        public static final int HEADER_SIZE = 4;
        private final ClusterMembersExtendedResponseEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        ActiveMembersEncoder(final ClusterMembersExtendedResponseEncoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final MutableDirectBuffer buffer, final int count)
        {
            if (count < 0 || count > 65534)
            {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }

            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = 0;
            this.count = count;
            final int limit = parentMessage.limit();
            initialLimit = limit;
            parentMessage.limit(limit + HEADER_SIZE);
            buffer.putShort(limit + 0, (short)28, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putShort(limit + 2, (short)count, java.nio.ByteOrder.LITTLE_ENDIAN);
        }

        public ActiveMembersEncoder next()
        {
            if (index >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + sbeBlockLength());
            ++index;

            return this;
        }

        public int resetCountToIndex()
        {
            count = index;
            buffer.putShort(initialLimit + 2, (short)count, java.nio.ByteOrder.LITTLE_ENDIAN);

            return count;
        }

        public static int countMinValue()
        {
            return 0;
        }

        public static int countMaxValue()
        {
            return 65534;
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 28;
        }

        public static int leadershipTermIdId()
        {
            return 6;
        }

        public static int leadershipTermIdSinceVersion()
        {
            return 0;
        }

        public static int leadershipTermIdEncodingOffset()
        {
            return 0;
        }

        public static int leadershipTermIdEncodingLength()
        {
            return 8;
        }

        public static String leadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long leadershipTermIdNullValue()
        {
            return -9223372036854775808L;
        }

        public static long leadershipTermIdMinValue()
        {
            return -9223372036854775807L;
        }

        public static long leadershipTermIdMaxValue()
        {
            return 9223372036854775807L;
        }

        public ActiveMembersEncoder leadershipTermId(final long value)
        {
            buffer.putLong(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int logPositionId()
        {
            return 7;
        }

        public static int logPositionSinceVersion()
        {
            return 0;
        }

        public static int logPositionEncodingOffset()
        {
            return 8;
        }

        public static int logPositionEncodingLength()
        {
            return 8;
        }

        public static String logPositionMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long logPositionNullValue()
        {
            return -9223372036854775808L;
        }

        public static long logPositionMinValue()
        {
            return -9223372036854775807L;
        }

        public static long logPositionMaxValue()
        {
            return 9223372036854775807L;
        }

        public ActiveMembersEncoder logPosition(final long value)
        {
            buffer.putLong(offset + 8, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int timeOfLastAppendNsId()
        {
            return 8;
        }

        public static int timeOfLastAppendNsSinceVersion()
        {
            return 0;
        }

        public static int timeOfLastAppendNsEncodingOffset()
        {
            return 16;
        }

        public static int timeOfLastAppendNsEncodingLength()
        {
            return 8;
        }

        public static String timeOfLastAppendNsMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long timeOfLastAppendNsNullValue()
        {
            return -9223372036854775808L;
        }

        public static long timeOfLastAppendNsMinValue()
        {
            return -9223372036854775807L;
        }

        public static long timeOfLastAppendNsMaxValue()
        {
            return 9223372036854775807L;
        }

        public ActiveMembersEncoder timeOfLastAppendNs(final long value)
        {
            buffer.putLong(offset + 16, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int memberIdId()
        {
            return 9;
        }

        public static int memberIdSinceVersion()
        {
            return 0;
        }

        public static int memberIdEncodingOffset()
        {
            return 24;
        }

        public static int memberIdEncodingLength()
        {
            return 4;
        }

        public static String memberIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int memberIdNullValue()
        {
            return -2147483648;
        }

        public static int memberIdMinValue()
        {
            return -2147483647;
        }

        public static int memberIdMaxValue()
        {
            return 2147483647;
        }

        public ActiveMembersEncoder memberId(final int value)
        {
            buffer.putInt(offset + 24, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int ingressEndpointId()
        {
            return 10;
        }

        public static String ingressEndpointCharacterEncoding()
        {
            return "US-ASCII";
        }

        public static String ingressEndpointMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int ingressEndpointHeaderLength()
        {
            return 4;
        }

        public ActiveMembersEncoder putIngressEndpoint(final DirectBuffer src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public ActiveMembersEncoder putIngressEndpoint(final byte[] src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public ActiveMembersEncoder ingressEndpoint(final String value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putStringWithoutLengthAscii(limit + headerLength, value);

            return this;
        }

        public ActiveMembersEncoder ingressEndpoint(final CharSequence value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i)
            {
                final char charValue = value.charAt(i);
                final byte byteValue = charValue > 127 ? (byte)'?' : (byte)charValue;
                buffer.putByte(limit + headerLength + i, byteValue);
            }

            return this;
        }

        public static int consensusEndpointId()
        {
            return 11;
        }

        public static String consensusEndpointCharacterEncoding()
        {
            return "US-ASCII";
        }

        public static String consensusEndpointMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int consensusEndpointHeaderLength()
        {
            return 4;
        }

        public ActiveMembersEncoder putConsensusEndpoint(final DirectBuffer src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public ActiveMembersEncoder putConsensusEndpoint(final byte[] src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public ActiveMembersEncoder consensusEndpoint(final String value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putStringWithoutLengthAscii(limit + headerLength, value);

            return this;
        }

        public ActiveMembersEncoder consensusEndpoint(final CharSequence value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i)
            {
                final char charValue = value.charAt(i);
                final byte byteValue = charValue > 127 ? (byte)'?' : (byte)charValue;
                buffer.putByte(limit + headerLength + i, byteValue);
            }

            return this;
        }

        public static int logEndpointId()
        {
            return 12;
        }

        public static String logEndpointCharacterEncoding()
        {
            return "US-ASCII";
        }

        public static String logEndpointMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int logEndpointHeaderLength()
        {
            return 4;
        }

        public ActiveMembersEncoder putLogEndpoint(final DirectBuffer src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public ActiveMembersEncoder putLogEndpoint(final byte[] src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public ActiveMembersEncoder logEndpoint(final String value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putStringWithoutLengthAscii(limit + headerLength, value);

            return this;
        }

        public ActiveMembersEncoder logEndpoint(final CharSequence value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i)
            {
                final char charValue = value.charAt(i);
                final byte byteValue = charValue > 127 ? (byte)'?' : (byte)charValue;
                buffer.putByte(limit + headerLength + i, byteValue);
            }

            return this;
        }

        public static int catchupEndpointId()
        {
            return 13;
        }

        public static String catchupEndpointCharacterEncoding()
        {
            return "US-ASCII";
        }

        public static String catchupEndpointMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int catchupEndpointHeaderLength()
        {
            return 4;
        }

        public ActiveMembersEncoder putCatchupEndpoint(final DirectBuffer src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public ActiveMembersEncoder putCatchupEndpoint(final byte[] src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public ActiveMembersEncoder catchupEndpoint(final String value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putStringWithoutLengthAscii(limit + headerLength, value);

            return this;
        }

        public ActiveMembersEncoder catchupEndpoint(final CharSequence value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i)
            {
                final char charValue = value.charAt(i);
                final byte byteValue = charValue > 127 ? (byte)'?' : (byte)charValue;
                buffer.putByte(limit + headerLength + i, byteValue);
            }

            return this;
        }

        public static int archiveEndpointId()
        {
            return 14;
        }

        public static String archiveEndpointCharacterEncoding()
        {
            return "US-ASCII";
        }

        public static String archiveEndpointMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int archiveEndpointHeaderLength()
        {
            return 4;
        }

        public ActiveMembersEncoder putArchiveEndpoint(final DirectBuffer src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public ActiveMembersEncoder putArchiveEndpoint(final byte[] src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public ActiveMembersEncoder archiveEndpoint(final String value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putStringWithoutLengthAscii(limit + headerLength, value);

            return this;
        }

        public ActiveMembersEncoder archiveEndpoint(final CharSequence value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i)
            {
                final char charValue = value.charAt(i);
                final byte byteValue = charValue > 127 ? (byte)'?' : (byte)charValue;
                buffer.putByte(limit + headerLength + i, byteValue);
            }

            return this;
        }
    }

    private final PassiveMembersEncoder passiveMembers = new PassiveMembersEncoder(this);

    public static long passiveMembersId()
    {
        return 15;
    }

    /**
     * Members of the cluster which do not have voting rights but could become active members.
     *
     * @param count of times the group will be encoded.
     * @return PassiveMembersEncoder : encoder for the group.
     */
    public PassiveMembersEncoder passiveMembersCount(final int count)
    {
        passiveMembers.wrap(buffer, count);
        return passiveMembers;
    }

    /**
     * Members of the cluster which do not have voting rights but could become active members.
     */

    public static final class PassiveMembersEncoder
    {
        public static final int HEADER_SIZE = 4;
        private final ClusterMembersExtendedResponseEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        PassiveMembersEncoder(final ClusterMembersExtendedResponseEncoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final MutableDirectBuffer buffer, final int count)
        {
            if (count < 0 || count > 65534)
            {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }

            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = 0;
            this.count = count;
            final int limit = parentMessage.limit();
            initialLimit = limit;
            parentMessage.limit(limit + HEADER_SIZE);
            buffer.putShort(limit + 0, (short)28, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putShort(limit + 2, (short)count, java.nio.ByteOrder.LITTLE_ENDIAN);
        }

        public PassiveMembersEncoder next()
        {
            if (index >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + sbeBlockLength());
            ++index;

            return this;
        }

        public int resetCountToIndex()
        {
            count = index;
            buffer.putShort(initialLimit + 2, (short)count, java.nio.ByteOrder.LITTLE_ENDIAN);

            return count;
        }

        public static int countMinValue()
        {
            return 0;
        }

        public static int countMaxValue()
        {
            return 65534;
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 28;
        }

        public static int leadershipTermIdId()
        {
            return 16;
        }

        public static int leadershipTermIdSinceVersion()
        {
            return 0;
        }

        public static int leadershipTermIdEncodingOffset()
        {
            return 0;
        }

        public static int leadershipTermIdEncodingLength()
        {
            return 8;
        }

        public static String leadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long leadershipTermIdNullValue()
        {
            return -9223372036854775808L;
        }

        public static long leadershipTermIdMinValue()
        {
            return -9223372036854775807L;
        }

        public static long leadershipTermIdMaxValue()
        {
            return 9223372036854775807L;
        }

        public PassiveMembersEncoder leadershipTermId(final long value)
        {
            buffer.putLong(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int logPositionId()
        {
            return 17;
        }

        public static int logPositionSinceVersion()
        {
            return 0;
        }

        public static int logPositionEncodingOffset()
        {
            return 8;
        }

        public static int logPositionEncodingLength()
        {
            return 8;
        }

        public static String logPositionMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long logPositionNullValue()
        {
            return -9223372036854775808L;
        }

        public static long logPositionMinValue()
        {
            return -9223372036854775807L;
        }

        public static long logPositionMaxValue()
        {
            return 9223372036854775807L;
        }

        public PassiveMembersEncoder logPosition(final long value)
        {
            buffer.putLong(offset + 8, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int timeOfLastAppendNsId()
        {
            return 18;
        }

        public static int timeOfLastAppendNsSinceVersion()
        {
            return 0;
        }

        public static int timeOfLastAppendNsEncodingOffset()
        {
            return 16;
        }

        public static int timeOfLastAppendNsEncodingLength()
        {
            return 8;
        }

        public static String timeOfLastAppendNsMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long timeOfLastAppendNsNullValue()
        {
            return -9223372036854775808L;
        }

        public static long timeOfLastAppendNsMinValue()
        {
            return -9223372036854775807L;
        }

        public static long timeOfLastAppendNsMaxValue()
        {
            return 9223372036854775807L;
        }

        public PassiveMembersEncoder timeOfLastAppendNs(final long value)
        {
            buffer.putLong(offset + 16, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int memberIdId()
        {
            return 19;
        }

        public static int memberIdSinceVersion()
        {
            return 0;
        }

        public static int memberIdEncodingOffset()
        {
            return 24;
        }

        public static int memberIdEncodingLength()
        {
            return 4;
        }

        public static String memberIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int memberIdNullValue()
        {
            return -2147483648;
        }

        public static int memberIdMinValue()
        {
            return -2147483647;
        }

        public static int memberIdMaxValue()
        {
            return 2147483647;
        }

        public PassiveMembersEncoder memberId(final int value)
        {
            buffer.putInt(offset + 24, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int ingressEndpointId()
        {
            return 20;
        }

        public static String ingressEndpointCharacterEncoding()
        {
            return "US-ASCII";
        }

        public static String ingressEndpointMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int ingressEndpointHeaderLength()
        {
            return 4;
        }

        public PassiveMembersEncoder putIngressEndpoint(final DirectBuffer src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public PassiveMembersEncoder putIngressEndpoint(final byte[] src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public PassiveMembersEncoder ingressEndpoint(final String value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putStringWithoutLengthAscii(limit + headerLength, value);

            return this;
        }

        public PassiveMembersEncoder ingressEndpoint(final CharSequence value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i)
            {
                final char charValue = value.charAt(i);
                final byte byteValue = charValue > 127 ? (byte)'?' : (byte)charValue;
                buffer.putByte(limit + headerLength + i, byteValue);
            }

            return this;
        }

        public static int consensusEndpointId()
        {
            return 21;
        }

        public static String consensusEndpointCharacterEncoding()
        {
            return "US-ASCII";
        }

        public static String consensusEndpointMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int consensusEndpointHeaderLength()
        {
            return 4;
        }

        public PassiveMembersEncoder putConsensusEndpoint(final DirectBuffer src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public PassiveMembersEncoder putConsensusEndpoint(final byte[] src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public PassiveMembersEncoder consensusEndpoint(final String value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putStringWithoutLengthAscii(limit + headerLength, value);

            return this;
        }

        public PassiveMembersEncoder consensusEndpoint(final CharSequence value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i)
            {
                final char charValue = value.charAt(i);
                final byte byteValue = charValue > 127 ? (byte)'?' : (byte)charValue;
                buffer.putByte(limit + headerLength + i, byteValue);
            }

            return this;
        }

        public static int logEndpointId()
        {
            return 22;
        }

        public static String logEndpointCharacterEncoding()
        {
            return "US-ASCII";
        }

        public static String logEndpointMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int logEndpointHeaderLength()
        {
            return 4;
        }

        public PassiveMembersEncoder putLogEndpoint(final DirectBuffer src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public PassiveMembersEncoder putLogEndpoint(final byte[] src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public PassiveMembersEncoder logEndpoint(final String value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putStringWithoutLengthAscii(limit + headerLength, value);

            return this;
        }

        public PassiveMembersEncoder logEndpoint(final CharSequence value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i)
            {
                final char charValue = value.charAt(i);
                final byte byteValue = charValue > 127 ? (byte)'?' : (byte)charValue;
                buffer.putByte(limit + headerLength + i, byteValue);
            }

            return this;
        }

        public static int catchupEndpointId()
        {
            return 23;
        }

        public static String catchupEndpointCharacterEncoding()
        {
            return "US-ASCII";
        }

        public static String catchupEndpointMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int catchupEndpointHeaderLength()
        {
            return 4;
        }

        public PassiveMembersEncoder putCatchupEndpoint(final DirectBuffer src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public PassiveMembersEncoder putCatchupEndpoint(final byte[] src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public PassiveMembersEncoder catchupEndpoint(final String value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putStringWithoutLengthAscii(limit + headerLength, value);

            return this;
        }

        public PassiveMembersEncoder catchupEndpoint(final CharSequence value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i)
            {
                final char charValue = value.charAt(i);
                final byte byteValue = charValue > 127 ? (byte)'?' : (byte)charValue;
                buffer.putByte(limit + headerLength + i, byteValue);
            }

            return this;
        }

        public static int archiveEndpointId()
        {
            return 24;
        }

        public static String archiveEndpointCharacterEncoding()
        {
            return "US-ASCII";
        }

        public static String archiveEndpointMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int archiveEndpointHeaderLength()
        {
            return 4;
        }

        public PassiveMembersEncoder putArchiveEndpoint(final DirectBuffer src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public PassiveMembersEncoder putArchiveEndpoint(final byte[] src, final int srcOffset, final int length)
        {
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public PassiveMembersEncoder archiveEndpoint(final String value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putStringWithoutLengthAscii(limit + headerLength, value);

            return this;
        }

        public PassiveMembersEncoder archiveEndpoint(final CharSequence value)
        {
            final int length = null == value ? 0 : value.length();
            if (length > 1073741824)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < length; ++i)
            {
                final char charValue = value.charAt(i);
                final byte byteValue = charValue > 127 ? (byte)'?' : (byte)charValue;
                buffer.putByte(limit + headerLength + i, byteValue);
            }

            return this;
        }
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final ClusterMembersExtendedResponseDecoder decoder = new ClusterMembersExtendedResponseDecoder();
        decoder.wrap(buffer, initialOffset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
