/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;


/**
 * Type the time unit used for timestamps.
 */
public enum ClusterTimeUnit
{

    /**
     * Time unit of milliseconds for timestamps.
     */
    MILLIS(0),


    /**
     * Time unit of microseconds for timestamps.
     */
    MICROS(1),


    /**
     * Time unit of nanoseconds for timestamps.
     */
    NANOS(2),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    ClusterTimeUnit(final int value)
    {
        this.value = value;
    }

    /**
     * The raw encoded value in the Java type representation.
     *
     * @return the raw value encoded.
     */
    public int value()
    {
        return value;
    }

    /**
     * Lookup the enum value representing the value.
     *
     * @param value encoded to be looked up.
     * @return the enum value representing the value.
     */
    public static ClusterTimeUnit get(final int value)
    {
        switch (value)
        {
            case 0: return MILLIS;
            case 1: return MICROS;
            case 2: return NANOS;
            case -2147483648: return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
