/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;

import org.agrona.DirectBuffer;


/**
 * Remove a cluster member either as normal member or passive member.
 */
@SuppressWarnings("all")
public final class RemoveMemberDecoder
{
    public static final int BLOCK_LENGTH = 8;
    public static final int TEMPLATE_ID = 35;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 6;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final RemoveMemberDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public RemoveMemberDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int memberIdId()
    {
        return 1;
    }

    public static int memberIdSinceVersion()
    {
        return 0;
    }

    public static int memberIdEncodingOffset()
    {
        return 0;
    }

    public static int memberIdEncodingLength()
    {
        return 4;
    }

    public static String memberIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int memberIdNullValue()
    {
        return -2147483648;
    }

    public static int memberIdMinValue()
    {
        return -2147483647;
    }

    public static int memberIdMaxValue()
    {
        return 2147483647;
    }

    public int memberId()
    {
        return buffer.getInt(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int isPassiveId()
    {
        return 2;
    }

    public static int isPassiveSinceVersion()
    {
        return 0;
    }

    public static int isPassiveEncodingOffset()
    {
        return 4;
    }

    public static int isPassiveEncodingLength()
    {
        return 4;
    }

    public static String isPassiveMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public int isPassiveRaw()
    {
        return buffer.getInt(offset + 4, java.nio.ByteOrder.LITTLE_ENDIAN);
    }

    public BooleanType isPassive()
    {
        return BooleanType.get(buffer.getInt(offset + 4, java.nio.ByteOrder.LITTLE_ENDIAN));
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final RemoveMemberDecoder decoder = new RemoveMemberDecoder();
        decoder.wrap(buffer, initialOffset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(initialOffset + actingBlockLength);
        builder.append("[RemoveMember](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("memberId=");
        builder.append(memberId());
        builder.append('|');
        builder.append("isPassive=");
        builder.append(isPassive());

        limit(originalLimit);

        return builder;
    }
}
