/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;


/**
 * Mark within a snapshot.
 */
public enum SnapshotMark
{

    /**
     * Begin marker for a snapshot.
     */
    BEGIN(0),


    /**
     * Section marker for a snapshot.
     */
    SECTION(1),


    /**
     * End marker for a snapshot.
     */
    END(2),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    SnapshotMark(final int value)
    {
        this.value = value;
    }

    /**
     * The raw encoded value in the Java type representation.
     *
     * @return the raw value encoded.
     */
    public int value()
    {
        return value;
    }

    /**
     * Lookup the enum value representing the value.
     *
     * @param value encoded to be looked up.
     * @return the enum value representing the value.
     */
    public static SnapshotMark get(final int value)
    {
        switch (value)
        {
            case 0: return BEGIN;
            case 1: return SECTION;
            case 2: return END;
            case -2147483648: return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
