/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs.mark;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;


/**
 * Header of Consensus Module and Container Mark file.
 */
@SuppressWarnings("all")
public final class MarkFileHeaderEncoder
{
    public static final int BLOCK_LENGTH = 128;
    public static final int TEMPLATE_ID = 200;
    public static final int SCHEMA_ID = 110;
    public static final int SCHEMA_VERSION = 0;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final MarkFileHeaderEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public MarkFileHeaderEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public MarkFileHeaderEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int versionId()
    {
        return 1;
    }

    public static int versionSinceVersion()
    {
        return 0;
    }

    public static int versionEncodingOffset()
    {
        return 0;
    }

    public static int versionEncodingLength()
    {
        return 4;
    }

    public static String versionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int versionNullValue()
    {
        return -2147483648;
    }

    public static int versionMinValue()
    {
        return -2147483647;
    }

    public static int versionMaxValue()
    {
        return 2147483647;
    }

    public MarkFileHeaderEncoder version(final int value)
    {
        buffer.putInt(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int componentTypeId()
    {
        return 2;
    }

    public static int componentTypeSinceVersion()
    {
        return 0;
    }

    public static int componentTypeEncodingOffset()
    {
        return 4;
    }

    public static int componentTypeEncodingLength()
    {
        return 4;
    }

    public static String componentTypeMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public MarkFileHeaderEncoder componentType(final ClusterComponentType value)
    {
        buffer.putInt(offset + 4, value.value(), java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int activityTimestampId()
    {
        return 3;
    }

    public static int activityTimestampSinceVersion()
    {
        return 0;
    }

    public static int activityTimestampEncodingOffset()
    {
        return 8;
    }

    public static int activityTimestampEncodingLength()
    {
        return 8;
    }

    public static String activityTimestampMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long activityTimestampNullValue()
    {
        return -9223372036854775808L;
    }

    public static long activityTimestampMinValue()
    {
        return -9223372036854775807L;
    }

    public static long activityTimestampMaxValue()
    {
        return 9223372036854775807L;
    }

    public MarkFileHeaderEncoder activityTimestamp(final long value)
    {
        buffer.putLong(offset + 8, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int startTimestampId()
    {
        return 4;
    }

    public static int startTimestampSinceVersion()
    {
        return 0;
    }

    public static int startTimestampEncodingOffset()
    {
        return 16;
    }

    public static int startTimestampEncodingLength()
    {
        return 8;
    }

    public static String startTimestampMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long startTimestampNullValue()
    {
        return -9223372036854775808L;
    }

    public static long startTimestampMinValue()
    {
        return -9223372036854775807L;
    }

    public static long startTimestampMaxValue()
    {
        return 9223372036854775807L;
    }

    public MarkFileHeaderEncoder startTimestamp(final long value)
    {
        buffer.putLong(offset + 16, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int pidId()
    {
        return 5;
    }

    public static int pidSinceVersion()
    {
        return 0;
    }

    public static int pidEncodingOffset()
    {
        return 24;
    }

    public static int pidEncodingLength()
    {
        return 8;
    }

    public static String pidMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long pidNullValue()
    {
        return -9223372036854775808L;
    }

    public static long pidMinValue()
    {
        return -9223372036854775807L;
    }

    public static long pidMaxValue()
    {
        return 9223372036854775807L;
    }

    public MarkFileHeaderEncoder pid(final long value)
    {
        buffer.putLong(offset + 24, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int candidateTermIdId()
    {
        return 6;
    }

    public static int candidateTermIdSinceVersion()
    {
        return 0;
    }

    public static int candidateTermIdEncodingOffset()
    {
        return 32;
    }

    public static int candidateTermIdEncodingLength()
    {
        return 8;
    }

    public static String candidateTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long candidateTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long candidateTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long candidateTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public MarkFileHeaderEncoder candidateTermId(final long value)
    {
        buffer.putLong(offset + 32, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int archiveStreamIdId()
    {
        return 7;
    }

    public static int archiveStreamIdSinceVersion()
    {
        return 0;
    }

    public static int archiveStreamIdEncodingOffset()
    {
        return 40;
    }

    public static int archiveStreamIdEncodingLength()
    {
        return 4;
    }

    public static String archiveStreamIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int archiveStreamIdNullValue()
    {
        return -2147483648;
    }

    public static int archiveStreamIdMinValue()
    {
        return -2147483647;
    }

    public static int archiveStreamIdMaxValue()
    {
        return 2147483647;
    }

    public MarkFileHeaderEncoder archiveStreamId(final int value)
    {
        buffer.putInt(offset + 40, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int serviceStreamIdId()
    {
        return 8;
    }

    public static int serviceStreamIdSinceVersion()
    {
        return 0;
    }

    public static int serviceStreamIdEncodingOffset()
    {
        return 44;
    }

    public static int serviceStreamIdEncodingLength()
    {
        return 4;
    }

    public static String serviceStreamIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int serviceStreamIdNullValue()
    {
        return -2147483648;
    }

    public static int serviceStreamIdMinValue()
    {
        return -2147483647;
    }

    public static int serviceStreamIdMaxValue()
    {
        return 2147483647;
    }

    public MarkFileHeaderEncoder serviceStreamId(final int value)
    {
        buffer.putInt(offset + 44, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int consensusModuleStreamIdId()
    {
        return 9;
    }

    public static int consensusModuleStreamIdSinceVersion()
    {
        return 0;
    }

    public static int consensusModuleStreamIdEncodingOffset()
    {
        return 48;
    }

    public static int consensusModuleStreamIdEncodingLength()
    {
        return 4;
    }

    public static String consensusModuleStreamIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int consensusModuleStreamIdNullValue()
    {
        return -2147483648;
    }

    public static int consensusModuleStreamIdMinValue()
    {
        return -2147483647;
    }

    public static int consensusModuleStreamIdMaxValue()
    {
        return 2147483647;
    }

    public MarkFileHeaderEncoder consensusModuleStreamId(final int value)
    {
        buffer.putInt(offset + 48, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int ingressStreamIdId()
    {
        return 10;
    }

    public static int ingressStreamIdSinceVersion()
    {
        return 0;
    }

    public static int ingressStreamIdEncodingOffset()
    {
        return 52;
    }

    public static int ingressStreamIdEncodingLength()
    {
        return 4;
    }

    public static String ingressStreamIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int ingressStreamIdNullValue()
    {
        return -2147483648;
    }

    public static int ingressStreamIdMinValue()
    {
        return -2147483647;
    }

    public static int ingressStreamIdMaxValue()
    {
        return 2147483647;
    }

    public MarkFileHeaderEncoder ingressStreamId(final int value)
    {
        buffer.putInt(offset + 52, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int memberIdId()
    {
        return 11;
    }

    public static int memberIdSinceVersion()
    {
        return 0;
    }

    public static int memberIdEncodingOffset()
    {
        return 56;
    }

    public static int memberIdEncodingLength()
    {
        return 4;
    }

    public static String memberIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int memberIdNullValue()
    {
        return -2147483648;
    }

    public static int memberIdMinValue()
    {
        return -2147483647;
    }

    public static int memberIdMaxValue()
    {
        return 2147483647;
    }

    public MarkFileHeaderEncoder memberId(final int value)
    {
        buffer.putInt(offset + 56, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int serviceIdId()
    {
        return 12;
    }

    public static int serviceIdSinceVersion()
    {
        return 0;
    }

    public static int serviceIdEncodingOffset()
    {
        return 60;
    }

    public static int serviceIdEncodingLength()
    {
        return 4;
    }

    public static String serviceIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int serviceIdNullValue()
    {
        return -2147483648;
    }

    public static int serviceIdMinValue()
    {
        return -2147483647;
    }

    public static int serviceIdMaxValue()
    {
        return 2147483647;
    }

    public MarkFileHeaderEncoder serviceId(final int value)
    {
        buffer.putInt(offset + 60, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int headerLengthId()
    {
        return 13;
    }

    public static int headerLengthSinceVersion()
    {
        return 0;
    }

    public static int headerLengthEncodingOffset()
    {
        return 64;
    }

    public static int headerLengthEncodingLength()
    {
        return 4;
    }

    public static String headerLengthMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int headerLengthNullValue()
    {
        return -2147483648;
    }

    public static int headerLengthMinValue()
    {
        return -2147483647;
    }

    public static int headerLengthMaxValue()
    {
        return 2147483647;
    }

    public MarkFileHeaderEncoder headerLength(final int value)
    {
        buffer.putInt(offset + 64, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int errorBufferLengthId()
    {
        return 14;
    }

    public static int errorBufferLengthSinceVersion()
    {
        return 0;
    }

    public static int errorBufferLengthEncodingOffset()
    {
        return 68;
    }

    public static int errorBufferLengthEncodingLength()
    {
        return 4;
    }

    public static String errorBufferLengthMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int errorBufferLengthNullValue()
    {
        return -2147483648;
    }

    public static int errorBufferLengthMinValue()
    {
        return -2147483647;
    }

    public static int errorBufferLengthMaxValue()
    {
        return 2147483647;
    }

    public MarkFileHeaderEncoder errorBufferLength(final int value)
    {
        buffer.putInt(offset + 68, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int clusterIdId()
    {
        return 15;
    }

    public static int clusterIdSinceVersion()
    {
        return 0;
    }

    public static int clusterIdEncodingOffset()
    {
        return 72;
    }

    public static int clusterIdEncodingLength()
    {
        return 4;
    }

    public static String clusterIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int clusterIdNullValue()
    {
        return -2147483648;
    }

    public static int clusterIdMinValue()
    {
        return -2147483647;
    }

    public static int clusterIdMaxValue()
    {
        return 2147483647;
    }

    public MarkFileHeaderEncoder clusterId(final int value)
    {
        buffer.putInt(offset + 72, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int aeronDirectoryId()
    {
        return 16;
    }

    public static String aeronDirectoryCharacterEncoding()
    {
        return "US-ASCII";
    }

    public static String aeronDirectoryMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int aeronDirectoryHeaderLength()
    {
        return 4;
    }

    public MarkFileHeaderEncoder putAeronDirectory(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MarkFileHeaderEncoder putAeronDirectory(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MarkFileHeaderEncoder aeronDirectory(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public MarkFileHeaderEncoder aeronDirectory(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < length; ++i)
        {
            final char charValue = value.charAt(i);
            final byte byteValue = charValue > 127 ? (byte)'?' : (byte)charValue;
            buffer.putByte(limit + headerLength + i, byteValue);
        }

        return this;
    }

    public static int controlChannelId()
    {
        return 17;
    }

    public static String controlChannelCharacterEncoding()
    {
        return "US-ASCII";
    }

    public static String controlChannelMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int controlChannelHeaderLength()
    {
        return 4;
    }

    public MarkFileHeaderEncoder putControlChannel(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MarkFileHeaderEncoder putControlChannel(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MarkFileHeaderEncoder controlChannel(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public MarkFileHeaderEncoder controlChannel(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < length; ++i)
        {
            final char charValue = value.charAt(i);
            final byte byteValue = charValue > 127 ? (byte)'?' : (byte)charValue;
            buffer.putByte(limit + headerLength + i, byteValue);
        }

        return this;
    }

    public static int ingressChannelId()
    {
        return 18;
    }

    public static String ingressChannelCharacterEncoding()
    {
        return "US-ASCII";
    }

    public static String ingressChannelMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int ingressChannelHeaderLength()
    {
        return 4;
    }

    public MarkFileHeaderEncoder putIngressChannel(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MarkFileHeaderEncoder putIngressChannel(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MarkFileHeaderEncoder ingressChannel(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public MarkFileHeaderEncoder ingressChannel(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < length; ++i)
        {
            final char charValue = value.charAt(i);
            final byte byteValue = charValue > 127 ? (byte)'?' : (byte)charValue;
            buffer.putByte(limit + headerLength + i, byteValue);
        }

        return this;
    }

    public static int serviceNameId()
    {
        return 19;
    }

    public static String serviceNameCharacterEncoding()
    {
        return "US-ASCII";
    }

    public static String serviceNameMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int serviceNameHeaderLength()
    {
        return 4;
    }

    public MarkFileHeaderEncoder putServiceName(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MarkFileHeaderEncoder putServiceName(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MarkFileHeaderEncoder serviceName(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public MarkFileHeaderEncoder serviceName(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < length; ++i)
        {
            final char charValue = value.charAt(i);
            final byte byteValue = charValue > 127 ? (byte)'?' : (byte)charValue;
            buffer.putByte(limit + headerLength + i, byteValue);
        }

        return this;
    }

    public static int authenticatorId()
    {
        return 20;
    }

    public static String authenticatorCharacterEncoding()
    {
        return "US-ASCII";
    }

    public static String authenticatorMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int authenticatorHeaderLength()
    {
        return 4;
    }

    public MarkFileHeaderEncoder putAuthenticator(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MarkFileHeaderEncoder putAuthenticator(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public MarkFileHeaderEncoder authenticator(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public MarkFileHeaderEncoder authenticator(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < length; ++i)
        {
            final char charValue = value.charAt(i);
            final byte byteValue = charValue > 127 ? (byte)'?' : (byte)charValue;
            buffer.putByte(limit + headerLength + i, byteValue);
        }

        return this;
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final MarkFileHeaderDecoder decoder = new MarkFileHeaderDecoder();
        decoder.wrap(buffer, initialOffset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
