/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.checksum;

import io.aeron.archive.checksum.Checksum;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import org.agrona.LangUtil;

final class Crc32c
implements Checksum {
    private static final MethodHandle UPDATE_DIRECT_BYTE_BUFFER;
    public static final Crc32c INSTANCE;

    private static int bitwiseComplement(int value) {
        return ~value;
    }

    private Crc32c() {
    }

    @Override
    public int compute(long address, int offset, int length) {
        try {
            return UPDATE_DIRECT_BYTE_BUFFER.invokeExact(address, offset, offset + length);
        }
        catch (Throwable throwable) {
            LangUtil.rethrowUnchecked(throwable);
            return -1;
        }
    }

    static {
        MethodHandle methodHandle = null;
        try {
            Class<?> klass = Class.forName("java.util.zip.CRC32C");
            Method method = klass.getDeclaredMethod("updateDirectByteBuffer", Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            methodHandle = lookup.unreflect(method);
            MethodHandle bitwiseComplement = lookup.findStatic(Crc32c.class, "bitwiseComplement", MethodType.methodType(Integer.TYPE, Integer.TYPE));
            methodHandle = MethodHandles.insertArguments(methodHandle, 0, -1);
            methodHandle = MethodHandles.filterReturnValue(methodHandle, bitwiseComplement);
        }
        catch (ClassNotFoundException klass) {
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            throw new Error("Failed to acquire method handle", ex);
        }
        UPDATE_DIRECT_BYTE_BUFFER = methodHandle;
        INSTANCE = null != methodHandle ? new Crc32c() : null;
    }
}

