/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.FragmentAssembler;
import io.aeron.Subscription;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.client.ControlResponseListener;
import io.aeron.archive.client.RecordingDescriptorConsumer;
import io.aeron.archive.codecs.ControlResponseDecoder;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.RecordingDescriptorDecoder;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;

public class ControlResponseAdapter
implements FragmentHandler {
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ControlResponseDecoder controlResponseDecoder = new ControlResponseDecoder();
    private final RecordingDescriptorDecoder recordingDescriptorDecoder = new RecordingDescriptorDecoder();
    private final int fragmentLimit;
    private final ControlResponseListener listener;
    private final Subscription subscription;
    private final FragmentAssembler fragmentAssembler = new FragmentAssembler(this);

    public ControlResponseAdapter(ControlResponseListener listener, Subscription subscription, int fragmentLimit) {
        this.fragmentLimit = fragmentLimit;
        this.listener = listener;
        this.subscription = subscription;
    }

    public int poll() {
        return this.subscription.poll(this.fragmentAssembler, this.fragmentLimit);
    }

    public static void dispatchDescriptor(RecordingDescriptorDecoder decoder, RecordingDescriptorConsumer consumer) {
        consumer.onRecordingDescriptor(decoder.controlSessionId(), decoder.correlationId(), decoder.recordingId(), decoder.startTimestamp(), decoder.stopTimestamp(), decoder.startPosition(), decoder.stopPosition(), decoder.initialTermId(), decoder.segmentFileLength(), decoder.termBufferLength(), decoder.mtuLength(), decoder.sessionId(), decoder.streamId(), decoder.strippedChannel(), decoder.originalChannel(), decoder.sourceIdentity());
    }

    @Override
    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 101) {
            throw new ArchiveException("expected schemaId=101, actual=" + schemaId);
        }
        switch (this.messageHeaderDecoder.templateId()) {
            case 1: {
                this.handleControlResponse(this.listener, buffer, offset);
                break;
            }
            case 22: {
                this.handleRecordingDescriptor(this.listener, buffer, offset);
            }
        }
    }

    private void handleControlResponse(ControlResponseListener listener, DirectBuffer buffer, int offset) {
        this.controlResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
        listener.onResponse(this.controlResponseDecoder.controlSessionId(), this.controlResponseDecoder.correlationId(), this.controlResponseDecoder.relevantId(), this.controlResponseDecoder.code(), this.controlResponseDecoder.errorMessage());
    }

    private void handleRecordingDescriptor(ControlResponseListener listener, DirectBuffer buffer, int offset) {
        this.recordingDescriptorDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
        ControlResponseAdapter.dispatchDescriptor(this.recordingDescriptorDecoder, listener);
    }
}

