/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.ChannelUriStringBuilder;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.cluster.ClusterMember;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.ConsensusPublisher;
import io.aeron.cluster.ElectionState;
import io.aeron.cluster.LogReplay;
import io.aeron.cluster.RecordingLog;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.ChangeType;
import io.aeron.cluster.service.Cluster;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.TimeoutException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.agrona.CloseHelper;
import org.agrona.LangUtil;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.AgentTerminationException;

class Election {
    private final boolean isNodeStartup;
    private boolean isLeaderStartup;
    private boolean isExtendedCanvass;
    private int logSessionId = -1;
    private long timeOfLastStateChangeNs;
    private long timeOfLastUpdateNs;
    private long nominationDeadlineNs;
    private long logPosition;
    private long appendPosition;
    private long catchupPosition = -1L;
    private long leadershipTermId;
    private long logLeadershipTermId;
    private long candidateTermId = -1L;
    private ClusterMember leaderMember = null;
    private ElectionState state = ElectionState.INIT;
    private Subscription logSubscription = null;
    private LogReplay logReplay = null;
    private ClusterMember[] clusterMembers;
    private final ClusterMember thisMember;
    private final Int2ObjectHashMap<ClusterMember> clusterMemberByIdMap;
    private final ConsensusPublisher consensusPublisher;
    private final ConsensusModule.Context ctx;
    private final ConsensusModuleAgent consensusModuleAgent;

    Election(boolean isNodeStartup, long leadershipTermId, long logPosition, long appendPosition, ClusterMember[] clusterMembers, Int2ObjectHashMap<ClusterMember> clusterMemberByIdMap, ClusterMember thisMember, ConsensusPublisher consensusPublisher, ConsensusModule.Context ctx, ConsensusModuleAgent consensusModuleAgent) {
        this.isNodeStartup = isNodeStartup;
        this.isExtendedCanvass = isNodeStartup;
        this.logPosition = logPosition;
        this.appendPosition = appendPosition;
        this.logLeadershipTermId = leadershipTermId;
        this.leadershipTermId = leadershipTermId;
        this.clusterMembers = clusterMembers;
        this.clusterMemberByIdMap = clusterMemberByIdMap;
        this.thisMember = thisMember;
        this.consensusPublisher = consensusPublisher;
        this.ctx = ctx;
        this.consensusModuleAgent = consensusModuleAgent;
        Objects.requireNonNull(thisMember);
        ctx.electionStateCounter().setOrdered(ElectionState.INIT.code());
    }

    ClusterMember leader() {
        return this.leaderMember;
    }

    long leadershipTermId() {
        return this.leadershipTermId;
    }

    long logPosition() {
        return this.logPosition;
    }

    boolean isLeaderStartup() {
        return this.isLeaderStartup;
    }

    int doWork(long nowNs) {
        int workCount = ElectionState.INIT == this.state ? this.init(nowNs) : 0;
        try {
            switch (this.state) {
                case CANVASS: {
                    workCount += this.canvass(nowNs);
                    break;
                }
                case NOMINATE: {
                    workCount += this.nominate(nowNs);
                    break;
                }
                case CANDIDATE_BALLOT: {
                    workCount += this.candidateBallot(nowNs);
                    break;
                }
                case FOLLOWER_BALLOT: {
                    workCount += this.followerBallot(nowNs);
                    break;
                }
                case LEADER_REPLAY: {
                    workCount += this.leaderReplay(nowNs);
                    break;
                }
                case LEADER_INIT: {
                    workCount += this.leaderInit(nowNs);
                    break;
                }
                case LEADER_READY: {
                    workCount += this.leaderReady(nowNs);
                    break;
                }
                case FOLLOWER_REPLAY: {
                    workCount += this.followerReplay(nowNs);
                    break;
                }
                case FOLLOWER_CATCHUP_INIT: {
                    workCount += this.followerCatchupInit(nowNs);
                    break;
                }
                case FOLLOWER_CATCHUP_AWAIT: {
                    workCount += this.followerCatchupAwait(nowNs);
                    break;
                }
                case FOLLOWER_CATCHUP: {
                    workCount += this.followerCatchup(nowNs);
                    break;
                }
                case FOLLOWER_LOG_INIT: {
                    workCount += this.followerLogInit(nowNs);
                    break;
                }
                case FOLLOWER_LOG_AWAIT: {
                    workCount += this.followerLogAwait(nowNs);
                    break;
                }
                case FOLLOWER_READY: {
                    workCount += this.followerReady(nowNs);
                }
            }
        }
        catch (Exception ex) {
            this.handleError(nowNs, ex);
        }
        return workCount;
    }

    void handleError(long nowNs, Exception ex) {
        this.ctx.countedErrorHandler().onError(ex);
        this.logPosition = this.ctx.commitPositionCounter().getWeak();
        this.state(ElectionState.INIT, nowNs);
        if (ex instanceof AgentTerminationException || ex instanceof InterruptedException) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    void onMembershipChange(ClusterMember[] clusterMembers, ChangeType changeType, int memberId, long logPosition) {
        ClusterMember.copyVotes(this.clusterMembers, clusterMembers);
        this.clusterMembers = clusterMembers;
        if (ChangeType.QUIT == changeType && ElectionState.FOLLOWER_CATCHUP == this.state && this.leaderMember.id() == memberId) {
            this.logPosition = logPosition;
            this.state(ElectionState.INIT, this.ctx.clusterClock().timeNanos());
        }
    }

    void onCanvassPosition(long logLeadershipTermId, long logPosition, int followerMemberId) {
        ClusterMember follower = this.clusterMemberByIdMap.get(followerMemberId);
        if (null != follower && this.thisMember.id() != followerMemberId) {
            follower.leadershipTermId(logLeadershipTermId).logPosition(logPosition);
            if (ElectionState.LEADER_READY == this.state && logLeadershipTermId < this.leadershipTermId) {
                RecordingLog.Entry termEntry = this.ctx.recordingLog().getTermEntry(logLeadershipTermId + 1L);
                this.consensusPublisher.newLeadershipTerm(follower.publication(), logLeadershipTermId, termEntry.termBaseLogPosition, this.leadershipTermId, this.appendPosition, termEntry.timestamp, this.thisMember.id(), this.logSessionId, this.isLeaderStartup);
            } else if ((ElectionState.LEADER_INIT == this.state || ElectionState.LEADER_REPLAY == this.state) && logLeadershipTermId < this.leadershipTermId) {
                RecordingLog.Entry termEntry = this.ctx.recordingLog().findTermEntry(logLeadershipTermId + 1L);
                this.consensusPublisher.newLeadershipTerm(follower.publication(), null != termEntry ? logLeadershipTermId : this.logLeadershipTermId, null != termEntry ? termEntry.termBaseLogPosition : this.appendPosition, this.leadershipTermId, this.appendPosition, null != termEntry ? termEntry.timestamp : this.ctx.clusterClock().time(), this.thisMember.id(), this.logSessionId, this.isLeaderStartup);
            } else if (logLeadershipTermId > this.leadershipTermId) {
                throw new ClusterException("new leader detected", AeronException.Category.WARN);
            }
        }
    }

    void onRequestVote(long logLeadershipTermId, long logPosition, long candidateTermId, int candidateId) {
        if (this.isPassiveMember() || candidateId == this.thisMember.id()) {
            return;
        }
        if (candidateTermId <= this.leadershipTermId || candidateTermId <= this.candidateTermId) {
            this.placeVote(candidateTermId, candidateId, false);
        } else if (ClusterMember.compareLog(this.logLeadershipTermId, this.appendPosition, logLeadershipTermId, logPosition) > 0) {
            this.candidateTermId = candidateTermId;
            this.ctx.clusterMarkFile().candidateTermId(candidateTermId, this.ctx.fileSyncLevel());
            this.state(ElectionState.INIT, this.ctx.clusterClock().timeNanos());
            this.placeVote(candidateTermId, candidateId, false);
        } else {
            this.candidateTermId = candidateTermId;
            this.ctx.clusterMarkFile().candidateTermId(candidateTermId, this.ctx.fileSyncLevel());
            this.state(ElectionState.FOLLOWER_BALLOT, this.ctx.clusterClock().timeNanos());
            this.placeVote(candidateTermId, candidateId, true);
        }
    }

    void onVote(long candidateTermId, long logLeadershipTermId, long logPosition, int candidateMemberId, int followerMemberId, boolean vote) {
        ClusterMember follower = this.clusterMemberByIdMap.get(followerMemberId);
        if (ElectionState.CANDIDATE_BALLOT == this.state && candidateTermId == this.candidateTermId && candidateMemberId == this.thisMember.id() && null != follower) {
            follower.candidateTermId(candidateTermId).leadershipTermId(logLeadershipTermId).logPosition(logPosition).vote(vote ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    void onNewLeadershipTerm(long logLeadershipTermId, long logTruncatePosition, long leadershipTermId, long logPosition, long timestamp, int leaderMemberId, int logSessionId, boolean isStartup) {
        ClusterMember leader = this.clusterMemberByIdMap.get(leaderMemberId);
        if (null == leader || leaderMemberId == this.thisMember.id() && leadershipTermId == this.leadershipTermId) {
            return;
        }
        if (leadershipTermId > this.leadershipTermId && logLeadershipTermId == this.logLeadershipTermId && logTruncatePosition < this.appendPosition) {
            this.consensusModuleAgent.truncateLogEntry(logLeadershipTermId, logTruncatePosition);
            this.appendPosition = this.consensusModuleAgent.prepareForNewLeadership(logTruncatePosition);
            this.leaderMember = leader;
            this.isLeaderStartup = isStartup;
            this.leadershipTermId = leadershipTermId;
            this.candidateTermId = Math.max(leadershipTermId, this.candidateTermId);
            this.logSessionId = logSessionId;
            this.catchupPosition = logPosition;
            this.state(ElectionState.FOLLOWER_REPLAY, this.ctx.clusterClock().timeNanos());
        } else if ((ElectionState.FOLLOWER_BALLOT == this.state || ElectionState.CANDIDATE_BALLOT == this.state || ElectionState.CANVASS == this.state) && leadershipTermId == this.candidateTermId && this.appendPosition <= logPosition) {
            this.leaderMember = leader;
            this.isLeaderStartup = isStartup;
            this.leadershipTermId = leadershipTermId;
            this.logSessionId = logSessionId;
            this.catchupPosition = logPosition > this.appendPosition ? logPosition : -1L;
            this.state(ElectionState.FOLLOWER_REPLAY, this.ctx.clusterClock().timeNanos());
        } else if (ElectionState.CANVASS == this.state && ClusterMember.compareLog(this.logLeadershipTermId, this.appendPosition, leadershipTermId, logPosition) < 0) {
            this.leaderMember = leader;
            this.isLeaderStartup = isStartup;
            this.leadershipTermId = leadershipTermId;
            this.candidateTermId = leadershipTermId;
            this.logSessionId = logSessionId;
            this.catchupPosition = logPosition > this.appendPosition ? logPosition : -1L;
            this.state(ElectionState.FOLLOWER_REPLAY, this.ctx.clusterClock().timeNanos());
        }
    }

    void onAppendPosition(long leadershipTermId, long logPosition, int followerMemberId) {
        ClusterMember follower = this.clusterMemberByIdMap.get(followerMemberId);
        if (null != follower && leadershipTermId == this.leadershipTermId) {
            follower.leadershipTermId(leadershipTermId).logPosition(logPosition).timeOfLastAppendPositionNs(this.ctx.clusterClock().timeNanos());
            this.consensusModuleAgent.trackCatchupCompletion(follower, leadershipTermId);
        }
    }

    void onCommitPosition(long leadershipTermId, long logPosition, int leaderMemberId) {
        if (ElectionState.FOLLOWER_CATCHUP == this.state && -1L != this.catchupPosition && leadershipTermId == this.leadershipTermId && leaderMemberId == this.leaderMember.id()) {
            this.catchupPosition = Math.max(this.catchupPosition, logPosition);
        } else if (leadershipTermId > this.leadershipTermId && ElectionState.CANVASS != this.state) {
            throw new ClusterException("new leader detected", AeronException.Category.WARN);
        }
    }

    void onReplayNewLeadershipTermEvent(long logRecordingId, long leadershipTermId, long logPosition, long timestamp, long termBaseLogPosition) {
        if (ElectionState.FOLLOWER_CATCHUP == this.state) {
            RecordingLog recordingLog = this.ctx.recordingLog();
            for (long termId = Math.max(this.logLeadershipTermId, 0L); termId <= leadershipTermId; ++termId) {
                if (!recordingLog.isUnknown(termId - 1L)) {
                    recordingLog.commitLogPosition(termId - 1L, termBaseLogPosition);
                    recordingLog.force(this.ctx.fileSyncLevel());
                }
                if (!recordingLog.isUnknown(termId)) continue;
                recordingLog.appendTerm(logRecordingId, termId, termBaseLogPosition, timestamp);
                recordingLog.force(this.ctx.fileSyncLevel());
            }
            this.logLeadershipTermId = leadershipTermId;
            this.logPosition = logPosition;
        }
    }

    private int init(long nowNs) {
        if (!this.isNodeStartup) {
            this.resetCatchup();
            this.cleanupReplay();
            this.appendPosition = this.consensusModuleAgent.prepareForNewLeadership(this.logPosition);
            CloseHelper.close(this.logSubscription);
            this.logSubscription = null;
        }
        this.candidateTermId = Math.max(this.ctx.clusterMarkFile().candidateTermId(), this.leadershipTermId);
        if (this.clusterMembers.length == 1 && this.thisMember.id() == this.clusterMembers[0].id()) {
            this.leadershipTermId = this.candidateTermId = Math.max(this.leadershipTermId + 1L, this.candidateTermId + 1L);
            this.leaderMember = this.thisMember;
            this.state(ElectionState.LEADER_REPLAY, nowNs);
        } else {
            this.state(ElectionState.CANVASS, nowNs);
        }
        return 1;
    }

    private int canvass(long nowNs) {
        int workCount = 0;
        if (nowNs >= this.timeOfLastUpdateNs + this.ctx.electionStatusIntervalNs()) {
            this.timeOfLastUpdateNs = nowNs;
            for (ClusterMember member : this.clusterMembers) {
                if (member.id() == this.thisMember.id()) continue;
                this.consensusPublisher.canvassPosition(member.publication(), this.leadershipTermId, this.appendPosition, this.thisMember.id());
            }
            ++workCount;
        }
        if (this.isPassiveMember() || this.ctx.appointedLeaderId() != -1 && this.ctx.appointedLeaderId() != this.thisMember.id()) {
            return workCount;
        }
        long canvassDeadlineNs = this.timeOfLastStateChangeNs + (this.isExtendedCanvass ? this.ctx.startupCanvassTimeoutNs() : this.ctx.electionTimeoutNs());
        if (ClusterMember.isUnanimousCandidate(this.clusterMembers, this.thisMember) || ClusterMember.isQuorumCandidate(this.clusterMembers, this.thisMember) && nowNs >= canvassDeadlineNs) {
            long delayNs = (long)(this.ctx.random().nextDouble() * (double)(this.ctx.electionTimeoutNs() >> 1));
            this.nominationDeadlineNs = nowNs + delayNs;
            this.state(ElectionState.NOMINATE, nowNs);
            ++workCount;
        }
        return workCount;
    }

    private int nominate(long nowNs) {
        if (nowNs >= this.nominationDeadlineNs) {
            this.candidateTermId = Math.max(this.leadershipTermId + 1L, this.candidateTermId + 1L);
            ClusterMember.becomeCandidate(this.clusterMembers, this.candidateTermId, this.thisMember.id());
            this.ctx.clusterMarkFile().candidateTermId(this.candidateTermId, this.ctx.fileSyncLevel());
            this.state(ElectionState.CANDIDATE_BALLOT, nowNs);
            return 1;
        }
        return 0;
    }

    private int candidateBallot(long nowNs) {
        int workCount = 0;
        if (ClusterMember.hasWonVoteOnFullCount(this.clusterMembers, this.candidateTermId) || ClusterMember.hasMajorityVoteWithCanvassMembers(this.clusterMembers, this.candidateTermId)) {
            this.leaderMember = this.thisMember;
            this.leadershipTermId = this.candidateTermId;
            this.state(ElectionState.LEADER_REPLAY, nowNs);
            ++workCount;
        } else if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.electionTimeoutNs()) {
            if (ClusterMember.hasMajorityVote(this.clusterMembers, this.candidateTermId)) {
                this.leaderMember = this.thisMember;
                this.leadershipTermId = this.candidateTermId;
                this.state(ElectionState.LEADER_REPLAY, nowNs);
            } else {
                this.state(ElectionState.CANVASS, nowNs);
            }
            ++workCount;
        } else {
            for (ClusterMember member : this.clusterMembers) {
                if (member.isBallotSent()) continue;
                ++workCount;
                member.isBallotSent(this.consensusPublisher.requestVote(member.publication(), this.logLeadershipTermId, this.appendPosition, this.candidateTermId, this.thisMember.id()));
            }
        }
        return workCount;
    }

    private int followerBallot(long nowNs) {
        int workCount = 0;
        if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.electionTimeoutNs()) {
            this.state(ElectionState.CANVASS, nowNs);
            ++workCount;
        }
        return workCount;
    }

    private int leaderReplay(long nowNs) {
        int workCount = 0;
        if (null == this.logReplay) {
            if (this.logPosition < this.appendPosition) {
                this.logReplay = this.consensusModuleAgent.newLogReplay(this.logPosition, this.appendPosition);
            } else {
                this.state(ElectionState.LEADER_INIT, nowNs);
            }
            ++workCount;
            this.logSessionId = this.consensusModuleAgent.addLogPublication();
            this.isLeaderStartup = this.isNodeStartup;
            ClusterMember.resetLogPositions(this.clusterMembers, -1L);
            this.thisMember.leadershipTermId(this.leadershipTermId).logPosition(this.appendPosition);
        } else {
            workCount += this.logReplay.doWork();
            if (this.logReplay.isDone()) {
                this.cleanupReplay();
                this.logPosition = this.appendPosition;
                this.state(ElectionState.LEADER_INIT, nowNs);
            }
        }
        return workCount += this.publishNewLeadershipTermOnInterval(nowNs);
    }

    private int leaderInit(long nowNs) {
        this.consensusModuleAgent.becomeLeader(this.leadershipTermId, this.logPosition, this.logSessionId, this.isLeaderStartup);
        this.updateRecordingLog(nowNs);
        this.state(ElectionState.LEADER_READY, nowNs);
        return 1;
    }

    private int leaderReady(long nowNs) {
        int workCount = this.publishNewLeadershipTermOnInterval(nowNs);
        if (ClusterMember.haveVotersReachedPosition(this.clusterMembers, this.logPosition, this.leadershipTermId)) {
            if (this.consensusModuleAgent.electionComplete()) {
                this.state(ElectionState.CLOSED, nowNs);
            }
            ++workCount;
        }
        return workCount;
    }

    private int followerReplay(long nowNs) {
        int workCount = 0;
        if (null == this.logReplay) {
            ++workCount;
            if (this.logPosition < this.appendPosition) {
                this.logReplay = this.consensusModuleAgent.newLogReplay(this.logPosition, this.appendPosition);
            } else {
                this.state(-1L != this.catchupPosition ? ElectionState.FOLLOWER_CATCHUP_INIT : ElectionState.FOLLOWER_LOG_INIT, nowNs);
            }
        } else {
            workCount += this.logReplay.doWork();
            if (this.logReplay.isDone()) {
                this.cleanupReplay();
                this.logPosition = this.appendPosition;
                this.state(-1L != this.catchupPosition ? ElectionState.FOLLOWER_CATCHUP_INIT : ElectionState.FOLLOWER_LOG_INIT, nowNs);
            }
        }
        return workCount;
    }

    private int followerCatchupInit(long nowNs) {
        if (null == this.logSubscription) {
            this.logSubscription = this.addFollowerSubscription();
            this.addCatchupLogDestination();
        }
        if (this.sendCatchupPosition()) {
            this.timeOfLastUpdateNs = nowNs;
            this.consensusModuleAgent.catchupInitiated(nowNs);
            this.state(ElectionState.FOLLOWER_CATCHUP_AWAIT, nowNs);
        }
        return 1;
    }

    private int followerCatchupAwait(long nowNs) {
        int workCount = 0;
        Image image = this.logSubscription.imageBySessionId(this.logSessionId);
        if (null != image) {
            this.verifyLogImage(image);
            this.consensusModuleAgent.followLog(image, this.isLeaderStartup);
            this.state(ElectionState.FOLLOWER_CATCHUP, nowNs);
            ++workCount;
        } else {
            if (nowNs > this.timeOfLastUpdateNs + this.ctx.leaderHeartbeatIntervalNs() && this.sendCatchupPosition()) {
                this.timeOfLastUpdateNs = nowNs;
                ++workCount;
            }
            if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.leaderHeartbeatTimeoutNs()) {
                throw new TimeoutException("failed to join catchup log", AeronException.Category.WARN);
            }
        }
        return workCount;
    }

    private int followerCatchup(long nowNs) {
        int workCount = this.consensusModuleAgent.catchupPoll(this.catchupPosition, nowNs);
        if (null == this.consensusModuleAgent.liveLogDestination() && this.consensusModuleAgent.isCatchupNearLive(this.catchupPosition)) {
            this.addLiveLogDestination();
            ++workCount;
        }
        if (this.ctx.commitPositionCounter().getWeak() >= this.catchupPosition) {
            this.logPosition = this.catchupPosition;
            this.appendPosition = this.catchupPosition;
            this.updateRecordingLog(nowNs);
            this.consensusModuleAgent.leadershipTermId(this.leadershipTermId);
            this.timeOfLastUpdateNs = 0L;
            this.state(ElectionState.FOLLOWER_LOG_INIT, nowNs);
            ++workCount;
        }
        return workCount;
    }

    private int followerLogInit(long nowNs) {
        if (null == this.logSubscription) {
            this.logSubscription = this.addFollowerSubscription();
            this.addLiveLogDestination();
            this.state(ElectionState.FOLLOWER_LOG_AWAIT, nowNs);
        } else {
            this.state(ElectionState.FOLLOWER_READY, nowNs);
        }
        return 1;
    }

    private int followerLogAwait(long nowNs) {
        int workCount = 0;
        Image image = this.logSubscription.imageBySessionId(this.logSessionId);
        if (null != image) {
            this.verifyLogImage(image);
            this.consensusModuleAgent.leadershipTermId(this.leadershipTermId);
            this.consensusModuleAgent.followLog(image, this.isLeaderStartup);
            this.updateRecordingLog(nowNs);
            this.state(ElectionState.FOLLOWER_READY, nowNs);
            ++workCount;
        } else if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.leaderHeartbeatTimeoutNs()) {
            throw new TimeoutException("failed to join live log", AeronException.Category.WARN);
        }
        return workCount;
    }

    private int followerReady(long nowNs) {
        if (this.consensusPublisher.appendPosition(this.leaderMember.publication(), this.leadershipTermId, this.logPosition, this.thisMember.id())) {
            if (this.consensusModuleAgent.electionComplete()) {
                this.state(ElectionState.CLOSED, nowNs);
            }
        } else if (nowNs >= this.timeOfLastStateChangeNs + this.ctx.leaderHeartbeatTimeoutNs()) {
            throw new TimeoutException("ready follower failed to notify leader", AeronException.Category.WARN);
        }
        return 1;
    }

    private void placeVote(long candidateTermId, int candidateId, boolean vote) {
        ClusterMember candidate = this.clusterMemberByIdMap.get(candidateId);
        if (null != candidate) {
            this.consensusPublisher.placeVote(candidate.publication(), candidateTermId, this.logLeadershipTermId, this.appendPosition, candidateId, this.thisMember.id(), vote);
        }
    }

    private int publishNewLeadershipTermOnInterval(long nowNs) {
        int workCount = 0;
        if (nowNs > this.timeOfLastUpdateNs + this.ctx.leaderHeartbeatIntervalNs()) {
            this.timeOfLastUpdateNs = nowNs;
            this.publishNewLeadershipTerm(this.ctx.clusterClock().timeUnit().convert(nowNs, TimeUnit.NANOSECONDS));
            ++workCount;
        }
        return workCount;
    }

    private void publishNewLeadershipTerm(long timestamp) {
        for (ClusterMember member : this.clusterMembers) {
            if (member.id() == this.thisMember.id()) continue;
            this.consensusPublisher.newLeadershipTerm(member.publication(), this.logLeadershipTermId, this.appendPosition, this.leadershipTermId, this.appendPosition, timestamp, this.thisMember.id(), this.logSessionId, this.isLeaderStartup);
        }
    }

    private boolean sendCatchupPosition() {
        return this.consensusPublisher.catchupPosition(this.leaderMember.publication(), this.leadershipTermId, this.logPosition, this.thisMember.id());
    }

    private void addCatchupLogDestination() {
        String destination = "aeron:udp?endpoint=" + this.thisMember.catchupEndpoint();
        this.logSubscription.asyncAddDestination(destination);
        this.consensusModuleAgent.catchupLogDestination(destination);
    }

    private void addLiveLogDestination() {
        String destination = this.ctx.isLogMdc() ? "aeron:udp?endpoint=" + this.thisMember.logEndpoint() : this.ctx.logChannel();
        this.logSubscription.asyncAddDestination(destination);
        this.consensusModuleAgent.liveLogDestination(destination);
    }

    private Subscription addFollowerSubscription() {
        int streamId = this.ctx.logStreamId();
        String channel = new ChannelUriStringBuilder().media("udp").tags(this.ctx.aeron().nextCorrelationId() + "," + this.ctx.aeron().nextCorrelationId()).controlMode("manual").sessionId(this.logSessionId).group(Boolean.TRUE).rejoin(Boolean.FALSE).alias("log").build();
        return this.ctx.aeron().addSubscription(channel, streamId);
    }

    private void state(ElectionState newState, long nowNs) {
        if (newState != this.state) {
            this.stateChange(this.state, newState, this.thisMember.id());
            if (ElectionState.CANVASS == newState) {
                this.resetMembers();
            }
            if (ElectionState.CANVASS == this.state) {
                this.isExtendedCanvass = false;
            }
            switch (newState) {
                case CANVASS: 
                case NOMINATE: 
                case FOLLOWER_BALLOT: 
                case FOLLOWER_REPLAY: 
                case FOLLOWER_CATCHUP_INIT: 
                case FOLLOWER_CATCHUP: 
                case FOLLOWER_LOG_INIT: 
                case FOLLOWER_READY: 
                case INIT: {
                    this.consensusModuleAgent.role(Cluster.Role.FOLLOWER);
                    break;
                }
                case CANDIDATE_BALLOT: {
                    this.consensusModuleAgent.role(Cluster.Role.CANDIDATE);
                    break;
                }
                case LEADER_INIT: 
                case LEADER_READY: {
                    this.consensusModuleAgent.role(Cluster.Role.LEADER);
                }
            }
            this.state = newState;
            this.ctx.electionStateCounter().setOrdered(newState.code());
            this.timeOfLastStateChangeNs = nowNs;
        }
    }

    private void resetCatchup() {
        this.consensusModuleAgent.stopAllCatchups();
        this.catchupPosition = -1L;
    }

    private void resetMembers() {
        ClusterMember.reset(this.clusterMembers);
        this.thisMember.leadershipTermId(this.leadershipTermId).logPosition(this.appendPosition);
        this.leaderMember = null;
    }

    private void cleanupReplay() {
        if (null != this.logReplay) {
            this.logReplay.close();
            this.logReplay = null;
        }
    }

    private boolean isPassiveMember() {
        return null == ClusterMember.findMember(this.clusterMembers, this.thisMember.id());
    }

    private void updateRecordingLog(long nowNs) {
        RecordingLog recordingLog = this.ctx.recordingLog();
        long timestamp = this.ctx.clusterClock().timeUnit().convert(nowNs, TimeUnit.NANOSECONDS);
        long recordingId = this.consensusModuleAgent.logRecordingId();
        if (-1L == recordingId) {
            throw new AgentTerminationException("log recording id not found");
        }
        for (long termId = this.logLeadershipTermId + 1L; termId <= this.leadershipTermId; ++termId) {
            if (!recordingLog.isUnknown(termId)) continue;
            recordingLog.appendTerm(recordingId, termId, this.logPosition, timestamp);
            recordingLog.force(this.ctx.fileSyncLevel());
            this.logLeadershipTermId = termId;
        }
    }

    private void verifyLogImage(Image image) {
        if (image.joinPosition() != this.logPosition) {
            throw new ClusterException("joinPosition=" + image.joinPosition() + " != logPosition=" + this.logPosition, AeronException.Category.WARN);
        }
    }

    void stateChange(ElectionState oldState, ElectionState newState, int memberId) {
    }
}

