/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public final class ConsensusModuleDecoder {
    public static final int BLOCK_LENGTH = 28;
    public static final int TEMPLATE_ID = 105;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 6;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ConsensusModuleDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 28;
    }

    public int sbeTemplateId() {
        return 105;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 6;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ConsensusModuleDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int nextSessionIdId() {
        return 1;
    }

    public static int nextSessionIdSinceVersion() {
        return 0;
    }

    public static int nextSessionIdEncodingOffset() {
        return 0;
    }

    public static int nextSessionIdEncodingLength() {
        return 8;
    }

    public static String nextSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long nextSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long nextSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long nextSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long nextSessionId() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int nextServiceSessionIdId() {
        return 2;
    }

    public static int nextServiceSessionIdSinceVersion() {
        return 3;
    }

    public static int nextServiceSessionIdEncodingOffset() {
        return 8;
    }

    public static int nextServiceSessionIdEncodingLength() {
        return 8;
    }

    public static String nextServiceSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long nextServiceSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long nextServiceSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long nextServiceSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long nextServiceSessionId() {
        if (this.parentMessage.actingVersion < 3) {
            return Long.MIN_VALUE;
        }
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int logServiceSessionIdId() {
        return 3;
    }

    public static int logServiceSessionIdSinceVersion() {
        return 3;
    }

    public static int logServiceSessionIdEncodingOffset() {
        return 16;
    }

    public static int logServiceSessionIdEncodingLength() {
        return 8;
    }

    public static String logServiceSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long logServiceSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logServiceSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long logServiceSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long logServiceSessionId() {
        if (this.parentMessage.actingVersion < 3) {
            return Long.MIN_VALUE;
        }
        return this.buffer.getLong(this.offset + 16, ByteOrder.LITTLE_ENDIAN);
    }

    public static int pendingMessageCapacityId() {
        return 4;
    }

    public static int pendingMessageCapacitySinceVersion() {
        return 3;
    }

    public static int pendingMessageCapacityEncodingOffset() {
        return 24;
    }

    public static int pendingMessageCapacityEncodingLength() {
        return 4;
    }

    public static String pendingMessageCapacityMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int pendingMessageCapacityNullValue() {
        return 0;
    }

    public static int pendingMessageCapacityMinValue() {
        return -2147483647;
    }

    public static int pendingMessageCapacityMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int pendingMessageCapacity() {
        if (this.parentMessage.actingVersion < 3) {
            return 0;
        }
        return this.buffer.getInt(this.offset + 24, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ConsensusModuleDecoder decoder = new ConsensusModuleDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[ConsensusModule](sbeTemplateId=");
        builder.append(105);
        builder.append("|sbeSchemaId=");
        builder.append(111);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 6) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(6);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 28) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(28);
        builder.append("):");
        builder.append("nextSessionId=");
        builder.append(this.nextSessionId());
        builder.append('|');
        builder.append("nextServiceSessionId=");
        builder.append(this.nextServiceSessionId());
        builder.append('|');
        builder.append("logServiceSessionId=");
        builder.append(this.logServiceSessionId());
        builder.append('|');
        builder.append("pendingMessageCapacity=");
        builder.append(this.pendingMessageCapacity());
        this.limit(originalLimit);
        return builder;
    }
}

