/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.BooleanType;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.MetaAttribute;
import io.aeron.cluster.codecs.NewLeadershipTermDecoder;
import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;

public final class NewLeadershipTermEncoder {
    public static final int BLOCK_LENGTH = 56;
    public static final int TEMPLATE_ID = 53;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 6;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final NewLeadershipTermEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 56;
    }

    public int sbeTemplateId() {
        return 53;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 6;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public NewLeadershipTermEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 56);
        return this;
    }

    public NewLeadershipTermEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(56).templateId(53).schemaId(111).version(6);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int logLeadershipTermIdId() {
        return 1;
    }

    public static int logLeadershipTermIdSinceVersion() {
        return 0;
    }

    public static int logLeadershipTermIdEncodingOffset() {
        return 0;
    }

    public static int logLeadershipTermIdEncodingLength() {
        return 8;
    }

    public static String logLeadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logLeadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logLeadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long logLeadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public NewLeadershipTermEncoder logLeadershipTermId(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int logTruncatePositionId() {
        return 2;
    }

    public static int logTruncatePositionSinceVersion() {
        return 0;
    }

    public static int logTruncatePositionEncodingOffset() {
        return 8;
    }

    public static int logTruncatePositionEncodingLength() {
        return 8;
    }

    public static String logTruncatePositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logTruncatePositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logTruncatePositionMinValue() {
        return -9223372036854775807L;
    }

    public static long logTruncatePositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public NewLeadershipTermEncoder logTruncatePosition(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int leadershipTermIdId() {
        return 3;
    }

    public static int leadershipTermIdSinceVersion() {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset() {
        return 16;
    }

    public static int leadershipTermIdEncodingLength() {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long leadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long leadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public NewLeadershipTermEncoder leadershipTermId(long value) {
        this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int logPositionId() {
        return 4;
    }

    public static int logPositionSinceVersion() {
        return 0;
    }

    public static int logPositionEncodingOffset() {
        return 24;
    }

    public static int logPositionEncodingLength() {
        return 8;
    }

    public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public NewLeadershipTermEncoder logPosition(long value) {
        this.buffer.putLong(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int timestampId() {
        return 5;
    }

    public static int timestampSinceVersion() {
        return 0;
    }

    public static int timestampEncodingOffset() {
        return 32;
    }

    public static int timestampEncodingLength() {
        return 8;
    }

    public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long timestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long timestampMinValue() {
        return -9223372036854775807L;
    }

    public static long timestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public NewLeadershipTermEncoder timestamp(long value) {
        this.buffer.putLong(this.offset + 32, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int leaderMemberIdId() {
        return 6;
    }

    public static int leaderMemberIdSinceVersion() {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset() {
        return 40;
    }

    public static int leaderMemberIdEncodingLength() {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int leaderMemberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int leaderMemberIdMinValue() {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public NewLeadershipTermEncoder leaderMemberId(int value) {
        this.buffer.putInt(this.offset + 40, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int logSessionIdId() {
        return 7;
    }

    public static int logSessionIdSinceVersion() {
        return 0;
    }

    public static int logSessionIdEncodingOffset() {
        return 44;
    }

    public static int logSessionIdEncodingLength() {
        return 4;
    }

    public static String logSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int logSessionIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int logSessionIdMinValue() {
        return -2147483647;
    }

    public static int logSessionIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public NewLeadershipTermEncoder logSessionId(int value) {
        this.buffer.putInt(this.offset + 44, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int appVersionId() {
        return 8;
    }

    public static int appVersionSinceVersion() {
        return 0;
    }

    public static int appVersionEncodingOffset() {
        return 48;
    }

    public static int appVersionEncodingLength() {
        return 4;
    }

    public static String appVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int appVersionNullValue() {
        return 0;
    }

    public static int appVersionMinValue() {
        return 1;
    }

    public static int appVersionMaxValue() {
        return 0xFFFFFF;
    }

    public NewLeadershipTermEncoder appVersion(int value) {
        this.buffer.putInt(this.offset + 48, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int isStartupId() {
        return 9;
    }

    public static int isStartupSinceVersion() {
        return 0;
    }

    public static int isStartupEncodingOffset() {
        return 52;
    }

    public static int isStartupEncodingLength() {
        return 4;
    }

    public static String isStartupMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public NewLeadershipTermEncoder isStartup(BooleanType value) {
        this.buffer.putInt(this.offset + 52, value.value(), ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        NewLeadershipTermDecoder decoder = new NewLeadershipTermDecoder();
        decoder.wrap(this.buffer, this.initialOffset, 56, 6);
        return decoder.appendTo(builder);
    }
}

