/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public final class SnapshotRecordingQueryDecoder {
    public static final int BLOCK_LENGTH = 12;
    public static final int TEMPLATE_ID = 72;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 6;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final SnapshotRecordingQueryDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 12;
    }

    public int sbeTemplateId() {
        return 72;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 6;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public SnapshotRecordingQueryDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int correlationIdId() {
        return 1;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 0;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int requestMemberIdId() {
        return 2;
    }

    public static int requestMemberIdSinceVersion() {
        return 0;
    }

    public static int requestMemberIdEncodingOffset() {
        return 8;
    }

    public static int requestMemberIdEncodingLength() {
        return 4;
    }

    public static String requestMemberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int requestMemberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int requestMemberIdMinValue() {
        return -2147483647;
    }

    public static int requestMemberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int requestMemberId() {
        return this.buffer.getInt(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        SnapshotRecordingQueryDecoder decoder = new SnapshotRecordingQueryDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[SnapshotRecordingQuery](sbeTemplateId=");
        builder.append(72);
        builder.append("|sbeSchemaId=");
        builder.append(111);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 6) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(6);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 12) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(12);
        builder.append("):");
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("requestMemberId=");
        builder.append(this.requestMemberId());
        this.limit(originalLimit);
        return builder;
    }
}

