/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.Aeron;
import io.aeron.DirectBufferVector;
import io.aeron.Publication;
import io.aeron.cluster.service.ClusteredServiceAgent;
import io.aeron.exceptions.RegistrationException;
import io.aeron.logbuffer.BufferClaim;
import java.util.Arrays;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;

public final class ClientSession {
    public static final long MOCKED_OFFER = 1L;
    private final long id;
    private final int responseStreamId;
    private final String responseChannel;
    private final byte[] encodedPrincipal;
    private final ClusteredServiceAgent clusteredServiceAgent;
    private Publication responsePublication;
    private boolean isClosing;

    ClientSession(long sessionId, int responseStreamId, String responseChannel, byte[] encodedPrincipal, ClusteredServiceAgent clusteredServiceAgent) {
        this.id = sessionId;
        this.responseStreamId = responseStreamId;
        this.responseChannel = responseChannel;
        this.encodedPrincipal = encodedPrincipal;
        this.clusteredServiceAgent = clusteredServiceAgent;
    }

    public long id() {
        return this.id;
    }

    public int responseStreamId() {
        return this.responseStreamId;
    }

    public String responseChannel() {
        return this.responseChannel;
    }

    public byte[] encodedPrincipal() {
        return this.encodedPrincipal;
    }

    public void close() {
        if (null != this.clusteredServiceAgent.getClientSession(this.id)) {
            this.clusteredServiceAgent.closeClientSession(this.id);
        }
    }

    public boolean isClosing() {
        return this.isClosing;
    }

    public long offer(DirectBuffer buffer, int offset, int length) {
        return this.clusteredServiceAgent.offer(this.id, this.responsePublication, buffer, offset, length);
    }

    public long offer(DirectBufferVector[] vectors) {
        return this.clusteredServiceAgent.offer(this.id, this.responsePublication, vectors);
    }

    public long tryClaim(int length, BufferClaim bufferClaim) {
        return this.clusteredServiceAgent.tryClaim(this.id, this.responsePublication, length, bufferClaim);
    }

    void connect(Aeron aeron) {
        if (null == this.responsePublication) {
            try {
                this.responsePublication = aeron.addPublication(this.responseChannel, this.responseStreamId);
            }
            catch (RegistrationException ex) {
                this.clusteredServiceAgent.handleError(ex);
            }
        }
    }

    void markClosing() {
        this.isClosing = true;
    }

    void resetClosing() {
        this.isClosing = false;
    }

    void disconnect(ErrorHandler errorHandler) {
        CloseHelper.close(errorHandler, this.responsePublication);
        this.responsePublication = null;
    }

    public String toString() {
        return "ClientSession{id=" + this.id + ", responseStreamId=" + this.responseStreamId + ", responseChannel='" + this.responseChannel + '\'' + ", encodedPrincipal=" + Arrays.toString(this.encodedPrincipal) + ", clusteredServiceAgent=" + this.clusteredServiceAgent + ", responsePublication=" + this.responsePublication + ", isClosing=" + this.isClosing + '}';
    }
}

