/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.media.ReceiveChannelEndpoint;
import java.net.InetSocketAddress;

class PendingSetupMessageFromSource {
    private final int sessionId;
    private final int streamId;
    private final int transportIndex;
    private final boolean periodic;
    private final ReceiveChannelEndpoint channelEndpoint;
    private InetSocketAddress controlAddress;
    private long timeOfStatusMessageNs;

    PendingSetupMessageFromSource(int sessionId, int streamId, int transportIndex, ReceiveChannelEndpoint channelEndpoint, boolean periodic, InetSocketAddress controlAddress) {
        this.sessionId = sessionId;
        this.streamId = streamId;
        this.transportIndex = transportIndex;
        this.channelEndpoint = channelEndpoint;
        this.periodic = periodic;
        this.controlAddress = controlAddress;
    }

    int sessionId() {
        return this.sessionId;
    }

    int streamId() {
        return this.streamId;
    }

    int transportIndex() {
        return this.transportIndex;
    }

    ReceiveChannelEndpoint channelEndpoint() {
        return this.channelEndpoint;
    }

    boolean isPeriodic() {
        return this.periodic;
    }

    boolean shouldElicitSetupMessage() {
        return this.channelEndpoint.shouldElicitSetupMessage();
    }

    void controlAddress(InetSocketAddress newControlAddress) {
        this.controlAddress = newControlAddress;
    }

    InetSocketAddress controlAddress() {
        return this.controlAddress;
    }

    long timeOfStatusMessageNs() {
        return this.timeOfStatusMessageNs;
    }

    void timeOfStatusMessageNs(long nowNs) {
        this.timeOfStatusMessageNs = nowNs;
    }

    void removeFromDataPacketDispatcher() {
        this.channelEndpoint.removePendingSetup(this.sessionId, this.streamId);
    }
}

