/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.CommonContext;
import io.aeron.samples.SamplesUtil;
import java.io.File;
import java.nio.MappedByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.errors.ErrorLogReader;

public class ErrorStat {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");

    public static void main(String[] args) {
        File cncFile = CommonContext.newDefaultCncFile();
        System.out.println("Command `n Control file " + cncFile);
        MappedByteBuffer cncByteBuffer = SamplesUtil.mapExistingFileReadOnly(cncFile);
        AtomicBuffer buffer = CommonContext.errorLogBuffer(cncByteBuffer);
        int distinctErrorCount = ErrorLogReader.read(buffer, ErrorStat::accept);
        System.out.format("%n%d distinct errors observed.%n", distinctErrorCount);
    }

    private static void accept(int observationCount, long firstObservationTimestamp, long lastObservationTimestamp, String encodedException) {
        System.out.format("***%n%d observations from %s to %s for:%n %s%n", observationCount, DATE_FORMAT.format(new Date(firstObservationTimestamp)), DATE_FORMAT.format(new Date(lastObservationTimestamp)), encodedException);
    }
}

