/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.Image;
import io.aeron.ImageFragmentAssembler;
import io.aeron.Subscription;
import io.aeron.logbuffer.Header;
import io.aeron.samples.ImageRateSubscriberRhsPadding;
import io.aeron.samples.SampleConfiguration;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.DirectBuffer;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.IdleStrategy;

public final class ImageRateSubscriber
extends ImageRateSubscriberRhsPadding
implements Runnable {
    private final int fragmentLimit;
    private final AtomicBoolean running;
    private final Subscription subscription;

    public ImageRateSubscriber(int fragmentLimit, AtomicBoolean running, Subscription subscription) {
        this.fragmentLimit = fragmentLimit;
        this.running = running;
        this.subscription = subscription;
    }

    public long totalBytes() {
        return this.totalBytes;
    }

    @Override
    public void run() {
        while (!this.subscription.isConnected()) {
            Thread.yield();
        }
        Image image = this.subscription.images().get(0);
        ImageFragmentAssembler fragmentAssembler = new ImageFragmentAssembler(this::onFragment);
        IdleStrategy idleStrategy = SampleConfiguration.newIdleStrategy();
        int fragmentLimit = this.fragmentLimit;
        long failedPolls = 0L;
        long successfulPolls = 0L;
        while (this.running.get()) {
            int fragmentsRead = image.poll(fragmentAssembler, fragmentLimit);
            if (0 == fragmentsRead) {
                ++failedPolls;
            } else {
                ++successfulPolls;
            }
            idleStrategy.idle(fragmentsRead);
        }
        double failureRatio = (double)failedPolls / (double)(successfulPolls + failedPolls);
        System.out.format("Subscriber poll failure ratio: %f%n", failureRatio);
    }

    private void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, TOTAL_BYTES_OFFSET, this.totalBytes + (long)length);
    }
}

