/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.LogBuffers;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.DataHeaderFlyweight;
import java.io.PrintStream;
import java.util.Date;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class LogInspector {
    public static final String AERON_LOG_DATA_FORMAT_PROP_NAME = "aeron.log.inspector.data.format";
    public static final String AERON_LOG_DATA_FORMAT = System.getProperty("aeron.log.inspector.data.format", "hex").toLowerCase();
    public static final String AERON_LOG_SKIP_DEFAULT_HEADER_PROP_NAME = "aeron.log.inspector.skipDefaultHeader";
    public static final boolean AERON_LOG_SKIP_DEFAULT_HEADER = Boolean.getBoolean("aeron.log.inspector.skipDefaultHeader");
    public static final String AERON_LOG_SCAN_OVER_ZEROES_PROP_NAME = "aeron.log.inspector.scanOverZeroes";
    public static final boolean AERON_LOG_SCAN_OVER_ZEROES = Boolean.getBoolean("aeron.log.inspector.scanOverZeroes");
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static void main(String[] args) {
        PrintStream out = System.out;
        if (args.length < 1) {
            out.println("Usage: LogInspector <logFileName> [dump limit in bytes per message]");
            return;
        }
        String logFileName = args[0];
        int messageDumpLimit = args.length >= 2 ? Integer.parseInt(args[1]) : Integer.MAX_VALUE;
        try (LogBuffers logBuffers = new LogBuffers(logFileName);){
            int i;
            out.println("======================================================================");
            out.format("%s Inspection dump for %s%n", new Date(), logFileName);
            out.println("======================================================================");
            DataHeaderFlyweight dataHeaderFlyweight = new DataHeaderFlyweight();
            UnsafeBuffer[] termBuffers = logBuffers.duplicateTermBuffers();
            int termLength = logBuffers.termLength();
            UnsafeBuffer metaDataBuffer = logBuffers.metaDataBuffer();
            int initialTermId = LogBufferDescriptor.initialTermId(metaDataBuffer);
            out.format("   Is Connected: %s%n", LogBufferDescriptor.isConnected(metaDataBuffer));
            out.format("Initial term id: %d%n", initialTermId);
            out.format("     Term Count: %d%n", LogBufferDescriptor.activeTermCount(metaDataBuffer));
            out.format("   Active index: %d%n", LogBufferDescriptor.indexByTermCount(LogBufferDescriptor.activeTermCount(metaDataBuffer)));
            out.format("    Term length: %d%n", termLength);
            out.format("     MTU length: %d%n", LogBufferDescriptor.mtuLength(metaDataBuffer));
            out.format("      Page Size: %d%n", LogBufferDescriptor.pageSize(metaDataBuffer));
            out.format("   EOS Position: %d%n%n", LogBufferDescriptor.endOfStreamPosition(metaDataBuffer));
            if (!AERON_LOG_SKIP_DEFAULT_HEADER) {
                dataHeaderFlyweight.wrap(LogBufferDescriptor.defaultFrameHeader(metaDataBuffer));
                out.format("default %s%n", dataHeaderFlyweight);
            }
            out.println();
            for (i = 0; i < 3; ++i) {
                long rawTail = LogBufferDescriptor.rawTailVolatile(metaDataBuffer, i);
                long termOffset = rawTail & 0xFFFFFFFFL;
                int termId = LogBufferDescriptor.termId(rawTail);
                int offset = (int)Math.min(termOffset, (long)termLength);
                int positionBitsToShift = LogBufferDescriptor.positionBitsToShift(termLength);
                out.format("Index %d Term Meta Data termOffset=%d termId=%d rawTail=%d position=%d%n", i, termOffset, termId, rawTail, LogBufferDescriptor.computePosition(termId, offset, positionBitsToShift, initialTermId));
            }
            block12: for (i = 0; i < 3; ++i) {
                out.println();
                out.println("======================================================================");
                out.format("Index %d Term Data%n%n", i);
                UnsafeBuffer termBuffer = termBuffers[i];
                int offset = 0;
                do {
                    int limit;
                    dataHeaderFlyweight.wrap(termBuffer, offset, termLength - offset);
                    out.println(offset + ": " + dataHeaderFlyweight.toString());
                    int frameLength = dataHeaderFlyweight.frameLength();
                    if (frameLength < 32) {
                        if (0 == frameLength && AERON_LOG_SCAN_OVER_ZEROES) {
                            offset += 32;
                            continue;
                        }
                        try {
                            limit = Math.min(termLength - (offset + 32), messageDumpLimit);
                            out.println(LogInspector.formatBytes(termBuffer, offset + 32, limit));
                        }
                        catch (Exception ex) {
                            System.err.printf("frameLength=%d offset=%d%n", frameLength, offset);
                            ex.printStackTrace();
                        }
                        continue block12;
                    }
                    limit = Math.min(frameLength - 32, messageDumpLimit);
                    out.println(LogInspector.formatBytes(termBuffer, offset + 32, limit));
                    offset += BitUtil.align(frameLength, 32);
                } while (offset < termLength);
            }
        }
    }

    public static char[] formatBytes(DirectBuffer buffer, int offset, int length) {
        switch (AERON_LOG_DATA_FORMAT) {
            case "us-ascii": 
            case "us_ascii": 
            case "ascii": {
                return LogInspector.bytesToAscii(buffer, offset, length);
            }
        }
        return LogInspector.bytesToHex(buffer, offset, length);
    }

    private static char[] bytesToAscii(DirectBuffer buffer, int offset, int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            byte b = buffer.getByte(offset + i);
            if (b < 0) {
                b = 0;
            }
            chars[i] = (char)b;
        }
        return chars;
    }

    public static char[] bytesToHex(DirectBuffer buffer, int offset, int length) {
        char[] chars = new char[length * 2];
        for (int i = 0; i < length; ++i) {
            int b = buffer.getByte(offset + i) & 0xFF;
            chars[i * 2] = HEX_ARRAY[b >>> 4];
            chars[i * 2 + 1] = HEX_ARRAY[b & 0xF];
        }
        return chars;
    }
}

